/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorOperators;
import com.launchdarkly.sdk.server.EvaluatorPreprocessing;
import com.launchdarkly.sdk.server.EventFactory;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Evaluator {
    private static final Logger logger = LoggerFactory.getLogger(Evaluator.class);
    static final String INVALID_FLAG_KEY_THAT_THROWS_EXCEPTION = "$ test error flag $";
    static final RuntimeException EXPECTED_EXCEPTION_FROM_INVALID_FLAG = new RuntimeException("deliberate test error");
    private final Getters getters;

    Evaluator(Getters getters) {
        this.getters = getters;
    }

    EvalResult evaluate(DataModel.FeatureFlag flag, LDUser user, EventFactory eventFactory) {
        if (flag.getKey() == INVALID_FLAG_KEY_THAT_THROWS_EXCEPTION) {
            throw EXPECTED_EXCEPTION_FROM_INVALID_FLAG;
        }
        if (user == null || user.getKey() == null) {
            logger.warn("Null user or null user key when evaluating flag \"{}\"; returning null", (Object)flag.getKey());
            return new EvalResult(null, -1, EvaluationReason.error(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED));
        }
        ArrayList<Event.FeatureRequest> prerequisiteEvents = flag.getPrerequisites().isEmpty() ? null : new ArrayList<Event.FeatureRequest>();
        EvalResult result = this.evaluateInternal(flag, user, eventFactory, prerequisiteEvents);
        if (prerequisiteEvents != null) {
            result.setPrerequisiteEvents(prerequisiteEvents);
        }
        return result;
    }

    private EvalResult evaluateInternal(DataModel.FeatureFlag flag, LDUser user, EventFactory eventFactory, List<Event.FeatureRequest> eventsOut) {
        if (!flag.isOn()) {
            return this.getOffValue(flag, EvaluationReason.off());
        }
        EvaluationReason prereqFailureReason = this.checkPrerequisites(flag, user, eventFactory, eventsOut);
        if (prereqFailureReason != null) {
            return this.getOffValue(flag, prereqFailureReason);
        }
        for (DataModel.Target target : flag.getTargets()) {
            if (!target.getValues().contains(user.getKey())) continue;
            return this.getVariation(flag, target.getVariation(), EvaluationReason.targetMatch());
        }
        List<DataModel.Rule> rules = flag.getRules();
        for (int i = 0; i < rules.size(); ++i) {
            DataModel.Rule rule = rules.get(i);
            if (!this.ruleMatchesUser(flag, rule, user)) continue;
            EvaluationReason precomputedReason = rule.getRuleMatchReason();
            EvaluationReason reason = precomputedReason != null ? precomputedReason : EvaluationReason.ruleMatch(i, rule.getId());
            return this.getValueForVariationOrRollout(flag, rule, user, reason);
        }
        return this.getValueForVariationOrRollout(flag, flag.getFallthrough(), user, EvaluationReason.fallthrough());
    }

    private EvaluationReason checkPrerequisites(DataModel.FeatureFlag flag, LDUser user, EventFactory eventFactory, List<Event.FeatureRequest> eventsOut) {
        for (DataModel.Prerequisite prereq : flag.getPrerequisites()) {
            boolean prereqOk = true;
            DataModel.FeatureFlag prereqFeatureFlag = this.getters.getFlag(prereq.getKey());
            if (prereqFeatureFlag == null) {
                logger.error("Could not retrieve prerequisite flag \"{}\" when evaluating \"{}\"", (Object)prereq.getKey(), (Object)flag.getKey());
                prereqOk = false;
            } else {
                EvalResult prereqEvalResult = this.evaluateInternal(prereqFeatureFlag, user, eventFactory, eventsOut);
                if (!prereqFeatureFlag.isOn() || prereqEvalResult.getVariationIndex() != prereq.getVariation()) {
                    prereqOk = false;
                }
                if (eventsOut != null) {
                    eventsOut.add(eventFactory.newPrerequisiteFeatureRequestEvent(prereqFeatureFlag, user, prereqEvalResult, flag));
                }
            }
            if (prereqOk) continue;
            EvaluationReason precomputedReason = prereq.getPrerequisiteFailedReason();
            return precomputedReason != null ? precomputedReason : EvaluationReason.prerequisiteFailed(prereq.getKey());
        }
        return null;
    }

    private EvalResult getVariation(DataModel.FeatureFlag flag, int variation, EvaluationReason reason) {
        List<LDValue> variations = flag.getVariations();
        if (variation < 0 || variation >= variations.size()) {
            logger.error("Data inconsistency in feature flag \"{}\": invalid variation index", (Object)flag.getKey());
            return EvalResult.error(EvaluationReason.ErrorKind.MALFORMED_FLAG);
        }
        return new EvalResult(variations.get(variation), variation, reason);
    }

    private EvalResult getOffValue(DataModel.FeatureFlag flag, EvaluationReason reason) {
        Integer offVariation = flag.getOffVariation();
        if (offVariation == null) {
            return new EvalResult(null, -1, reason);
        }
        return this.getVariation(flag, offVariation, reason);
    }

    private EvalResult getValueForVariationOrRollout(DataModel.FeatureFlag flag, DataModel.VariationOrRollout vr, LDUser user, EvaluationReason reason) {
        Integer index = EvaluatorBucketing.variationIndexForUser(vr, user, flag.getKey(), flag.getSalt());
        if (index == null) {
            logger.error("Data inconsistency in feature flag \"{}\": variation/rollout object with no variation or rollout", (Object)flag.getKey());
            return EvalResult.error(EvaluationReason.ErrorKind.MALFORMED_FLAG);
        }
        return this.getVariation(flag, index, reason);
    }

    private boolean ruleMatchesUser(DataModel.FeatureFlag flag, DataModel.Rule rule, LDUser user) {
        for (DataModel.Clause clause : rule.getClauses()) {
            if (this.clauseMatchesUser(clause, user)) continue;
            return false;
        }
        return true;
    }

    private boolean clauseMatchesUser(DataModel.Clause clause, LDUser user) {
        if (clause.getOp() == DataModel.Operator.segmentMatch) {
            for (LDValue j : clause.getValues()) {
                DataModel.Segment segment;
                if (!j.isString() || (segment = this.getters.getSegment(j.stringValue())) == null || !this.segmentMatchesUser(segment, user)) continue;
                return this.maybeNegate(clause, true);
            }
            return this.maybeNegate(clause, false);
        }
        return this.clauseMatchesUserNoSegments(clause, user);
    }

    private boolean clauseMatchesUserNoSegments(DataModel.Clause clause, LDUser user) {
        LDValue userValue = user.getAttribute(clause.getAttribute());
        if (userValue.isNull()) {
            return false;
        }
        if (userValue.getType() == LDValueType.ARRAY) {
            for (LDValue value : userValue.values()) {
                if (value.getType() == LDValueType.ARRAY || value.getType() == LDValueType.OBJECT) {
                    logger.error("Invalid custom attribute value in user object for user key \"{}\": {}", (Object)user.getKey(), (Object)value);
                    return false;
                }
                if (!Evaluator.clauseMatchAny(clause, value)) continue;
                return this.maybeNegate(clause, true);
            }
            return this.maybeNegate(clause, false);
        }
        if (userValue.getType() != LDValueType.OBJECT) {
            return this.maybeNegate(clause, Evaluator.clauseMatchAny(clause, userValue));
        }
        logger.warn("Got unexpected user attribute type \"{}\" for user key \"{}\" and attribute \"{}\"", new Object[]{userValue.getType(), user.getKey(), clause.getAttribute()});
        return false;
    }

    static boolean clauseMatchAny(DataModel.Clause clause, LDValue userValue) {
        DataModel.Operator op = clause.getOp();
        if (op != null) {
            EvaluatorPreprocessing.ClauseExtra preprocessed = clause.getPreprocessed();
            if (op == DataModel.Operator.in) {
                Set<LDValue> vs;
                Set<LDValue> set = vs = preprocessed == null ? null : preprocessed.valuesSet;
                if (vs != null) {
                    return vs.contains(userValue);
                }
            }
            List<LDValue> values2 = clause.getValues();
            List<EvaluatorPreprocessing.ClauseExtra.ValueExtra> preprocessedValues = preprocessed == null ? null : preprocessed.valuesExtra;
            int n = values2.size();
            for (int i = 0; i < n; ++i) {
                EvaluatorPreprocessing.ClauseExtra.ValueExtra p = preprocessedValues == null ? null : preprocessedValues.get(i);
                LDValue v = values2.get(i);
                if (!EvaluatorOperators.apply(op, userValue, v, p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean maybeNegate(DataModel.Clause clause, boolean b) {
        return clause.isNegate() ? !b : b;
    }

    private boolean segmentMatchesUser(DataModel.Segment segment, LDUser user) {
        String userKey = user.getKey();
        if (segment.getIncluded().contains(userKey)) {
            return true;
        }
        if (segment.getExcluded().contains(userKey)) {
            return false;
        }
        for (DataModel.SegmentRule rule : segment.getRules()) {
            if (!this.segmentRuleMatchesUser(rule, user, segment.getKey(), segment.getSalt())) continue;
            return true;
        }
        return false;
    }

    private boolean segmentRuleMatchesUser(DataModel.SegmentRule segmentRule, LDUser user, String segmentKey, String salt) {
        double weight;
        for (DataModel.Clause c : segmentRule.getClauses()) {
            if (this.clauseMatchesUserNoSegments(c, user)) continue;
            return false;
        }
        if (segmentRule.getWeight() == null) {
            return true;
        }
        double bucket = EvaluatorBucketing.bucketUser(user, segmentKey, segmentRule.getBucketBy(), salt);
        return bucket < (weight = (double)segmentRule.getWeight().intValue() / 100000.0);
    }

    static class EvalResult {
        private LDValue value = LDValue.ofNull();
        private int variationIndex = -1;
        private EvaluationReason reason = null;
        private List<Event.FeatureRequest> prerequisiteEvents;

        public EvalResult(LDValue value, int variationIndex, EvaluationReason reason) {
            this.value = value;
            this.variationIndex = variationIndex;
            this.reason = reason;
        }

        public static EvalResult error(EvaluationReason.ErrorKind errorKind) {
            return new EvalResult(LDValue.ofNull(), -1, EvaluationReason.error(errorKind));
        }

        LDValue getValue() {
            return LDValue.normalize(this.value);
        }

        void setValue(LDValue value) {
            this.value = value;
        }

        int getVariationIndex() {
            return this.variationIndex;
        }

        boolean isDefault() {
            return this.variationIndex < 0;
        }

        EvaluationReason getReason() {
            return this.reason;
        }

        EvaluationDetail<LDValue> getDetails() {
            return EvaluationDetail.fromValue(LDValue.normalize(this.value), this.variationIndex, this.reason);
        }

        Iterable<Event.FeatureRequest> getPrerequisiteEvents() {
            return this.prerequisiteEvents == null ? ImmutableList.of() : this.prerequisiteEvents;
        }

        private void setPrerequisiteEvents(List<Event.FeatureRequest> prerequisiteEvents) {
            this.prerequisiteEvents = prerequisiteEvents;
        }
    }

    static interface Getters {
        public DataModel.FeatureFlag getFlag(String var1);

        public DataModel.Segment getSegment(String var1);
    }
}

