/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.shaded.com.google.common.base.Strings;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public interface DataSourceStatusProvider {
    public Status getStatus();

    public void addStatusListener(StatusListener var1);

    public void removeStatusListener(StatusListener var1);

    public boolean waitFor(State var1, Duration var2) throws InterruptedException;

    public static interface StatusListener {
        public void dataSourceStatusChanged(Status var1);
    }

    public static final class Status {
        private final State state;
        private final Instant stateSince;
        private final ErrorInfo lastError;

        public Status(State state, Instant stateSince, ErrorInfo lastError) {
            this.state = state;
            this.stateSince = stateSince;
            this.lastError = lastError;
        }

        public State getState() {
            return this.state;
        }

        public Instant getStateSince() {
            return this.stateSince;
        }

        public ErrorInfo getLastError() {
            return this.lastError;
        }

        public boolean equals(Object other) {
            if (other instanceof Status) {
                Status o = (Status)other;
                return this.state == o.state && Objects.equals(this.stateSince, o.stateSince) && Objects.equals(this.lastError, o.lastError);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.stateSince, this.lastError});
        }

        public String toString() {
            return "Status(" + (Object)((Object)this.state) + "," + this.stateSince + "," + this.lastError + ")";
        }
    }

    public static final class ErrorInfo {
        private final ErrorKind kind;
        private final int statusCode;
        private final String message;
        private final Instant time;

        public ErrorInfo(ErrorKind kind, int statusCode, String message, Instant time) {
            this.kind = kind;
            this.statusCode = statusCode;
            this.message = message;
            this.time = time;
        }

        public static ErrorInfo fromException(ErrorKind kind, Throwable t) {
            return new ErrorInfo(kind, 0, t.toString(), Instant.now());
        }

        public static ErrorInfo fromHttpError(int statusCode) {
            return new ErrorInfo(ErrorKind.ERROR_RESPONSE, statusCode, null, Instant.now());
        }

        public ErrorKind getKind() {
            return this.kind;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public Instant getTime() {
            return this.time;
        }

        public boolean equals(Object other) {
            if (other instanceof ErrorInfo) {
                ErrorInfo o = (ErrorInfo)other;
                return this.kind == o.kind && this.statusCode == o.statusCode && Objects.equals(this.message, o.message) && Objects.equals(this.time, o.time);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.statusCode, this.message, this.time});
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            s2.append(this.kind.toString());
            if (this.statusCode > 0 || !Strings.isNullOrEmpty(this.message)) {
                s2.append("(");
                if (this.statusCode > 0) {
                    s2.append(this.statusCode);
                }
                if (!Strings.isNullOrEmpty(this.message)) {
                    if (this.statusCode > 0) {
                        s2.append(",");
                    }
                    s2.append(this.message);
                }
                s2.append(")");
            }
            if (this.time != null) {
                s2.append("@");
                s2.append(this.time.toString());
            }
            return s2.toString();
        }
    }

    public static enum ErrorKind {
        UNKNOWN,
        NETWORK_ERROR,
        ERROR_RESPONSE,
        INVALID_DATA,
        STORE_ERROR;

    }

    public static enum State {
        INITIALIZING,
        VALID,
        INTERRUPTED,
        OFF;

    }
}

