/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.DefaultEventProcessor;
import com.launchdarkly.sdk.server.DefaultEventSender;
import com.launchdarkly.sdk.server.DefaultFeatureRequestor;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.HttpConfigurationImpl;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.Loggers;
import com.launchdarkly.sdk.server.LoggingConfigurationImpl;
import com.launchdarkly.sdk.server.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.server.PollingProcessor;
import com.launchdarkly.sdk.server.StreamProcessor;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.BasicConfiguration;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreUpdates;
import com.launchdarkly.sdk.server.interfaces.DiagnosticDescription;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.sdk.server.interfaces.EventProcessor;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.EventSender;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.LoggingConfiguration;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStore;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStoreFactory;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.okhttp3.Credentials;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

abstract class ComponentsImpl {
    static final EventProcessorFactory NULL_EVENT_PROCESSOR_FACTORY = context -> NullEventProcessor.INSTANCE;

    private ComponentsImpl() {
    }

    static final class LoggingConfigurationBuilderImpl
    extends LoggingConfigurationBuilder {
        LoggingConfigurationBuilderImpl() {
        }

        @Override
        public LoggingConfiguration createLoggingConfiguration(BasicConfiguration basicConfiguration) {
            return new LoggingConfigurationImpl(this.logDataSourceOutageAsErrorAfter);
        }
    }

    static final class PersistentDataStoreBuilderImpl
    extends PersistentDataStoreBuilder
    implements DiagnosticDescription {
        public PersistentDataStoreBuilderImpl(PersistentDataStoreFactory persistentDataStoreFactory) {
            super(persistentDataStoreFactory);
        }

        @Override
        public LDValue describeConfiguration(BasicConfiguration basicConfiguration) {
            if (this.persistentDataStoreFactory instanceof DiagnosticDescription) {
                return ((DiagnosticDescription)((Object)this.persistentDataStoreFactory)).describeConfiguration(basicConfiguration);
            }
            return LDValue.of("custom");
        }

        @Override
        public DataStore createDataStore(ClientContext context, DataStoreUpdates dataStoreUpdates) {
            PersistentDataStore core = this.persistentDataStoreFactory.createPersistentDataStore(context);
            return new PersistentDataStoreWrapper(core, this.cacheTime, this.staleValuesPolicy, this.recordCacheStats, dataStoreUpdates, ClientContextImpl.get((ClientContext)context).sharedExecutor);
        }
    }

    static final class HttpBasicAuthentication
    implements HttpAuthentication {
        private final String username;
        private final String password;

        HttpBasicAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public String provideAuthorization(Iterable<HttpAuthentication.Challenge> challenges) {
            return Credentials.basic(this.username, this.password);
        }
    }

    static final class HttpConfigurationBuilderImpl
    extends HttpConfigurationBuilder {
        HttpConfigurationBuilderImpl() {
        }

        @Override
        public HttpConfiguration createHttpConfiguration(BasicConfiguration basicConfiguration) {
            Proxy proxy;
            ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
            headers.put("Authorization", basicConfiguration.getSdkKey());
            headers.put("User-Agent", "JavaClient/5.0.0");
            if (this.wrapperName != null) {
                String wrapperId = this.wrapperVersion == null ? this.wrapperName : this.wrapperName + "/" + this.wrapperVersion;
                headers.put("X-LaunchDarkly-Wrapper", wrapperId);
            }
            Proxy proxy2 = proxy = this.proxyHost == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
            if (proxy != null) {
                Loggers.MAIN.info("Using proxy: {} {} authentication.", (Object)proxy, (Object)(this.proxyAuth == null ? "without" : "with"));
            }
            return new HttpConfigurationImpl(this.connectTimeout, proxy, this.proxyAuth, this.socketTimeout, this.sslSocketFactory, this.trustManager, headers.build());
        }
    }

    static final class EventProcessorBuilderImpl
    extends EventProcessorBuilder
    implements DiagnosticDescription {
        EventProcessorBuilderImpl() {
        }

        @Override
        public EventProcessor createEventProcessor(ClientContext context) {
            EventSender eventSender = (this.eventSenderFactory == null ? new DefaultEventSender.Factory() : this.eventSenderFactory).createEventSender(context.getBasic(), context.getHttp());
            return new DefaultEventProcessor(new EventsConfiguration(this.allAttributesPrivate, this.capacity, eventSender, this.baseURI == null ? LDConfig.DEFAULT_EVENTS_URI : this.baseURI, this.flushInterval, this.inlineUsersInEvents, this.privateAttributes, this.userKeysCapacity, this.userKeysFlushInterval, this.diagnosticRecordingInterval), ClientContextImpl.get((ClientContext)context).sharedExecutor, context.getBasic().getThreadPriority(), ClientContextImpl.get((ClientContext)context).diagnosticAccumulator, ClientContextImpl.get((ClientContext)context).diagnosticInitEvent);
        }

        @Override
        public LDValue describeConfiguration(BasicConfiguration basicConfiguration) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.ALL_ATTRIBUTES_PRIVATE.name, this.allAttributesPrivate).put(DiagnosticEvent.ConfigProperty.CUSTOM_EVENTS_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_EVENTS_URI)).put(DiagnosticEvent.ConfigProperty.DIAGNOSTIC_RECORDING_INTERVAL_MILLIS.name, this.diagnosticRecordingInterval.toMillis()).put(DiagnosticEvent.ConfigProperty.EVENTS_CAPACITY.name, this.capacity).put(DiagnosticEvent.ConfigProperty.EVENTS_FLUSH_INTERVAL_MILLIS.name, this.flushInterval.toMillis()).put(DiagnosticEvent.ConfigProperty.INLINE_USERS_IN_EVENTS.name, this.inlineUsersInEvents).put(DiagnosticEvent.ConfigProperty.SAMPLING_INTERVAL.name, 0).put(DiagnosticEvent.ConfigProperty.USER_KEYS_CAPACITY.name, this.userKeysCapacity).put(DiagnosticEvent.ConfigProperty.USER_KEYS_FLUSH_INTERVAL_MILLIS.name, this.userKeysFlushInterval.toMillis()).build();
        }
    }

    static final class PollingDataSourceBuilderImpl
    extends PollingDataSourceBuilder
    implements DiagnosticDescription {
        PollingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
            Loggers.DATA_SOURCE.info("Disabling streaming API");
            Loggers.DATA_SOURCE.warn("You should only disable the streaming API if instructed to do so by LaunchDarkly support");
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(context.getHttp(), this.baseURI == null ? LDConfig.DEFAULT_BASE_URI : this.baseURI, true);
            return new PollingProcessor(requestor, dataSourceUpdates, ClientContextImpl.get((ClientContext)context).sharedExecutor, this.pollInterval);
        }

        @Override
        public LDValue describeConfiguration(BasicConfiguration basicConfiguration) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_BASE_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.POLLING_INTERVAL_MILLIS.name, this.pollInterval.toMillis()).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class StreamingDataSourceBuilderImpl
    extends StreamingDataSourceBuilder
    implements DiagnosticDescription {
        StreamingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
            URI streamUri;
            Loggers.DATA_SOURCE.info("Enabling streaming API");
            URI uRI = streamUri = this.baseURI == null ? LDConfig.DEFAULT_STREAM_URI : this.baseURI;
            URI pollUri = this.pollingBaseURI != null ? this.pollingBaseURI : (this.baseURI == null ? LDConfig.DEFAULT_BASE_URI : this.baseURI);
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(context.getHttp(), pollUri, false);
            return new StreamProcessor(context.getHttp(), requestor, dataSourceUpdates, null, context.getBasic().getThreadPriority(), ClientContextImpl.get((ClientContext)context).diagnosticAccumulator, streamUri, this.initialReconnectDelay);
        }

        @Override
        public LDValue describeConfiguration(BasicConfiguration basicConfiguration) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, this.pollingBaseURI != null && !this.pollingBaseURI.equals(LDConfig.DEFAULT_BASE_URI) || this.pollingBaseURI == null && this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.RECONNECT_TIME_MILLIS.name, this.initialReconnectDelay.toMillis()).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class NullDataSource
    implements DataSource {
        static final DataSource INSTANCE = new NullDataSource();

        NullDataSource() {
        }

        @Override
        public Future<Void> start() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    static final class NullDataSourceFactory
    implements DataSourceFactory,
    DiagnosticDescription {
        static final NullDataSourceFactory INSTANCE = new NullDataSourceFactory();

        NullDataSourceFactory() {
        }

        @Override
        public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
            if (context.getBasic().isOffline()) {
                Loggers.MAIN.info("Starting LaunchDarkly client in offline mode");
            } else {
                Loggers.MAIN.info("LaunchDarkly client will not connect to Launchdarkly for feature flag data");
            }
            dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            return NullDataSource.INSTANCE;
        }

        @Override
        public LDValue describeConfiguration(BasicConfiguration basicConfiguration) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, true).build();
        }
    }

    static final class NullEventProcessor
    implements EventProcessor {
        static final NullEventProcessor INSTANCE = new NullEventProcessor();

        private NullEventProcessor() {
        }

        @Override
        public void sendEvent(Event e) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    static final class InMemoryDataStoreFactory
    implements DataStoreFactory,
    DiagnosticDescription {
        static final DataStoreFactory INSTANCE = new InMemoryDataStoreFactory();

        InMemoryDataStoreFactory() {
        }

        @Override
        public DataStore createDataStore(ClientContext context, DataStoreUpdates dataStoreUpdates) {
            return new InMemoryDataStore();
        }

        @Override
        public LDValue describeConfiguration(BasicConfiguration basicConfiguration) {
            return LDValue.of("memory");
        }
    }
}

