/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;

public class Event {
    private final long creationDate;
    private final LDUser user;

    public Event(long creationDate, LDUser user) {
        this.creationDate = creationDate;
        this.user = user;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public LDUser getUser() {
        return this.user;
    }

    public static final class FeatureRequest
    extends Event {
        private final String key;
        private final int variation;
        private final LDValue value;
        private final LDValue defaultVal;
        private final int version;
        private final String prereqOf;
        private final boolean trackEvents;
        private final long debugEventsUntilDate;
        private final EvaluationReason reason;
        private final boolean debug;

        public FeatureRequest(long timestamp, String key, LDUser user, int version, int variation, LDValue value, LDValue defaultVal, EvaluationReason reason, String prereqOf, boolean trackEvents, long debugEventsUntilDate, boolean debug) {
            super(timestamp, user);
            this.key = key;
            this.version = version;
            this.variation = variation;
            this.value = value;
            this.defaultVal = defaultVal;
            this.prereqOf = prereqOf;
            this.trackEvents = trackEvents;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.reason = reason;
            this.debug = debug;
        }

        public String getKey() {
            return this.key;
        }

        public int getVariation() {
            return this.variation;
        }

        public LDValue getValue() {
            return this.value;
        }

        public LDValue getDefaultVal() {
            return this.defaultVal;
        }

        public int getVersion() {
            return this.version;
        }

        public String getPrereqOf() {
            return this.prereqOf;
        }

        public boolean isTrackEvents() {
            return this.trackEvents;
        }

        public long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        public EvaluationReason getReason() {
            return this.reason;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }

    public static final class Index
    extends Event {
        public Index(long timestamp, LDUser user) {
            super(timestamp, user);
        }
    }

    public static final class Identify
    extends Event {
        public Identify(long timestamp, LDUser user) {
            super(timestamp, user);
        }
    }

    public static final class Custom
    extends Event {
        private final String key;
        private final LDValue data;
        private final Double metricValue;

        public Custom(long timestamp, String key, LDUser user, LDValue data, Double metricValue) {
            super(timestamp, user);
            this.key = key;
            this.data = data == null ? LDValue.ofNull() : data;
            this.metricValue = metricValue;
        }

        public String getKey() {
            return this.key;
        }

        public LDValue getData() {
            return this.data;
        }

        public Double getMetricValue() {
            return this.metricValue;
        }
    }
}

