/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.launchdarkly.shaded.com.fasterxml.jackson.core.JsonLocation;
import com.launchdarkly.shaded.com.fasterxml.jackson.core.JsonParseException;
import com.launchdarkly.shaded.com.fasterxml.jackson.core.JsonParser;
import com.launchdarkly.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.launchdarkly.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.launchdarkly.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.launchdarkly.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.launchdarkly.shaded.com.fasterxml.jackson.databind.Module;
import com.launchdarkly.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.launchdarkly.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Iterator;

public class LDJackson {
    private LDJackson() {
    }

    public static Module module() {
        SimpleModule module = new SimpleModule(LDJackson.class.getName());
        module.addSerializer(JsonSerializable.class, LDJacksonSerializer.INSTANCE);
        Iterator<Class<? extends JsonSerializable>> iterator2 = JsonSerialization.getDeserializableClasses().iterator();
        while (iterator2.hasNext()) {
            Class<? extends JsonSerializable> c;
            Class<? extends JsonSerializable> cjs = c = iterator2.next();
            module.addDeserializer(cjs, new LDJacksonDeserializer<JsonSerializable>(cjs));
        }
        return module;
    }

    private static class LDJacksonDeserializer<T extends JsonSerializable>
    extends JsonDeserializer<T> {
        private final Class<T> objectClass;

        LDJacksonDeserializer(Class<T> objectClass) {
            this.objectClass = objectClass;
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonLocation loc = p.getCurrentLocation();
            Object jsonTree = p.readValueAsTree();
            String jsonString = jsonTree.toString();
            try {
                return JsonSerialization.deserialize(jsonString, this.objectClass);
            }
            catch (SerializationException e) {
                throw new JsonParseException(p, "invalid JSON encoding for " + this.objectClass.getSimpleName(), loc, e);
            }
        }
    }

    private static class LDJacksonSerializer
    extends JsonSerializer<JsonSerializable> {
        static final LDJacksonSerializer INSTANCE = new LDJacksonSerializer();

        private LDJacksonSerializer() {
        }

        @Override
        public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String json = JsonSerialization.serializeInternal(value);
            gen.writeRawValue(json);
        }
    }
}

