/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.ArrayBuilder;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSortedSet;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public final class TestData
implements DataSourceFactory {
    private final Object lock = new Object();
    private final Map<String, DataStoreTypes.ItemDescriptor> currentFlags = new HashMap<String, DataStoreTypes.ItemDescriptor>();
    private final Map<String, FlagBuilder> currentBuilders = new HashMap<String, FlagBuilder>();
    private final List<DataSourceImpl> instances = new CopyOnWriteArrayList<DataSourceImpl>();

    public static TestData dataSource() {
        return new TestData();
    }

    private TestData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlagBuilder flag(String key) {
        FlagBuilder existingBuilder;
        Object object = this.lock;
        synchronized (object) {
            existingBuilder = this.currentBuilders.get(key);
        }
        if (existingBuilder != null) {
            return new FlagBuilder(existingBuilder);
        }
        return new FlagBuilder(key).booleanFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData update(FlagBuilder flagBuilder) {
        String key = flagBuilder.key;
        FlagBuilder clonedBuilder = new FlagBuilder(flagBuilder);
        DataStoreTypes.ItemDescriptor newItem = null;
        Iterator<DataSourceImpl> iterator2 = this.lock;
        synchronized (iterator2) {
            DataStoreTypes.ItemDescriptor oldItem = this.currentFlags.get(key);
            int oldVersion = oldItem == null ? 0 : oldItem.getVersion();
            newItem = flagBuilder.createFlag(oldVersion + 1);
            this.currentFlags.put(key, newItem);
            this.currentBuilders.put(key, clonedBuilder);
        }
        for (DataSourceImpl instance : this.instances) {
            instance.updates.upsert(DataModel.FEATURES, key, newItem);
        }
        return this;
    }

    public TestData updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
        for (DataSourceImpl instance : this.instances) {
            instance.updates.updateStatus(newState, newError);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
        DataSourceImpl instance = new DataSourceImpl(dataSourceUpdates);
        Object object = this.lock;
        synchronized (object) {
            this.instances.add(instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> makeInitData() {
        ImmutableMap<String, DataStoreTypes.ItemDescriptor> copiedData;
        Object object = this.lock;
        synchronized (object) {
            copiedData = ImmutableMap.copyOf(this.currentFlags);
        }
        return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(ImmutableMap.of(DataModel.FEATURES, new DataStoreTypes.KeyedItems(copiedData.entrySet())).entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closedInstance(DataSourceImpl instance) {
        Object object = this.lock;
        synchronized (object) {
            this.instances.remove(instance);
        }
    }

    private final class DataSourceImpl
    implements DataSource {
        final DataSourceUpdates updates;

        DataSourceImpl(DataSourceUpdates updates) {
            this.updates = updates;
        }

        @Override
        public Future<Void> start() {
            this.updates.init(TestData.this.makeInitData());
            this.updates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public void close() throws IOException {
            TestData.this.closedInstance(this);
        }
    }

    public static final class FlagBuilder {
        private static final int TRUE_VARIATION_FOR_BOOLEAN = 0;
        private static final int FALSE_VARIATION_FOR_BOOLEAN = 1;
        final String key;
        int offVariation;
        boolean on;
        int fallthroughVariation;
        CopyOnWriteArrayList<LDValue> variations;
        Map<Integer, ImmutableSet<String>> targets;
        List<FlagRuleBuilder> rules;

        private FlagBuilder(String key) {
            this.key = key;
            this.on = true;
            this.variations = new CopyOnWriteArrayList();
        }

        private FlagBuilder(FlagBuilder from) {
            this.key = from.key;
            this.offVariation = from.offVariation;
            this.on = from.on;
            this.fallthroughVariation = from.fallthroughVariation;
            this.variations = new CopyOnWriteArrayList<LDValue>(from.variations);
            this.targets = from.targets == null ? null : new HashMap<Integer, ImmutableSet<String>>(from.targets);
        }

        private boolean isBooleanFlag() {
            return this.variations.size() == 2 && this.variations.get(0).equals(LDValue.of(true)) && this.variations.get(1).equals(LDValue.of(false));
        }

        public FlagBuilder booleanFlag() {
            if (this.isBooleanFlag()) {
                return this;
            }
            return this.variations(LDValue.of(true), LDValue.of(false)).fallthroughVariation(0).offVariation(1);
        }

        public FlagBuilder on(boolean on) {
            this.on = on;
            return this;
        }

        public FlagBuilder fallthroughVariation(boolean value) {
            return this.booleanFlag().fallthroughVariation(FlagBuilder.variationForBoolean(value));
        }

        public FlagBuilder fallthroughVariation(int variationIndex) {
            this.fallthroughVariation = variationIndex;
            return this;
        }

        public FlagBuilder offVariation(boolean value) {
            return this.booleanFlag().offVariation(FlagBuilder.variationForBoolean(value));
        }

        public FlagBuilder offVariation(int variationIndex) {
            this.offVariation = variationIndex;
            return this;
        }

        public FlagBuilder variationForAllUsers(boolean variation) {
            return this.booleanFlag().variationForAllUsers(FlagBuilder.variationForBoolean(variation));
        }

        public FlagBuilder variationForAllUsers(int variationIndex) {
            return this.on(true).clearRules().clearUserTargets().fallthroughVariation(variationIndex);
        }

        public FlagBuilder valueForAllUsers(LDValue value) {
            this.variations.clear();
            this.variations.add(value);
            return this.variationForAllUsers(0);
        }

        public FlagBuilder variationForUser(String userKey, boolean variation) {
            return this.booleanFlag().variationForUser(userKey, FlagBuilder.variationForBoolean(variation));
        }

        public FlagBuilder variationForUser(String userKey, int variationIndex) {
            if (this.targets == null) {
                this.targets = new TreeMap<Integer, ImmutableSet<String>>();
            }
            for (int i = 0; i < this.variations.size(); ++i) {
                ImmutableSet<String> keys2 = this.targets.get(i);
                if (i == variationIndex) {
                    if (keys2 == null) {
                        this.targets.put(i, ImmutableSortedSet.of(userKey));
                        continue;
                    }
                    if (keys2.contains(userKey)) continue;
                    this.targets.put(i, ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.naturalOrder().addAll(keys2)).add(userKey)).build());
                    continue;
                }
                if (keys2 == null || !keys2.contains(userKey)) continue;
                this.targets.put(i, ImmutableSortedSet.copyOf(Iterables.filter(keys2, k -> !k.equals(userKey))));
            }
            return this;
        }

        public FlagBuilder variations(LDValue ... values2) {
            this.variations.clear();
            for (LDValue v : values2) {
                this.variations.add(v);
            }
            return this;
        }

        public FlagRuleBuilder ifMatch(UserAttribute attribute, LDValue ... values2) {
            return new FlagRuleBuilder().andMatch(attribute, values2);
        }

        public FlagRuleBuilder ifNotMatch(UserAttribute attribute, LDValue ... values2) {
            return new FlagRuleBuilder().andNotMatch(attribute, values2);
        }

        public FlagBuilder clearRules() {
            this.rules = null;
            return this;
        }

        public FlagBuilder clearUserTargets() {
            this.targets = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        DataStoreTypes.ItemDescriptor createFlag(int version) {
            ObjectBuilder builder = LDValue.buildObject().put("key", this.key).put("version", version).put("on", this.on).put("offVariation", this.offVariation).put("fallthrough", LDValue.buildObject().put("variation", this.fallthroughVariation).build());
            ArrayBuilder jsonVariations = LDValue.buildArray();
            for (LDValue lDValue : this.variations) {
                jsonVariations.add(lDValue);
            }
            builder.put("variations", jsonVariations.build());
            if (this.targets != null) {
                ArrayBuilder jsonTargets = LDValue.buildArray();
                for (Map.Entry<Integer, ImmutableSet<String>> entry : this.targets.entrySet()) {
                    jsonTargets.add(LDValue.buildObject().put("variation", entry.getKey()).put("values", LDValue.Convert.String.arrayFrom((Iterable<String>)entry.getValue())).build());
                }
                builder.put("targets", jsonTargets.build());
            }
            if (this.rules != null) {
                ArrayBuilder jsonRules = LDValue.buildArray();
                boolean bl = false;
                for (FlagRuleBuilder r : this.rules) {
                    void var5_9;
                    ArrayBuilder jsonClauses = LDValue.buildArray();
                    for (Clause c : r.clauses) {
                        ArrayBuilder jsonValues = LDValue.buildArray();
                        for (LDValue v : c.values) {
                            jsonValues.add(v);
                        }
                        jsonClauses.add(LDValue.buildObject().put("attribute", c.attribute.getName()).put("op", c.operator).put("values", jsonValues.build()).put("negate", c.negate).build());
                    }
                    jsonRules.add(LDValue.buildObject().put("id", "rule" + (int)var5_9).put("variation", r.variation).put("clauses", jsonClauses.build()).build());
                    ++var5_9;
                }
                builder.put("rules", jsonRules.build());
            }
            String json = builder.build().toJsonString();
            return DataModel.FEATURES.deserialize(json);
        }

        private static int variationForBoolean(boolean value) {
            return value ? 0 : 1;
        }

        private static final class Clause {
            final UserAttribute attribute;
            final String operator;
            final LDValue[] values;
            final boolean negate;

            Clause(UserAttribute attribute, String operator, LDValue[] values2, boolean negate) {
                this.attribute = attribute;
                this.operator = operator;
                this.values = values2;
                this.negate = negate;
            }
        }

        public final class FlagRuleBuilder {
            final List<Clause> clauses = new ArrayList<Clause>();
            int variation;

            public FlagRuleBuilder andMatch(UserAttribute attribute, LDValue ... values2) {
                this.clauses.add(new Clause(attribute, "in", values2, false));
                return this;
            }

            public FlagRuleBuilder andNotMatch(UserAttribute attribute, LDValue ... values2) {
                this.clauses.add(new Clause(attribute, "in", values2, true));
                return this;
            }

            public FlagBuilder thenReturn(boolean variation) {
                FlagBuilder.this.booleanFlag();
                return this.thenReturn(FlagBuilder.variationForBoolean(variation));
            }

            public FlagBuilder thenReturn(int variationIndex) {
                this.variation = variationIndex;
                if (FlagBuilder.this.rules == null) {
                    FlagBuilder.this.rules = new ArrayList<FlagRuleBuilder>();
                }
                FlagBuilder.this.rules.add(this);
                return FlagBuilder.this;
            }
        }
    }
}

