/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;

abstract class EvaluatorHelpers {
    EvaluatorHelpers() {
    }

    static EvalResult offResult(DataModel.FeatureFlag flag) {
        if (flag.preprocessed != null) {
            return flag.preprocessed.offResult;
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForOffVariation(flag, EvaluationReason.off()));
    }

    static EvalResult targetMatchResult(DataModel.FeatureFlag flag, DataModel.Target target) {
        if (target.preprocessed != null) {
            return target.preprocessed.targetMatchResult;
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForVariation(flag, target.getVariation(), EvaluationReason.targetMatch()));
    }

    static EvalResult prerequisiteFailedResult(DataModel.FeatureFlag flag, DataModel.Prerequisite prereq) {
        if (prereq.preprocessed != null) {
            return prereq.preprocessed.prerequisiteFailedResult;
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForOffVariation(flag, EvaluationReason.prerequisiteFailed(prereq.getKey())));
    }

    static EvaluationDetail<LDValue> evaluationDetailForOffVariation(DataModel.FeatureFlag flag, EvaluationReason reason) {
        Integer offVariation = flag.getOffVariation();
        if (offVariation == null) {
            return EvaluationDetail.fromValue(LDValue.ofNull(), -1, reason);
        }
        return EvaluatorHelpers.evaluationDetailForVariation(flag, offVariation, reason);
    }

    static EvaluationDetail<LDValue> evaluationDetailForVariation(DataModel.FeatureFlag flag, int variation, EvaluationReason reason) {
        if (variation < 0 || variation >= flag.getVariations().size()) {
            return EvaluationDetail.fromValue(LDValue.ofNull(), -1, EvaluationReason.error(EvaluationReason.ErrorKind.MALFORMED_FLAG));
        }
        return EvaluationDetail.fromValue(LDValue.normalize(flag.getVariations().get(variation)), variation, reason);
    }
}

