/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.shaded.com.google.gson.Gson;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.JsonObject;
import com.launchdarkly.shaded.com.google.gson.JsonSyntaxException;
import com.launchdarkly.shaded.org.yaml.snakeyaml.Yaml;
import com.launchdarkly.shaded.org.yaml.snakeyaml.constructor.SafeConstructor;
import com.launchdarkly.shaded.org.yaml.snakeyaml.error.YAMLException;
import com.launchdarkly.shaded.org.yaml.snakeyaml.representer.Representer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;

abstract class FileDataSourceParsing {
    private FileDataSourceParsing() {
    }

    static abstract class FlagFactory {
        private FlagFactory() {
        }

        static DataStoreTypes.ItemDescriptor flagFromJson(LDValue jsonTree, int version) {
            return DataModel.FEATURES.deserialize(FlagFactory.replaceVersion(jsonTree, version).toJsonString());
        }

        static DataStoreTypes.ItemDescriptor flagWithValue(String key, LDValue jsonValue, int version) {
            LDValue o = LDValue.buildObject().put("key", key).put("version", version).put("on", true).put("variations", LDValue.buildArray().add(jsonValue).build()).put("fallthrough", LDValue.buildObject().put("variation", 0).build()).build();
            return DataModel.FEATURES.deserialize(o.toJsonString());
        }

        static DataStoreTypes.ItemDescriptor segmentFromJson(LDValue jsonTree, int version) {
            return DataModel.SEGMENTS.deserialize(FlagFactory.replaceVersion(jsonTree, version).toJsonString());
        }

        private static LDValue replaceVersion(LDValue objectValue, int version) {
            ObjectBuilder b = LDValue.buildObject();
            for (String key : objectValue.keys()) {
                b.put(key, objectValue.get(key));
            }
            b.put("version", version);
            return b.build();
        }
    }

    static final class YamlFlagFileParser
    extends FlagFileParser {
        private static final Yaml yaml = new Yaml(new SafeConstructor(), new Representer());
        private static final Gson gson = new Gson();
        private static final JsonFlagFileParser jsonFileParser = new JsonFlagFileParser();

        YamlFlagFileParser() {
        }

        @Override
        public FlagFileRep parse(InputStream input) throws FileDataException, IOException {
            Object root;
            try {
                root = yaml.load(input);
            }
            catch (YAMLException e) {
                throw new FileDataException("unable to parse YAML", e);
            }
            JsonElement jsonRoot = root == null ? new JsonObject() : gson.toJsonTree(root);
            return jsonFileParser.parseJson(jsonRoot);
        }
    }

    static final class JsonFlagFileParser
    extends FlagFileParser {
        private static final Gson gson = new Gson();

        JsonFlagFileParser() {
        }

        @Override
        public FlagFileRep parse(InputStream input) throws FileDataException, IOException {
            try {
                return this.parseJson(gson.fromJson((Reader)new InputStreamReader(input), JsonElement.class));
            }
            catch (JsonSyntaxException e) {
                throw new FileDataException("cannot parse JSON", e);
            }
        }

        public FlagFileRep parseJson(JsonElement tree) throws FileDataException, IOException {
            try {
                return gson.fromJson(tree, FlagFileRep.class);
            }
            catch (JsonSyntaxException e) {
                throw new FileDataException("cannot parse JSON", e);
            }
        }
    }

    static abstract class FlagFileParser {
        private static final FlagFileParser jsonParser = new JsonFlagFileParser();
        private static final FlagFileParser yamlParser = new YamlFlagFileParser();

        FlagFileParser() {
        }

        public abstract FlagFileRep parse(InputStream var1) throws FileDataException, IOException;

        public static FlagFileParser selectForContent(byte[] data) {
            InputStreamReader r = new InputStreamReader(new ByteArrayInputStream(data));
            return FlagFileParser.detectJson(r) ? jsonParser : yamlParser;
        }

        private static boolean detectJson(Reader r) {
            try {
                int ch;
                do {
                    if ((ch = r.read()) < 0) {
                        return false;
                    }
                    if (ch != 123) continue;
                    return true;
                } while (Character.isWhitespace(ch));
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    static final class FlagFileRep {
        Map<String, LDValue> flags;
        Map<String, LDValue> flagValues;
        Map<String, LDValue> segments;

        FlagFileRep() {
        }
    }

    static final class FileDataException
    extends Exception {
        private final FileDataSourceBuilder.SourceInfo source;

        public FileDataException(String message, Throwable cause, FileDataSourceBuilder.SourceInfo source2) {
            super(message, cause);
            this.source = source2;
        }

        public FileDataException(String message, Throwable cause) {
            this(message, cause, null);
        }

        public String getDescription() {
            StringBuilder s2 = new StringBuilder();
            if (this.getMessage() != null) {
                s2.append(this.getMessage());
                s2.append(" ");
            }
            s2.append("[").append(this.getCause().toString()).append("]");
            if (this.source != null) {
                s2.append(": ").append(this.source.toString());
            }
            return s2.toString();
        }
    }
}

