/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;

final class DataStoreStatusProviderImpl
implements DataStoreStatusProvider {
    private final DataStore store;
    private final DataStoreUpdatesImpl dataStoreUpdates;

    DataStoreStatusProviderImpl(DataStore store, DataStoreUpdatesImpl dataStoreUpdates) {
        this.store = store;
        this.dataStoreUpdates = dataStoreUpdates;
    }

    @Override
    public DataStoreStatusProvider.Status getStatus() {
        return this.dataStoreUpdates.lastStatus.get();
    }

    @Override
    public void addStatusListener(DataStoreStatusProvider.StatusListener listener) {
        this.dataStoreUpdates.statusBroadcaster.register(listener);
    }

    @Override
    public void removeStatusListener(DataStoreStatusProvider.StatusListener listener) {
        this.dataStoreUpdates.statusBroadcaster.unregister(listener);
    }

    @Override
    public boolean isStatusMonitoringEnabled() {
        return this.store.isStatusMonitoringEnabled();
    }

    @Override
    public DataStoreStatusProvider.CacheStats getCacheStats() {
        return this.store.getCacheStats();
    }
}

