/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSortedMap;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class DataModelDependencies {
    private static Comparator<DataStoreTypes.DataKind> dataKindPriorityOrder = new Comparator<DataStoreTypes.DataKind>(){

        @Override
        public int compare(DataStoreTypes.DataKind o1, DataStoreTypes.DataKind o2) {
            return DataModelDependencies.getPriority(o1) - DataModelDependencies.getPriority(o2);
        }
    };

    private DataModelDependencies() {
    }

    public static Set<KindAndKey> computeDependenciesFrom(DataStoreTypes.DataKind fromKind, DataStoreTypes.ItemDescriptor fromItem) {
        if (fromItem == null || fromItem.getItem() == null) {
            return Collections.emptySet();
        }
        if (fromKind == DataModel.FEATURES) {
            DataModel.FeatureFlag flag = (DataModel.FeatureFlag)fromItem.getItem();
            Iterable prereqFlagKeys = Iterables.transform(flag.getPrerequisites(), p -> p.getKey());
            Iterable segmentKeys = Iterables.concat(Iterables.transform(flag.getRules(), rule -> Iterables.concat(Iterables.transform(rule.getClauses(), clause -> clause.getOp() == DataModel.Operator.segmentMatch ? Iterables.transform(clause.getValues(), LDValue::stringValue) : Collections.emptyList()))));
            return ImmutableSet.copyOf(Iterables.concat(Iterables.transform(prereqFlagKeys, key -> new KindAndKey(DataModel.FEATURES, (String)key)), Iterables.transform(segmentKeys, key -> new KindAndKey(DataModel.SEGMENTS, (String)key))));
        }
        return Collections.emptySet();
    }

    public static DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> sortAllCollections(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy(dataKindPriorityOrder);
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> entry : allData.getData()) {
            DataStoreTypes.DataKind kind = entry.getKey();
            builder.put(kind, DataModelDependencies.sortCollection(kind, entry.getValue()));
        }
        return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(((ImmutableSortedMap)builder.build()).entrySet());
    }

    private static DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> sortCollection(DataStoreTypes.DataKind kind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> input) {
        if (!DataModelDependencies.isDependencyOrdered(kind) || Iterables.isEmpty(input.getItems())) {
            return input;
        }
        HashMap<String, DataStoreTypes.ItemDescriptor> remainingItems = new HashMap<String, DataStoreTypes.ItemDescriptor>();
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e : input.getItems()) {
            remainingItems.put(e.getKey(), e.getValue());
        }
        ImmutableMap.Builder<String, DataStoreTypes.ItemDescriptor> builder = ImmutableMap.builder();
        while (!remainingItems.isEmpty()) {
            Iterator iterator2 = remainingItems.entrySet().iterator();
            if (!iterator2.hasNext()) continue;
            Map.Entry entry = iterator2.next();
            DataModelDependencies.addWithDependenciesFirst(kind, (String)entry.getKey(), (DataStoreTypes.ItemDescriptor)entry.getValue(), remainingItems, builder);
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(builder.build().entrySet());
    }

    private static void addWithDependenciesFirst(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item, Map<String, DataStoreTypes.ItemDescriptor> remainingItems, ImmutableMap.Builder<String, DataStoreTypes.ItemDescriptor> builder) {
        remainingItems.remove(key);
        for (KindAndKey dependency : DataModelDependencies.computeDependenciesFrom(kind, item)) {
            DataStoreTypes.ItemDescriptor prereqItem;
            if (dependency.kind != kind || (prereqItem = remainingItems.get(dependency.key)) == null) continue;
            DataModelDependencies.addWithDependenciesFirst(kind, dependency.key, prereqItem, remainingItems, builder);
        }
        builder.put(key, item);
    }

    private static boolean isDependencyOrdered(DataStoreTypes.DataKind kind) {
        return kind == DataModel.FEATURES;
    }

    private static int getPriority(DataStoreTypes.DataKind kind) {
        if (kind == DataModel.FEATURES) {
            return 1;
        }
        if (kind == DataModel.SEGMENTS) {
            return 0;
        }
        return kind.getName().length() + 2;
    }

    static class KindAndKey {
        final DataStoreTypes.DataKind kind;
        final String key;

        public KindAndKey(DataStoreTypes.DataKind kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof KindAndKey) {
                KindAndKey o = (KindAndKey)other;
                return this.kind == o.kind && this.key.equals(o.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.hashCode() * 31 + this.key.hashCode();
        }
    }

    static final class DependencyTracker {
        private final Map<KindAndKey, Set<KindAndKey>> dependenciesFrom = new HashMap<KindAndKey, Set<KindAndKey>>();
        private final Map<KindAndKey, Set<KindAndKey>> dependenciesTo = new HashMap<KindAndKey, Set<KindAndKey>>();

        DependencyTracker() {
        }

        public void updateDependenciesFrom(DataStoreTypes.DataKind fromKind, String fromKey, DataStoreTypes.ItemDescriptor fromItem) {
            KindAndKey fromWhat = new KindAndKey(fromKind, fromKey);
            Set<KindAndKey> updatedDependencies = DataModelDependencies.computeDependenciesFrom(fromKind, fromItem);
            Set<KindAndKey> oldDependencySet = this.dependenciesFrom.get(fromWhat);
            if (oldDependencySet != null) {
                for (KindAndKey oldDep : oldDependencySet) {
                    Set<KindAndKey> depsToThisOldDep = this.dependenciesTo.get(oldDep);
                    if (depsToThisOldDep == null) continue;
                    depsToThisOldDep.remove(fromWhat);
                }
            }
            this.dependenciesFrom.put(fromWhat, updatedDependencies);
            for (KindAndKey newDep : updatedDependencies) {
                Set<KindAndKey> depsToThisNewDep = this.dependenciesTo.get(newDep);
                if (depsToThisNewDep == null) {
                    depsToThisNewDep = new HashSet<KindAndKey>();
                    this.dependenciesTo.put(newDep, depsToThisNewDep);
                }
                depsToThisNewDep.add(fromWhat);
            }
        }

        public void reset() {
            this.dependenciesFrom.clear();
            this.dependenciesTo.clear();
        }

        public void addAffectedItems(Set<KindAndKey> itemsOut, KindAndKey initialModifiedItem) {
            if (!itemsOut.contains(initialModifiedItem)) {
                itemsOut.add(initialModifiedItem);
                Set<KindAndKey> affectedItems = this.dependenciesTo.get(initialModifiedItem);
                if (affectedItems != null) {
                    for (KindAndKey affectedItem : affectedItems) {
                        this.addAffectedItems(itemsOut, affectedItem);
                    }
                }
            }
        }
    }
}

