/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.Loggers;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;

final class PersistentDataStoreStatusManager {
    private static final Logger logger = Loggers.DATA_STORE;
    static final int POLL_INTERVAL_MS = 500;
    private final Consumer<DataStoreStatusProvider.Status> statusUpdater;
    private final ScheduledExecutorService scheduler;
    private final Callable<Boolean> statusPollFn;
    private final boolean refreshOnRecovery;
    private volatile boolean lastAvailable;
    private volatile ScheduledFuture<?> pollerFuture;

    PersistentDataStoreStatusManager(boolean refreshOnRecovery, boolean availableNow, Callable<Boolean> statusPollFn, Consumer<DataStoreStatusProvider.Status> statusUpdater, ScheduledExecutorService sharedExecutor) {
        this.refreshOnRecovery = refreshOnRecovery;
        this.lastAvailable = availableNow;
        this.statusPollFn = statusPollFn;
        this.statusUpdater = statusUpdater;
        this.scheduler = sharedExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAvailability(boolean available) {
        PersistentDataStoreStatusManager persistentDataStoreStatusManager = this;
        synchronized (persistentDataStoreStatusManager) {
            if (this.lastAvailable == available) {
                return;
            }
            this.lastAvailable = available;
        }
        DataStoreStatusProvider.Status status = new DataStoreStatusProvider.Status(available, available && this.refreshOnRecovery);
        if (available) {
            logger.warn("Persistent store is available again");
        }
        this.statusUpdater.accept(status);
        if (available) {
            PersistentDataStoreStatusManager persistentDataStoreStatusManager2 = this;
            synchronized (persistentDataStoreStatusManager2) {
                if (this.pollerFuture != null) {
                    this.pollerFuture.cancel(false);
                    this.pollerFuture = null;
                }
            }
        }
        logger.warn("Detected persistent store unavailability; updates will be cached until it recovers");
        Runnable pollerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (((Boolean)PersistentDataStoreStatusManager.this.statusPollFn.call()).booleanValue()) {
                        PersistentDataStoreStatusManager.this.updateAvailability(true);
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error from data store status function: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
        };
        PersistentDataStoreStatusManager persistentDataStoreStatusManager3 = this;
        synchronized (persistentDataStoreStatusManager3) {
            if (this.pollerFuture == null) {
                this.pollerFuture = this.scheduler.scheduleAtFixedRate(pollerTask, 500L, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

