/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceImpl;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.shaded.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public final class FileDataSourceBuilder
implements DataSourceFactory {
    final List<SourceInfo> sources = new ArrayList<SourceInfo>();
    private boolean autoUpdate = false;
    private FileData.DuplicateKeysHandling duplicateKeysHandling = FileData.DuplicateKeysHandling.FAIL;

    public FileDataSourceBuilder filePaths(String ... filePaths) throws InvalidPathException {
        for (String p : filePaths) {
            this.sources.add(new FilePathSourceInfo(Paths.get(p, new String[0])));
        }
        return this;
    }

    public FileDataSourceBuilder filePaths(Path ... filePaths) {
        for (Path p : filePaths) {
            this.sources.add(new FilePathSourceInfo(p));
        }
        return this;
    }

    public FileDataSourceBuilder classpathResources(String ... resourceLocations) {
        for (String location : resourceLocations) {
            this.sources.add(new ClasspathResourceSourceInfo(location));
        }
        return this;
    }

    public FileDataSourceBuilder autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public FileDataSourceBuilder duplicateKeysHandling(FileData.DuplicateKeysHandling duplicateKeysHandling) {
        this.duplicateKeysHandling = duplicateKeysHandling;
        return this;
    }

    @Override
    public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
        return new FileDataSourceImpl(dataSourceUpdates, this.sources, this.autoUpdate, this.duplicateKeysHandling);
    }

    static final class FilePathSourceInfo
    extends SourceInfo {
        final Path path;

        FilePathSourceInfo(Path path) {
            this.path = path;
        }

        @Override
        byte[] readData() throws IOException {
            return Files.readAllBytes(this.path);
        }

        @Override
        Path toFilePath() {
            return this.path;
        }

        public String toString() {
            return this.path.toString();
        }
    }

    static final class ClasspathResourceSourceInfo
    extends SourceInfo {
        String location;

        ClasspathResourceSourceInfo(String location) {
            this.location = location;
        }

        @Override
        byte[] readData() throws IOException {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.location);){
                if (is == null) {
                    throw new IOException("classpath resource not found");
                }
                byte[] byArray = ByteStreams.toByteArray(is);
                return byArray;
            }
        }

        @Override
        Path toFilePath() {
            return null;
        }

        public String toString() {
            return "classpath:" + this.location;
        }
    }

    static abstract class SourceInfo {
        SourceInfo() {
        }

        abstract byte[] readData() throws IOException;

        abstract Path toFilePath();
    }
}

