/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvaluatorTypeConversion;
import com.launchdarkly.sdk.server.SemanticVersion;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

abstract class EvaluatorPreprocessing {
    private EvaluatorPreprocessing() {
    }

    static void preprocessFlag(DataModel.FeatureFlag f) {
        for (DataModel.Prerequisite p : f.getPrerequisites()) {
            EvaluatorPreprocessing.preprocessPrerequisite(p);
        }
        List<DataModel.Rule> rules = f.getRules();
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            EvaluatorPreprocessing.preprocessFlagRule(rules.get(i), i);
        }
        EvaluatorPreprocessing.preprocessValueList(f.getVariations());
    }

    static void preprocessSegment(DataModel.Segment s2) {
        List<DataModel.SegmentRule> rules = s2.getRules();
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            EvaluatorPreprocessing.preprocessSegmentRule(rules.get(i), i);
        }
    }

    static void preprocessPrerequisite(DataModel.Prerequisite p) {
        p.setPrerequisiteFailedReason(EvaluationReason.prerequisiteFailed(p.getKey()));
    }

    static void preprocessFlagRule(DataModel.Rule r, int ruleIndex) {
        r.setRuleMatchReason(EvaluationReason.ruleMatch(ruleIndex, r.getId()));
        for (DataModel.Clause c : r.getClauses()) {
            EvaluatorPreprocessing.preprocessClause(c);
        }
    }

    static void preprocessSegmentRule(DataModel.SegmentRule r, int ruleIndex) {
        for (DataModel.Clause c : r.getClauses()) {
            EvaluatorPreprocessing.preprocessClause(c);
        }
    }

    static void preprocessClause(DataModel.Clause c) {
        List<LDValue> values2 = c.getValues();
        EvaluatorPreprocessing.preprocessValueList(values2);
        DataModel.Operator op = c.getOp();
        if (op == null) {
            return;
        }
        switch (op) {
            case in: {
                if (values2.size() <= 1) break;
                c.setPreprocessed(new ClauseExtra(ImmutableSet.copyOf(values2), null));
                break;
            }
            case matches: {
                c.setPreprocessed(EvaluatorPreprocessing.preprocessClauseValues(c.getValues(), v -> new ClauseExtra.ValueExtra(null, EvaluatorTypeConversion.valueToRegex(v), null)));
                break;
            }
            case after: 
            case before: {
                c.setPreprocessed(EvaluatorPreprocessing.preprocessClauseValues(c.getValues(), v -> new ClauseExtra.ValueExtra(EvaluatorTypeConversion.valueToDateTime(v), null, null)));
                break;
            }
            case semVerEqual: 
            case semVerGreaterThan: 
            case semVerLessThan: {
                c.setPreprocessed(EvaluatorPreprocessing.preprocessClauseValues(c.getValues(), v -> new ClauseExtra.ValueExtra(null, null, EvaluatorTypeConversion.valueToSemVer(v))));
                break;
            }
        }
    }

    static void preprocessValueList(List<LDValue> values2) {
        for (int i = 0; i < values2.size(); ++i) {
            if (values2.get(i) != null) continue;
            values2.set(i, LDValue.ofNull());
        }
    }

    private static ClauseExtra preprocessClauseValues(List<LDValue> values2, Function<LDValue, ClauseExtra.ValueExtra> f) {
        ArrayList<ClauseExtra.ValueExtra> valuesExtra = new ArrayList<ClauseExtra.ValueExtra>(values2.size());
        for (LDValue v : values2) {
            valuesExtra.add(f.apply(v));
        }
        return new ClauseExtra(null, valuesExtra);
    }

    static final class ClauseExtra {
        final Set<LDValue> valuesSet;
        final List<ValueExtra> valuesExtra;

        ClauseExtra(Set<LDValue> valuesSet, List<ValueExtra> valuesExtra) {
            this.valuesSet = valuesSet;
            this.valuesExtra = valuesExtra;
        }

        static final class ValueExtra {
            final ZonedDateTime parsedDate;
            final Pattern parsedRegex;
            final SemanticVersion parsedSemVer;

            ValueExtra(ZonedDateTime parsedDate, Pattern parsedRegex, SemanticVersion parsedSemVer) {
                this.parsedDate = parsedDate;
                this.parsedRegex = parsedRegex;
                this.parsedSemVer = parsedSemVer;
            }
        }
    }
}

