/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagTracker;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

final class FlagTrackerImpl
implements FlagTracker {
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster;
    private final BiFunction<String, LDUser, LDValue> evaluateFn;

    FlagTrackerImpl(EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster, BiFunction<String, LDUser, LDValue> evaluateFn) {
        this.flagChangeBroadcaster = flagChangeBroadcaster;
        this.evaluateFn = evaluateFn;
    }

    @Override
    public void addFlagChangeListener(FlagChangeListener listener) {
        this.flagChangeBroadcaster.register(listener);
    }

    @Override
    public void removeFlagChangeListener(FlagChangeListener listener) {
        this.flagChangeBroadcaster.unregister(listener);
    }

    @Override
    public FlagChangeListener addFlagValueChangeListener(String flagKey, LDUser user, FlagValueChangeListener listener) {
        FlagValueChangeAdapter adapter = new FlagValueChangeAdapter(flagKey, user, listener);
        this.addFlagChangeListener(adapter);
        return adapter;
    }

    private final class FlagValueChangeAdapter
    implements FlagChangeListener {
        private final String flagKey;
        private final LDUser user;
        private final FlagValueChangeListener listener;
        private final AtomicReference<LDValue> value;

        FlagValueChangeAdapter(String flagKey, LDUser user, FlagValueChangeListener listener) {
            this.flagKey = flagKey;
            this.user = user;
            this.listener = listener;
            this.value = new AtomicReference(FlagTrackerImpl.this.evaluateFn.apply(flagKey, user));
        }

        @Override
        public void onFlagChange(FlagChangeEvent event) {
            LDValue oldValue;
            LDValue newValue;
            if (event.getKey().equals(this.flagKey) && !(newValue = (LDValue)FlagTrackerImpl.this.evaluateFn.apply(this.flagKey, this.user)).equals(oldValue = this.value.getAndSet(newValue))) {
                this.listener.onFlagValueChange(new FlagValueChangeEvent(this.flagKey, oldValue, newValue));
            }
        }
    }
}

