/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.Helpers;
import com.launchdarkly.shaded.com.google.gson.JsonParseException;
import com.launchdarkly.shaded.com.google.gson.TypeAdapter;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;

final class EvaluationReasonTypeAdapter
extends TypeAdapter<EvaluationReason> {
    EvaluationReasonTypeAdapter() {
    }

    @Override
    public EvaluationReason read(JsonReader reader) throws IOException {
        return EvaluationReasonTypeAdapter.parse(reader);
    }

    static EvaluationReason parse(JsonReader reader) throws IOException {
        Enum kind = null;
        int ruleIndex = -1;
        String ruleId = null;
        String prereqKey = null;
        boolean inExperiment = false;
        EvaluationReason.ErrorKind errorKind = null;
        reader.beginObject();
        block24: while (reader.peek() != JsonToken.END_OBJECT) {
            String key;
            switch (key = reader.nextName()) {
                case "kind": {
                    kind = Helpers.readEnum(EvaluationReason.Kind.class, reader);
                    continue block24;
                }
                case "ruleIndex": {
                    ruleIndex = reader.nextInt();
                    continue block24;
                }
                case "ruleId": {
                    ruleId = Helpers.readNullableString(reader);
                    continue block24;
                }
                case "prerequisiteKey": {
                    prereqKey = reader.nextString();
                    continue block24;
                }
                case "inExperiment": {
                    inExperiment = reader.nextBoolean();
                    continue block24;
                }
                case "errorKind": {
                    errorKind = Helpers.readEnum(EvaluationReason.ErrorKind.class, reader);
                    continue block24;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (kind == null) {
            throw new JsonParseException("EvaluationReason missing required property \"kind\"");
        }
        switch (1.$SwitchMap$com$launchdarkly$sdk$EvaluationReason$Kind[kind.ordinal()]) {
            case 1: {
                return EvaluationReason.off();
            }
            case 2: {
                return EvaluationReason.fallthrough(inExperiment);
            }
            case 3: {
                return EvaluationReason.targetMatch();
            }
            case 4: {
                return EvaluationReason.ruleMatch(ruleIndex, ruleId, inExperiment);
            }
            case 5: {
                return EvaluationReason.prerequisiteFailed(prereqKey);
            }
            case 6: {
                return EvaluationReason.error(errorKind);
            }
        }
        return null;
    }

    @Override
    public void write(JsonWriter writer, EvaluationReason reason) throws IOException {
        writer.beginObject();
        writer.name("kind");
        writer.value(reason.getKind().name());
        switch (reason.getKind()) {
            case RULE_MATCH: {
                writer.name("ruleIndex");
                writer.value(reason.getRuleIndex());
                if (reason.getRuleId() != null) {
                    writer.name("ruleId");
                    writer.value(reason.getRuleId());
                }
                if (!reason.isInExperiment()) break;
                writer.name("inExperiment");
                writer.value(reason.isInExperiment());
                break;
            }
            case FALLTHROUGH: {
                if (!reason.isInExperiment()) break;
                writer.name("inExperiment");
                writer.value(reason.isInExperiment());
                break;
            }
            case PREREQUISITE_FAILED: {
                writer.name("prerequisiteKey");
                writer.value(reason.getPrerequisiteKey());
                break;
            }
            case ERROR: {
                writer.name("errorKind");
                writer.value(reason.getErrorKind().name());
                break;
            }
        }
        writer.endObject();
    }
}

