/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvaluatorPreprocessing;
import com.launchdarkly.sdk.server.EvaluatorTypeConversion;
import com.launchdarkly.sdk.server.SemanticVersion;
import java.time.Instant;
import java.util.regex.Pattern;

abstract class EvaluatorOperators {
    private EvaluatorOperators() {
    }

    static boolean apply(DataModel.Operator op, LDValue userValue, LDValue clauseValue, EvaluatorPreprocessing.ClauseExtra.ValueExtra preprocessed) {
        switch (op) {
            case in: {
                return userValue.equals(clauseValue);
            }
            case endsWith: {
                return userValue.isString() && clauseValue.isString() && userValue.stringValue().endsWith(clauseValue.stringValue());
            }
            case startsWith: {
                return userValue.isString() && clauseValue.isString() && userValue.stringValue().startsWith(clauseValue.stringValue());
            }
            case matches: {
                Pattern clausePattern = preprocessed == null ? EvaluatorTypeConversion.valueToRegex(clauseValue) : preprocessed.parsedRegex;
                return clausePattern != null && userValue.isString() && clausePattern.matcher(userValue.stringValue()).find();
            }
            case contains: {
                return userValue.isString() && clauseValue.isString() && userValue.stringValue().contains(clauseValue.stringValue());
            }
            case lessThan: {
                return EvaluatorOperators.compareNumeric(ComparisonOp.LT, userValue, clauseValue);
            }
            case lessThanOrEqual: {
                return EvaluatorOperators.compareNumeric(ComparisonOp.LTE, userValue, clauseValue);
            }
            case greaterThan: {
                return EvaluatorOperators.compareNumeric(ComparisonOp.GT, userValue, clauseValue);
            }
            case greaterThanOrEqual: {
                return EvaluatorOperators.compareNumeric(ComparisonOp.GTE, userValue, clauseValue);
            }
            case before: {
                return EvaluatorOperators.compareDate(ComparisonOp.LT, userValue, clauseValue, preprocessed);
            }
            case after: {
                return EvaluatorOperators.compareDate(ComparisonOp.GT, userValue, clauseValue, preprocessed);
            }
            case semVerEqual: {
                return EvaluatorOperators.compareSemVer(ComparisonOp.EQ, userValue, clauseValue, preprocessed);
            }
            case semVerLessThan: {
                return EvaluatorOperators.compareSemVer(ComparisonOp.LT, userValue, clauseValue, preprocessed);
            }
            case semVerGreaterThan: {
                return EvaluatorOperators.compareSemVer(ComparisonOp.GT, userValue, clauseValue, preprocessed);
            }
            case segmentMatch: {
                return false;
            }
        }
        return false;
    }

    private static boolean compareNumeric(ComparisonOp op, LDValue userValue, LDValue clauseValue) {
        double n2;
        if (!userValue.isNumber() || !clauseValue.isNumber()) {
            return false;
        }
        double n1 = userValue.doubleValue();
        int compare = n1 == (n2 = clauseValue.doubleValue()) ? 0 : (n1 < n2 ? -1 : 1);
        return op.test(compare);
    }

    private static boolean compareDate(ComparisonOp op, LDValue userValue, LDValue clauseValue, EvaluatorPreprocessing.ClauseExtra.ValueExtra preprocessed) {
        Instant clauseDate;
        Instant instant = clauseDate = preprocessed == null ? EvaluatorTypeConversion.valueToDateTime(clauseValue) : preprocessed.parsedDate;
        if (clauseDate == null) {
            return false;
        }
        Instant userDate = EvaluatorTypeConversion.valueToDateTime(userValue);
        if (userDate == null) {
            return false;
        }
        return op.test(userDate.compareTo(clauseDate));
    }

    private static boolean compareSemVer(ComparisonOp op, LDValue userValue, LDValue clauseValue, EvaluatorPreprocessing.ClauseExtra.ValueExtra preprocessed) {
        SemanticVersion clauseVer;
        SemanticVersion semanticVersion = clauseVer = preprocessed == null ? EvaluatorTypeConversion.valueToSemVer(clauseValue) : preprocessed.parsedSemVer;
        if (clauseVer == null) {
            return false;
        }
        SemanticVersion userVer = EvaluatorTypeConversion.valueToSemVer(userValue);
        if (userVer == null) {
            return false;
        }
        return op.test(userVer.compareTo(clauseVer));
    }

    private static enum ComparisonOp {
        EQ,
        LT,
        LTE,
        GT,
        GTE;


        boolean test(int delta) {
            switch (this) {
                case EQ: {
                    return delta == 0;
                }
                case LT: {
                    return delta < 0;
                }
                case LTE: {
                    return delta <= 0;
                }
                case GT: {
                    return delta > 0;
                }
                case GTE: {
                    return delta >= 0;
                }
            }
            return false;
        }
    }
}

