/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.interfaces.BasicConfiguration;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.LoggingConfiguration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

final class ClientContextImpl
implements ClientContext {
    private static volatile ScheduledExecutorService fallbackSharedExecutor = null;
    private final BasicConfiguration basicConfiguration;
    private final HttpConfiguration httpConfiguration;
    private final LoggingConfiguration loggingConfiguration;
    final ScheduledExecutorService sharedExecutor;
    final DiagnosticAccumulator diagnosticAccumulator;
    final DiagnosticEvent.Init diagnosticInitEvent;

    private ClientContextImpl(BasicConfiguration basicConfiguration, HttpConfiguration httpConfiguration, LoggingConfiguration loggingConfiguration, ScheduledExecutorService sharedExecutor, DiagnosticAccumulator diagnosticAccumulator, DiagnosticEvent.Init diagnosticInitEvent) {
        this.basicConfiguration = basicConfiguration;
        this.httpConfiguration = httpConfiguration;
        this.loggingConfiguration = loggingConfiguration;
        this.sharedExecutor = sharedExecutor;
        this.diagnosticAccumulator = diagnosticAccumulator;
        this.diagnosticInitEvent = diagnosticInitEvent;
    }

    ClientContextImpl(String sdkKey, LDConfig configuration, ScheduledExecutorService sharedExecutor, DiagnosticAccumulator diagnosticAccumulator) {
        this.basicConfiguration = new BasicConfiguration(sdkKey, configuration.offline, configuration.threadPriority, configuration.applicationInfo, configuration.serviceEndpoints);
        this.httpConfiguration = configuration.httpConfigFactory.createHttpConfiguration(this.basicConfiguration);
        this.loggingConfiguration = configuration.loggingConfigFactory.createLoggingConfiguration(this.basicConfiguration);
        this.sharedExecutor = sharedExecutor;
        if (!configuration.diagnosticOptOut && diagnosticAccumulator != null) {
            this.diagnosticAccumulator = diagnosticAccumulator;
            this.diagnosticInitEvent = new DiagnosticEvent.Init(diagnosticAccumulator.dataSinceDate, diagnosticAccumulator.diagnosticId, configuration, this.basicConfiguration, this.httpConfiguration);
        } else {
            this.diagnosticAccumulator = null;
            this.diagnosticInitEvent = null;
        }
    }

    @Override
    public BasicConfiguration getBasic() {
        return this.basicConfiguration;
    }

    @Override
    public HttpConfiguration getHttp() {
        return this.httpConfiguration;
    }

    @Override
    public LoggingConfiguration getLogging() {
        return this.loggingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientContextImpl get(ClientContext context) {
        if (context instanceof ClientContextImpl) {
            return (ClientContextImpl)context;
        }
        Class<ClientContextImpl> clazz = ClientContextImpl.class;
        synchronized (ClientContextImpl.class) {
            if (fallbackSharedExecutor == null) {
                fallbackSharedExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new ClientContextImpl(context.getBasic(), context.getHttp(), context.getLogging(), fallbackSharedExecutor, null, null);
        }
    }
}

