/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;

public class Event {
    private final long creationDate;
    private final LDUser user;

    public Event(long creationDate, LDUser user) {
        this.creationDate = creationDate;
        this.user = user;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public LDUser getUser() {
        return this.user;
    }

    private static final String computeContextKind(LDUser user) {
        return user != null && user.isAnonymous() ? "anonymousUser" : "user";
    }

    public static final class AliasEvent
    extends Event {
        private final String key;
        private final String contextKind;
        private final String previousKey;
        private final String previousContextKind;

        public AliasEvent(long timestamp, LDUser user, LDUser previousUser) {
            super(timestamp, user);
            this.key = user.getKey();
            this.contextKind = Event.computeContextKind(user);
            this.previousKey = previousUser.getKey();
            this.previousContextKind = Event.computeContextKind(previousUser);
        }

        public String getKey() {
            return this.key;
        }

        public String getContextKind() {
            return this.contextKind;
        }

        public String getPreviousKey() {
            return this.previousKey;
        }

        public String getPreviousContextKind() {
            return this.previousContextKind;
        }
    }

    public static final class FeatureRequest
    extends Event {
        private final String key;
        private final int variation;
        private final LDValue value;
        private final LDValue defaultVal;
        private final int version;
        private final String prereqOf;
        private final boolean trackEvents;
        private final long debugEventsUntilDate;
        private final EvaluationReason reason;
        private final boolean debug;
        private final String contextKind;

        public FeatureRequest(long timestamp, String key, LDUser user, int version, int variation, LDValue value, LDValue defaultVal, EvaluationReason reason, String prereqOf, boolean trackEvents, long debugEventsUntilDate, boolean debug) {
            super(timestamp, user);
            this.key = key;
            this.version = version;
            this.variation = variation;
            this.value = value;
            this.defaultVal = defaultVal;
            this.prereqOf = prereqOf;
            this.trackEvents = trackEvents;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.reason = reason;
            this.debug = debug;
            this.contextKind = Event.computeContextKind(user);
        }

        public String getKey() {
            return this.key;
        }

        public int getVariation() {
            return this.variation;
        }

        public LDValue getValue() {
            return this.value;
        }

        public LDValue getDefaultVal() {
            return this.defaultVal;
        }

        public int getVersion() {
            return this.version;
        }

        public String getPrereqOf() {
            return this.prereqOf;
        }

        public boolean isTrackEvents() {
            return this.trackEvents;
        }

        public long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        public EvaluationReason getReason() {
            return this.reason;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public String getContextKind() {
            return this.contextKind;
        }
    }

    public static final class Index
    extends Event {
        public Index(long timestamp, LDUser user) {
            super(timestamp, user);
        }
    }

    public static final class Identify
    extends Event {
        public Identify(long timestamp, LDUser user) {
            super(timestamp, user);
        }
    }

    public static final class Custom
    extends Event {
        private final String key;
        private final LDValue data;
        private final Double metricValue;
        private final String contextKind;

        public Custom(long timestamp, String key, LDUser user, LDValue data, Double metricValue) {
            super(timestamp, user);
            this.key = key;
            this.data = LDValue.normalize(data);
            this.metricValue = metricValue;
            this.contextKind = Event.computeContextKind(user);
        }

        public String getKey() {
            return this.key;
        }

        public LDValue getData() {
            return this.data;
        }

        public Double getMetricValue() {
            return this.metricValue;
        }

        public String getContextKind() {
            return this.contextKind;
        }
    }
}

