/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;

public final class BasicConfiguration {
    private final String sdkKey;
    private final boolean offline;
    private final int threadPriority;
    private final ApplicationInfo applicationInfo;
    private final ServiceEndpoints serviceEndpoints;

    public BasicConfiguration(String sdkKey, boolean offline, int threadPriority, ApplicationInfo applicationInfo, ServiceEndpoints serviceEndpoints) {
        this.sdkKey = sdkKey;
        this.offline = offline;
        this.threadPriority = threadPriority;
        this.applicationInfo = applicationInfo;
        this.serviceEndpoints = serviceEndpoints != null ? serviceEndpoints : Components.serviceEndpoints().createServiceEndpoints();
    }

    @Deprecated
    public BasicConfiguration(String sdkKey, boolean offline, int threadPriority, ApplicationInfo applicationInfo) {
        this(sdkKey, offline, threadPriority, applicationInfo, null);
    }

    @Deprecated
    public BasicConfiguration(String sdkKey, boolean offline, int threadPriority) {
        this(sdkKey, offline, threadPriority, null, null);
    }

    public String getSdkKey() {
        return this.sdkKey;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public ServiceEndpoints getServiceEndpoints() {
        return this.serviceEndpoints;
    }
}

