/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.BigSegmentStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BigSegmentStoreStatusProviderImplTest
extends BaseTest {
    private BigSegmentStoreStatusProvider.StatusListener mockStatusListener;
    private EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> mockEventBroadcaster;
    private final EasyMockSupport mocks = new EasyMockSupport();

    @Before
    public void setup() {
        this.mockEventBroadcaster = (EventBroadcasterImpl)this.mocks.strictMock(EventBroadcasterImpl.class);
        this.mockStatusListener = (BigSegmentStoreStatusProvider.StatusListener)this.mocks.strictMock(BigSegmentStoreStatusProvider.StatusListener.class);
    }

    @Test
    public void statusUnavailableWithNullWrapper() {
        this.mocks.replayAll();
        BigSegmentStoreStatusProviderImpl statusProvider = new BigSegmentStoreStatusProviderImpl(this.mockEventBroadcaster, null);
        Assert.assertEquals((Object)statusProvider.getStatus(), (Object)new BigSegmentStoreStatusProvider.Status(false, false));
        this.mocks.verifyAll();
    }

    @Test
    public void statusDelegatedToWrapper() {
        BigSegmentStoreWrapper storeWrapper = (BigSegmentStoreWrapper)this.mocks.strictMock(BigSegmentStoreWrapper.class);
        EasyMock.expect((Object)storeWrapper.getStatus()).andReturn((Object)new BigSegmentStoreStatusProvider.Status(true, false)).once();
        this.mocks.replayAll();
        BigSegmentStoreStatusProviderImpl statusProvider = new BigSegmentStoreStatusProviderImpl(this.mockEventBroadcaster, storeWrapper);
        Assert.assertEquals((Object)statusProvider.getStatus(), (Object)new BigSegmentStoreStatusProvider.Status(true, false));
        this.mocks.verifyAll();
    }

    @Test
    public void listenersDelegatedToEventBroadcaster() {
        this.mockEventBroadcaster.register((Object)((BigSegmentStoreStatusProvider.StatusListener)EasyMock.same((Object)this.mockStatusListener)));
        this.mockEventBroadcaster.unregister((Object)((BigSegmentStoreStatusProvider.StatusListener)EasyMock.same((Object)this.mockStatusListener)));
        this.mocks.replayAll();
        BigSegmentStoreStatusProviderImpl statusProvider = new BigSegmentStoreStatusProviderImpl(this.mockEventBroadcaster, null);
        statusProvider.addStatusListener(this.mockStatusListener);
        statusProvider.removeStatusListener(this.mockStatusListener);
        this.mocks.verifyAll();
    }
}

