/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorTypeConversion;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.SemanticVersion;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataModelPreprocessingTest {
    private static final LDValue aValue = LDValue.of((String)"a");
    private static final LDValue bValue = LDValue.of((String)"b");

    private DataModel.FeatureFlag flagFromClause(DataModel.Clause c) {
        return new DataModel.FeatureFlag("key", 0, false, null, null, null, null, this.rulesFromClause(c), null, null, null, false, false, false, null, false);
    }

    private List<DataModel.Rule> rulesFromClause(DataModel.Clause c) {
        return ImmutableList.of((Object)new DataModel.Rule("", (List)ImmutableList.of((Object)c), null, null, false));
    }

    @Test
    public void preprocessFlagAddsPrecomputedOffResult() {
        DataModel.FeatureFlag f = new DataModel.FeatureFlag("key", 0, false, null, null, null, null, (List)ImmutableList.of(), null, Integer.valueOf(0), (List)ImmutableList.of((Object)aValue, (Object)bValue), false, false, false, null, false);
        f.afterDeserialized();
        MatcherAssert.assertThat((Object)f.preprocessed, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)f.preprocessed.offResult, (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)aValue, (int)0, (EvaluationReason)EvaluationReason.off())));
    }

    @Test
    public void preprocessFlagAddsPrecomputedOffResultForNullOffVariation() {
        DataModel.FeatureFlag f = new DataModel.FeatureFlag("key", 0, false, null, null, null, null, (List)ImmutableList.of(), null, null, (List)ImmutableList.of((Object)aValue, (Object)bValue), false, false, false, null, false);
        f.afterDeserialized();
        MatcherAssert.assertThat((Object)f.preprocessed, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)f.preprocessed.offResult, (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)LDValue.ofNull(), (int)-1, (EvaluationReason)EvaluationReason.off())));
    }

    @Test
    public void preprocessFlagAddsPrecomputedFallthroughResults() {
        DataModel.FeatureFlag f = new DataModel.FeatureFlag("key", 0, false, null, null, null, null, (List)ImmutableList.of(), null, Integer.valueOf(0), (List)ImmutableList.of((Object)aValue, (Object)bValue), false, false, false, null, false);
        f.afterDeserialized();
        MatcherAssert.assertThat((Object)f.preprocessed, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)f.preprocessed.fallthroughResults, (Matcher)Matchers.notNullValue());
        EvaluationReason regularReason = EvaluationReason.fallthrough((boolean)false);
        EvaluationReason inExperimentReason = EvaluationReason.fallthrough((boolean)true);
        MatcherAssert.assertThat((Object)f.preprocessed.fallthroughResults.forVariation(0, false), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)aValue, (int)0, (EvaluationReason)regularReason)));
        MatcherAssert.assertThat((Object)f.preprocessed.fallthroughResults.forVariation(0, true), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)aValue, (int)0, (EvaluationReason)inExperimentReason)));
        MatcherAssert.assertThat((Object)f.preprocessed.fallthroughResults.forVariation(1, false), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)bValue, (int)1, (EvaluationReason)regularReason)));
        MatcherAssert.assertThat((Object)f.preprocessed.fallthroughResults.forVariation(1, true), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)bValue, (int)1, (EvaluationReason)inExperimentReason)));
    }

    @Test
    public void preprocessFlagAddsPrecomputedTargetMatchResults() {
        DataModel.FeatureFlag f = new DataModel.FeatureFlag("key", 0, false, null, null, (List)ImmutableList.of((Object)new DataModel.Target(null, (Set)ImmutableSet.of(), 1)), null, (List)ImmutableList.of(), null, Integer.valueOf(0), (List)ImmutableList.of((Object)aValue, (Object)bValue), false, false, false, null, false);
        f.afterDeserialized();
        DataModel.Target t = (DataModel.Target)f.getTargets().get(0);
        MatcherAssert.assertThat((Object)t.preprocessed, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)t.preprocessed.targetMatchResult, (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)bValue, (int)1, (EvaluationReason)EvaluationReason.targetMatch())));
    }

    @Test
    public void preprocessFlagAddsPrecomputedPrerequisiteFailedResults() {
        DataModel.FeatureFlag f = new DataModel.FeatureFlag("key", 0, false, (List)ImmutableList.of((Object)new DataModel.Prerequisite("abc", 1)), null, null, null, (List)ImmutableList.of(), null, Integer.valueOf(0), (List)ImmutableList.of((Object)aValue, (Object)bValue), false, false, false, null, false);
        f.afterDeserialized();
        DataModel.Prerequisite p = (DataModel.Prerequisite)f.getPrerequisites().get(0);
        MatcherAssert.assertThat((Object)p.preprocessed, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)p.preprocessed.prerequisiteFailedResult, (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)aValue, (int)0, (EvaluationReason)EvaluationReason.prerequisiteFailed((String)"abc"))));
    }

    @Test
    public void preprocessFlagAddsPrecomputedResultsToFlagRules() {
        DataModel.FeatureFlag f = new DataModel.FeatureFlag("key", 0, false, null, null, null, null, (List)ImmutableList.of((Object)new DataModel.Rule("ruleid0", (List)ImmutableList.of(), null, null, false)), null, null, (List)ImmutableList.of((Object)aValue, (Object)bValue), false, false, false, null, false);
        f.afterDeserialized();
        DataModel.Rule rule = (DataModel.Rule)f.getRules().get(0);
        MatcherAssert.assertThat((Object)rule.preprocessed, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)rule.preprocessed.allPossibleResults, (Matcher)Matchers.notNullValue());
        EvaluationReason regularReason = EvaluationReason.ruleMatch((int)0, (String)"ruleid0", (boolean)false);
        EvaluationReason inExperimentReason = EvaluationReason.ruleMatch((int)0, (String)"ruleid0", (boolean)true);
        MatcherAssert.assertThat((Object)rule.preprocessed.allPossibleResults.forVariation(0, false), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)aValue, (int)0, (EvaluationReason)regularReason)));
        MatcherAssert.assertThat((Object)rule.preprocessed.allPossibleResults.forVariation(0, true), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)aValue, (int)0, (EvaluationReason)inExperimentReason)));
        MatcherAssert.assertThat((Object)rule.preprocessed.allPossibleResults.forVariation(1, false), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)bValue, (int)1, (EvaluationReason)regularReason)));
        MatcherAssert.assertThat((Object)rule.preprocessed.allPossibleResults.forVariation(1, true), (Matcher)Matchers.equalTo((Object)EvalResult.of((LDValue)bValue, (int)1, (EvaluationReason)inExperimentReason)));
    }

    @Test
    public void preprocessFlagCreatesClauseValuesMapForMultiValueEqualityTest() {
        DataModel.Clause c = ModelBuilders.clause("x", DataModel.Operator.in, LDValue.of((String)"a"), LDValue.of((int)0));
        DataModel.FeatureFlag f = this.flagFromClause(c);
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
        f.afterDeserialized();
        DataModelPreprocessing.ClausePreprocessed ce = ((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed;
        Assert.assertNotNull((Object)ce);
        Assert.assertEquals((Object)ImmutableSet.of((Object)LDValue.of((String)"a"), (Object)LDValue.of((int)0)), (Object)ce.valuesSet);
    }

    @Test
    public void preprocessFlagDoesNotCreateClauseValuesMapForSingleValueEqualityTest() {
        DataModel.Clause c = ModelBuilders.clause("x", DataModel.Operator.in, LDValue.of((String)"a"));
        DataModel.FeatureFlag f = this.flagFromClause(c);
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
        f.afterDeserialized();
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
    }

    @Test
    public void preprocessFlagDoesNotCreateClauseValuesMapForEmptyEqualityTest() {
        DataModel.Clause c = ModelBuilders.clause("x", DataModel.Operator.in, new LDValue[0]);
        DataModel.FeatureFlag f = this.flagFromClause(c);
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
        f.afterDeserialized();
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
    }

    @Test
    public void preprocessFlagDoesNotCreateClauseValuesMapForNonEqualityOperators() {
        for (DataModel.Operator op : DataModel.Operator.getBuiltins()) {
            if (op == DataModel.Operator.in) continue;
            DataModel.Clause c = ModelBuilders.clause("x", op, LDValue.of((String)"a"), LDValue.of((String)"b"));
            DataModel.FeatureFlag f = this.flagFromClause(c);
            Assert.assertNull((String)op.toString(), (Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
            f.afterDeserialized();
            DataModelPreprocessing.ClausePreprocessed ce = ((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed;
            if (ce == null) continue;
            Assert.assertNull((Object)ce.valuesSet);
        }
    }

    @Test
    public void preprocessFlagParsesClauseDate() {
        String time1Str = "2016-04-16T17:09:12-07:00";
        Instant time1 = ZonedDateTime.parse(time1Str).toInstant();
        int time2Num = 1000000;
        Instant time2 = Instant.ofEpochMilli(time2Num);
        for (DataModel.Operator op : new DataModel.Operator[]{DataModel.Operator.after, DataModel.Operator.before}) {
            DataModel.Clause c = ModelBuilders.clause("x", op, LDValue.of((String)time1Str), LDValue.of((int)time2Num), LDValue.of((String)"x"), LDValue.of((boolean)false));
            DataModel.FeatureFlag f = this.flagFromClause(c);
            Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
            f.afterDeserialized();
            DataModelPreprocessing.ClausePreprocessed ce = ((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed;
            Assert.assertNotNull((String)op.name(), (Object)ce);
            Assert.assertNotNull((String)op.name(), (Object)ce.valuesExtra);
            Assert.assertEquals((String)op.name(), (long)4L, (long)ce.valuesExtra.size());
            Assert.assertEquals((String)op.name(), (Object)time1, (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedDate);
            Assert.assertEquals((String)op.name(), (Object)time2, (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)1)).parsedDate);
            Assert.assertNull((String)op.name(), (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)2)).parsedDate);
            Assert.assertNull((String)op.name(), (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)3)).parsedDate);
        }
    }

    @Test
    public void preprocessFlagParsesClauseRegex() {
        DataModel.Clause c = ModelBuilders.clause("x", DataModel.Operator.matches, LDValue.of((String)"x*"), LDValue.of((String)"***not a regex"), LDValue.of((int)3));
        DataModel.FeatureFlag f = this.flagFromClause(c);
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
        f.afterDeserialized();
        DataModelPreprocessing.ClausePreprocessed ce = ((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed;
        Assert.assertNotNull((Object)ce);
        Assert.assertNotNull((Object)ce.valuesExtra);
        Assert.assertEquals((long)3L, (long)ce.valuesExtra.size());
        Assert.assertNotNull((Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedRegex);
        Assert.assertEquals((Object)"x*", (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedRegex.toString());
        Assert.assertNull((Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)1)).parsedRegex);
        Assert.assertNull((Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)2)).parsedRegex);
    }

    @Test
    public void preprocessFlagParsesClauseSemVer() {
        SemanticVersion expected = EvaluatorTypeConversion.valueToSemVer((LDValue)LDValue.of((String)"1.2.3"));
        Assert.assertNotNull((Object)expected);
        for (DataModel.Operator op : new DataModel.Operator[]{DataModel.Operator.semVerEqual, DataModel.Operator.semVerGreaterThan, DataModel.Operator.semVerLessThan}) {
            DataModel.Clause c = ModelBuilders.clause("x", op, LDValue.of((String)"1.2.3"), LDValue.of((String)"x"), LDValue.of((boolean)false));
            DataModel.FeatureFlag f = this.flagFromClause(c);
            Assert.assertNull((Object)((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
            f.afterDeserialized();
            DataModelPreprocessing.ClausePreprocessed ce = ((DataModel.Clause)((DataModel.Rule)f.getRules().get((int)0)).getClauses().get((int)0)).preprocessed;
            Assert.assertNotNull((String)op.name(), (Object)ce);
            Assert.assertNotNull((String)op.name(), (Object)ce.valuesExtra);
            Assert.assertEquals((String)op.name(), (long)3L, (long)ce.valuesExtra.size());
            Assert.assertNotNull((String)op.name(), (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedSemVer);
            Assert.assertEquals((String)op.name(), (long)0L, (long)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedSemVer.compareTo(expected));
            Assert.assertNull((String)op.name(), (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)1)).parsedSemVer);
            Assert.assertNull((String)op.name(), (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)2)).parsedSemVer);
        }
    }

    @Test
    public void preprocessSegmentPreprocessesClausesInRules() {
        DataModel.Clause c = ModelBuilders.clause("x", DataModel.Operator.matches, LDValue.of((String)"x*"));
        DataModel.SegmentRule rule = ModelBuilders.segmentRuleBuilder().clauses(c).build();
        DataModel.Segment s = ModelBuilders.segmentBuilder("key").disablePreprocessing(true).rules(rule).build();
        Assert.assertNull((Object)((DataModel.Clause)((DataModel.SegmentRule)s.getRules().get((int)0)).getClauses().get((int)0)).preprocessed);
        s.afterDeserialized();
        DataModelPreprocessing.ClausePreprocessed ce = ((DataModel.Clause)((DataModel.SegmentRule)s.getRules().get((int)0)).getClauses().get((int)0)).preprocessed;
        Assert.assertNotNull((Object)ce.valuesExtra);
        Assert.assertEquals((long)1L, (long)ce.valuesExtra.size());
        Assert.assertNotNull((Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedRegex);
        Assert.assertEquals((Object)"x*", (Object)((DataModelPreprocessing.ClausePreprocessed.ValueData)ce.valuesExtra.get((int)0)).parsedRegex.toString());
    }
}

