/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelSerialization;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import com.launchdarkly.testhelpers.JsonAssertions;
import java.util.Collections;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class DataModelSerializationTest {
    @Test
    public void deserializeFlagFromParsedJson() {
        String json = "{\"key\":\"flagkey\",\"version\":1}";
        JsonElement element = (JsonElement)JsonHelpers.gsonInstance().fromJson(json, JsonElement.class);
        DataModel.VersionedData flag = DataModelSerialization.deserializeFromParsedJson((DataStoreTypes.DataKind)DataModel.FEATURES, (JsonElement)element);
        Assert.assertEquals(DataModel.FeatureFlag.class, flag.getClass());
        Assert.assertEquals((Object)"flagkey", (Object)flag.getKey());
        Assert.assertEquals((long)1L, (long)flag.getVersion());
    }

    @Test(expected=SerializationException.class)
    public void deserializeInvalidFlagFromParsedJson() {
        String json = "{\"key\":[3]}";
        JsonElement element = (JsonElement)JsonHelpers.gsonInstance().fromJson(json, JsonElement.class);
        DataModelSerialization.deserializeFromParsedJson((DataStoreTypes.DataKind)DataModel.FEATURES, (JsonElement)element);
    }

    @Test
    public void deserializeSegmentFromParsedJson() {
        String json = "{\"key\":\"segkey\",\"version\":1}";
        JsonElement element = (JsonElement)JsonHelpers.gsonInstance().fromJson(json, JsonElement.class);
        DataModel.VersionedData segment = DataModelSerialization.deserializeFromParsedJson((DataStoreTypes.DataKind)DataModel.SEGMENTS, (JsonElement)element);
        Assert.assertEquals(DataModel.Segment.class, segment.getClass());
        Assert.assertEquals((Object)"segkey", (Object)segment.getKey());
        Assert.assertEquals((long)1L, (long)segment.getVersion());
    }

    @Test(expected=SerializationException.class)
    public void deserializeInvalidSegmentFromParsedJson() {
        String json = "{\"key\":[3]}";
        JsonElement element = (JsonElement)JsonHelpers.gsonInstance().fromJson(json, JsonElement.class);
        DataModelSerialization.deserializeFromParsedJson((DataStoreTypes.DataKind)DataModel.SEGMENTS, (JsonElement)element);
    }

    @Test(expected=SerializationException.class)
    public void deserializeInvalidDataKindFromParsedJson() {
        String json = "{\"key\":\"something\",\"version\":1}";
        JsonElement element = (JsonElement)JsonHelpers.gsonInstance().fromJson(json, JsonElement.class);
        DataStoreTypes.DataKind mysteryKind = new DataStoreTypes.DataKind("incorrect", null, null);
        DataModelSerialization.deserializeFromParsedJson((DataStoreTypes.DataKind)mysteryKind, (JsonElement)element);
    }

    @Test
    public void flagIsDeserializedWithAllProperties() {
        this.assertFlagFromJson(this.flagWithAllPropertiesJson(), flag -> {
            this.assertFlagHasAllProperties((DataModel.FeatureFlag)flag);
            String json1 = DataModel.FEATURES.serialize(new DataStoreTypes.ItemDescriptor(flag.getVersion(), flag));
            this.assertFlagFromJson(LDValue.parse((String)json1), flag1 -> this.assertFlagHasAllProperties((DataModel.FeatureFlag)flag1));
        });
    }

    @Test
    public void flagIsDeserializedWithMinimalProperties() {
        this.assertFlagFromJson(LDValue.buildObject().put("key", "flag-key").put("version", 99).build(), flag -> {
            Assert.assertEquals((Object)"flag-key", (Object)flag.getKey());
            Assert.assertEquals((long)99L, (long)flag.getVersion());
            Assert.assertFalse((boolean)flag.isOn());
            Assert.assertNull((Object)flag.getSalt());
            Assert.assertNotNull((Object)flag.getTargets());
            Assert.assertEquals((long)0L, (long)flag.getTargets().size());
            Assert.assertNotNull((Object)flag.getRules());
            Assert.assertEquals((long)0L, (long)flag.getRules().size());
            Assert.assertNull((Object)flag.getFallthrough());
            Assert.assertNull((Object)flag.getOffVariation());
            Assert.assertNotNull((Object)flag.getVariations());
            Assert.assertEquals((long)0L, (long)flag.getVariations().size());
            Assert.assertFalse((boolean)flag.isClientSide());
            Assert.assertFalse((boolean)flag.isTrackEvents());
            Assert.assertFalse((boolean)flag.isTrackEventsFallthrough());
            Assert.assertNull((Object)flag.getDebugEventsUntilDate());
        });
    }

    @Test
    public void flagIsDeserializedWithOptionalExperimentProperties() {
        String json = LDValue.buildObject().put("key", "flag-key").put("version", 157).put("rules", LDValue.buildArray().add(LDValue.buildObject().put("id", "id1").put("rollout", LDValue.buildObject().put("variations", LDValue.buildArray().add(LDValue.buildObject().put("variation", 2).put("weight", 100000).build()).build()).put("bucketBy", "email").build()).build()).build()).put("fallthrough", LDValue.buildObject().put("variation", 1).build()).put("offVariation", 2).put("variations", LDValue.buildArray().add("a").add("b").add("c").build()).build().toJsonString();
        DataModel.FeatureFlag flag = (DataModel.FeatureFlag)DataModel.FEATURES.deserialize(json).getItem();
        Assert.assertEquals((Object)"flag-key", (Object)flag.getKey());
        Assert.assertEquals((long)157L, (long)flag.getVersion());
        Assert.assertFalse((boolean)flag.isOn());
        Assert.assertNull((Object)flag.getSalt());
        Assert.assertNotNull((Object)flag.getTargets());
        Assert.assertEquals((long)0L, (long)flag.getTargets().size());
        Assert.assertNotNull((Object)flag.getRules());
        Assert.assertEquals((long)1L, (long)flag.getRules().size());
        Assert.assertEquals((Object)DataModel.RolloutKind.rollout, (Object)((DataModel.Rule)flag.getRules().get(0)).getRollout().getKind());
        Assert.assertFalse((boolean)((DataModel.Rule)flag.getRules().get(0)).getRollout().isExperiment());
        Assert.assertNull((Object)((DataModel.Rule)flag.getRules().get(0)).getRollout().getSeed());
        Assert.assertEquals((long)2L, (long)((DataModel.WeightedVariation)((DataModel.Rule)flag.getRules().get(0)).getRollout().getVariations().get(0)).getVariation());
        Assert.assertEquals((long)100000L, (long)((DataModel.WeightedVariation)((DataModel.Rule)flag.getRules().get(0)).getRollout().getVariations().get(0)).getWeight());
        Assert.assertFalse((boolean)((DataModel.WeightedVariation)((DataModel.Rule)flag.getRules().get(0)).getRollout().getVariations().get(0)).isUntracked());
        Assert.assertNotNull((Object)flag.getVariations());
        Assert.assertEquals((long)3L, (long)flag.getVariations().size());
        Assert.assertFalse((boolean)flag.isClientSide());
        Assert.assertFalse((boolean)flag.isTrackEvents());
        Assert.assertFalse((boolean)flag.isTrackEventsFallthrough());
        Assert.assertNull((Object)flag.getDebugEventsUntilDate());
    }

    @Test
    public void flagRuleBasicProperties() {
        LDValue ruleJson = LDValue.buildObject().put("id", "id0").put("variation", 2).put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertFlagRuleFromJson(ruleJson, r -> {
            Assert.assertEquals((Object)"id0", (Object)r.getId());
            Assert.assertEquals((Object)2, (Object)r.getVariation());
            Assert.assertNull((Object)r.getRollout());
            Assert.assertFalse((boolean)r.isTrackEvents());
        });
    }

    @Test
    public void flagRuleTrackEvents() {
        LDValue ruleJson = LDValue.buildObject().put("id", "id0").put("variation", 2).put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).put("trackEvents", true).build();
        this.assertFlagRuleFromJson(ruleJson, r -> Assert.assertTrue((boolean)r.isTrackEvents()));
    }

    @Test
    public void flagRuleRollout() {
        LDValue ruleJson = LDValue.buildObject().put("id", "id0").put("rollout", LDValue.buildObject().put("variations", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("variation", 2).put("weight", 100000).build()})).build()).put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertFlagRuleFromJson(ruleJson, r -> {
            Assert.assertNull((Object)r.getVariation());
            Assert.assertNotNull((Object)r.getRollout());
            Assert.assertEquals((Object)DataModel.RolloutKind.rollout, (Object)r.getRollout().getKind());
            Assert.assertNull((Object)r.getRollout().getSeed());
            Assert.assertNull((Object)r.getRollout().getContextKind());
            Assert.assertNull((Object)r.getRollout().getBucketBy());
            Assert.assertEquals((long)1L, (long)r.getRollout().getVariations().size());
            Assert.assertEquals((long)2L, (long)((DataModel.WeightedVariation)r.getRollout().getVariations().get(0)).getVariation());
            Assert.assertEquals((long)100000L, (long)((DataModel.WeightedVariation)r.getRollout().getVariations().get(0)).getWeight());
        });
    }

    @Test
    public void flagRuleRolloutBucketByWithoutContextKind() {
        LDValue ruleJson = LDValue.buildObject().put("id", "id0").put("rollout", LDValue.buildObject().put("bucketBy", "/attr1").put("variations", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("variation", 2).put("weight", 100000).build()})).build()).put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertFlagRuleFromJson(ruleJson, r -> {
            Assert.assertNotNull((Object)r.getRollout());
            Assert.assertEquals((Object)AttributeRef.fromLiteral((String)"/attr1"), (Object)r.getRollout().getBucketBy());
        });
    }

    @Test
    public void flagRuleRolloutContextKind() {
        LDValue ruleJson = LDValue.buildObject().put("id", "id0").put("rollout", LDValue.buildObject().put("contextKind", "org").put("bucketBy", "/address/street").put("variations", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("variation", 2).put("weight", 100000).build()})).build()).put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertFlagRuleFromJson(ruleJson, r -> {
            Assert.assertNotNull((Object)r.getRollout());
            Assert.assertEquals((Object)ContextKind.of((String)"org"), (Object)r.getRollout().getContextKind());
            Assert.assertEquals((Object)AttributeRef.fromPath((String)"/address/street"), (Object)r.getRollout().getBucketBy());
        });
    }

    @Test
    public void flagRuleExperiment() {
        LDValue ruleJson = LDValue.buildObject().put("id", "id0").put("rollout", LDValue.buildObject().put("kind", "experiment").put("variations", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("variation", 2).put("weight", 100000).build()})).put("seed", 123).build()).put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertFlagRuleFromJson(ruleJson, r -> {
            Assert.assertNotNull((Object)r.getRollout());
            Assert.assertEquals((Object)DataModel.RolloutKind.experiment, (Object)r.getRollout().getKind());
            Assert.assertEquals((Object)123, (Object)r.getRollout().getSeed());
        });
    }

    @Test
    public void flagClauseWithContextKind() {
        LDValue clauseJson = LDValue.buildObject().put("contextKind", "org").put("attribute", "/address/street").put("op", "in").put("values", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertClauseFromJson(clauseJson, c -> {
            Assert.assertEquals((Object)ContextKind.of((String)"org"), (Object)c.getContextKind());
            Assert.assertEquals((Object)AttributeRef.fromPath((String)"/address/street"), (Object)c.getAttribute());
        });
    }

    @Test
    public void flagClauseWithoutContextKind() {
        LDValue clauseJson = LDValue.buildObject().put("attribute", "/attr1").put("op", "in").put("values", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertClauseFromJson(clauseJson, c -> {
            Assert.assertNull((Object)c.getContextKind());
            Assert.assertEquals((Object)AttributeRef.fromLiteral((String)"/attr1"), (Object)c.getAttribute());
        });
    }

    @Test
    public void flagClauseNegated() {
        LDValue clauseJson = LDValue.buildObject().put("negate", true).put("attribute", "attr1").put("op", "in").put("values", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertClauseFromJson(clauseJson, c -> Assert.assertTrue((boolean)c.isNegate()));
    }

    @Test
    public void deletedFlagIsConvertedToAndFromJsonPlaceholder() {
        String json0 = LDValue.buildObject().put("version", 99).put("deleted", true).build().toJsonString();
        DataStoreTypes.ItemDescriptor item = DataModel.FEATURES.deserialize(json0);
        Assert.assertNotNull((Object)item);
        Assert.assertNull((Object)item.getItem());
        Assert.assertEquals((long)99L, (long)item.getVersion());
        String json1 = DataModel.FEATURES.serialize(item);
        JsonAssertions.assertJsonEquals((String)json0, (String)json1);
    }

    @Test
    public void segmentIsDeserializedWithAllProperties() {
        String json0 = this.segmentWithAllPropertiesJson().toJsonString();
        DataModel.Segment segment0 = (DataModel.Segment)DataModel.SEGMENTS.deserialize(json0).getItem();
        this.assertSegmentHasAllProperties(segment0);
        String json1 = DataModel.SEGMENTS.serialize(new DataStoreTypes.ItemDescriptor(segment0.getVersion(), (Object)segment0));
        DataModel.Segment segment1 = (DataModel.Segment)DataModel.SEGMENTS.deserialize(json1).getItem();
        this.assertSegmentHasAllProperties(segment1);
    }

    @Test
    public void segmentIsDeserializedWithMinimalProperties() {
        String json = LDValue.buildObject().put("key", "segment-key").put("version", 99).build().toJsonString();
        DataModel.Segment segment = (DataModel.Segment)DataModel.SEGMENTS.deserialize(json).getItem();
        Assert.assertEquals((Object)"segment-key", (Object)segment.getKey());
        Assert.assertEquals((long)99L, (long)segment.getVersion());
        Assert.assertNotNull((Object)segment.getIncluded());
        Assert.assertEquals((long)0L, (long)segment.getIncluded().size());
        Assert.assertNotNull((Object)segment.getExcluded());
        Assert.assertEquals((long)0L, (long)segment.getExcluded().size());
        Assert.assertNotNull((Object)segment.getRules());
        Assert.assertEquals((long)0L, (long)segment.getRules().size());
        Assert.assertFalse((boolean)segment.isUnbounded());
        Assert.assertNull((Object)segment.getGeneration());
    }

    @Test
    public void segmentUnboundedWithoutContextKind() {
        LDValue segmentJson = LDValue.buildObject().put("key", "segmentkey").put("version", 1).put("unbounded", true).put("generation", 10).build();
        this.assertSegmentFromJson(segmentJson, s -> {
            Assert.assertTrue((boolean)s.isUnbounded());
            Assert.assertNull((Object)s.getUnboundedContextKind());
            Assert.assertEquals((Object)10, (Object)s.getGeneration());
        });
    }

    @Test
    public void segmentUnboundedWithContextKind() {
        LDValue segmentJson = LDValue.buildObject().put("key", "segmentkey").put("version", 1).put("unbounded", true).put("unboundedContextKind", "org").put("generation", 10).build();
        this.assertSegmentFromJson(segmentJson, s -> {
            Assert.assertTrue((boolean)s.isUnbounded());
            Assert.assertEquals((Object)ContextKind.of((String)"org"), (Object)s.getUnboundedContextKind());
            Assert.assertEquals((Object)10, (Object)s.getGeneration());
        });
    }

    @Test
    public void segmentRuleByWithoutRollout() {
        LDValue ruleJson = LDValue.buildObject().put("clauses", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("attribute", "attr1").put("op", "in").put("values", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.of((int)3)})).build()})).build();
        this.assertSegmentRuleFromJson(ruleJson, r -> {
            Assert.assertNull((Object)r.getWeight());
            Assert.assertNull((Object)r.getRolloutContextKind());
            Assert.assertNull((Object)r.getBucketBy());
            Assert.assertEquals((long)1L, (long)r.getClauses().size());
            Assert.assertEquals((Object)AttributeRef.fromLiteral((String)"attr1"), (Object)((DataModel.Clause)r.getClauses().get(0)).getAttribute());
            Assert.assertEquals((Object)DataModel.Operator.in, (Object)((DataModel.Clause)r.getClauses().get(0)).getOp());
            Assert.assertEquals((Object)ImmutableList.of((Object)LDValue.of((int)3)), (Object)((DataModel.Clause)r.getClauses().get(0)).getValues());
        });
    }

    @Test
    public void segmentRuleRolloutBucketByWithoutContextKind() {
        LDValue ruleJson = LDValue.buildObject().put("weight", 50000).put("bucketBy", "/attr1").put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertSegmentRuleFromJson(ruleJson, r -> {
            Assert.assertEquals((Object)50000, (Object)r.getWeight());
            Assert.assertNull((Object)r.getRolloutContextKind());
            Assert.assertEquals((Object)AttributeRef.fromLiteral((String)"/attr1"), (Object)r.getBucketBy());
        });
    }

    @Test
    public void segmentRuleRolloutWithContextKind() {
        LDValue ruleJson = LDValue.buildObject().put("weight", 50000).put("rolloutContextKind", "org").put("bucketBy", "/address/street").put("clauses", LDValue.arrayOf((LDValue[])new LDValue[0])).build();
        this.assertSegmentRuleFromJson(ruleJson, r -> {
            Assert.assertEquals((Object)50000, (Object)r.getWeight());
            Assert.assertEquals((Object)ContextKind.of((String)"org"), (Object)r.getRolloutContextKind());
            Assert.assertEquals((Object)AttributeRef.fromPath((String)"/address/street"), (Object)r.getBucketBy());
        });
    }

    @Test
    public void deletedSegmentIsConvertedToAndFromJsonPlaceholder() {
        String json0 = LDValue.buildObject().put("version", 99).put("deleted", true).build().toJsonString();
        DataStoreTypes.ItemDescriptor item = DataModel.SEGMENTS.deserialize(json0);
        Assert.assertNotNull((Object)item);
        Assert.assertNull((Object)item.getItem());
        Assert.assertEquals((long)99L, (long)item.getVersion());
        String json1 = DataModel.SEGMENTS.serialize(item);
        JsonAssertions.assertJsonEquals((String)json0, (String)json1);
    }

    @Test
    public void explicitNullsAreToleratedForNullableValues() {
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("offVariation", LDValue.ofNull()).build(), flag -> Assert.assertNull((Object)flag.getOffVariation()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("fallthrough", LDValue.buildObject().put("rollout", LDValue.ofNull()).build()).build(), flag -> Assert.assertNull((Object)flag.getFallthrough().getRollout()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("fallthrough", LDValue.buildObject().put("variation", LDValue.ofNull()).build()).build(), flag -> Assert.assertNull((Object)flag.getFallthrough().getVariation()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("prerequisites", LDValue.ofNull()).build(), flag -> Assert.assertEquals(Collections.emptyList(), (Object)flag.getPrerequisites()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("rules", LDValue.ofNull()).build(), flag -> Assert.assertEquals(Collections.emptyList(), (Object)flag.getRules()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("targets", LDValue.ofNull()).build(), flag -> Assert.assertEquals(Collections.emptyList(), (Object)flag.getTargets()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("clauses", LDValue.ofNull()).build()})).build(), flag -> Assert.assertEquals(Collections.emptyList(), (Object)((DataModel.Rule)flag.getRules().get(0)).getClauses()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("clauses", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("values", LDValue.ofNull()).build()})).build()})).build(), flag -> Assert.assertEquals(Collections.emptyList(), (Object)((DataModel.Clause)((DataModel.Rule)flag.getRules().get(0)).getClauses().get(0)).getValues()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("targets", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("values", LDValue.ofNull()).build()})).build(), flag -> Assert.assertEquals(Collections.emptySet(), (Object)((DataModel.Target)flag.getTargets().get(0)).getValues()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("fallthrough", LDValue.buildObject().put("rollout", LDValue.buildObject().put("variations", LDValue.ofNull()).build()).build()).build(), flag -> Assert.assertEquals(Collections.emptyList(), (Object)flag.getFallthrough().getRollout().getVariations()));
        this.assertSegmentFromJson(this.baseBuilder("segment-key").put("rules", LDValue.ofNull()).build(), segment -> Assert.assertEquals(Collections.emptyList(), (Object)segment.getRules()));
        this.assertSegmentFromJson(this.baseBuilder("segment-key").put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("clauses", LDValue.ofNull()).build()})).build(), segment -> Assert.assertEquals(Collections.emptyList(), (Object)((DataModel.SegmentRule)segment.getRules().get(0)).getClauses()));
        this.assertSegmentFromJson(this.baseBuilder("segment-key").put("generation", LDValue.ofNull()).build(), segment -> Assert.assertNull((Object)segment.getGeneration()));
        this.assertFlagFromJson(this.baseBuilder("flag-key").put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("clauses", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("values", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.ofNull()})).build()})).build()})).build(), flag -> Assert.assertEquals((Object)LDValue.ofNull(), ((DataModel.Clause)((DataModel.Rule)flag.getRules().get(0)).getClauses().get(0)).getValues().get(0)));
        this.assertSegmentFromJson(this.baseBuilder("segment-key").put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("clauses", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("values", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.ofNull()})).build()})).build()})).build(), segment -> Assert.assertEquals((Object)LDValue.ofNull(), ((DataModel.Clause)((DataModel.SegmentRule)segment.getRules().get(0)).getClauses().get(0)).getValues().get(0)));
        this.assertFlagFromJson(this.baseBuilder("flagKey").put("variations", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.ofNull()})).build(), flag -> Assert.assertEquals((Object)LDValue.ofNull(), flag.getVariations().get(0)));
    }

    @Test
    public void parsingFullDataSetEmptyObject() throws Exception {
        String json = "{}";
        DataStoreTypes.FullDataSet allData = DataModelSerialization.parseFullDataSet((JsonReader)TestUtil.jsonReaderFrom(json));
        TestUtil.assertDataSetEquals(DataStoreTestTypes.DataBuilder.forStandardTypes().build(), (DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)allData);
    }

    @Test
    public void parsingFullDataSetFlagsOnly() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag1").version(1000).build();
        String json = "{\"flags\":{\"flag1\":" + JsonHelpers.serialize((Object)flag) + "}}";
        DataStoreTypes.FullDataSet allData = DataModelSerialization.parseFullDataSet((JsonReader)TestUtil.jsonReaderFrom(json));
        TestUtil.assertDataSetEquals(DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flag}).build(), (DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)allData);
    }

    @Test
    public void parsingFullDataSetSegmentsOnly() throws Exception {
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segment1").version(1000).build();
        String json = "{\"segments\":{\"segment1\":" + JsonHelpers.serialize((Object)segment) + "}}";
        DataStoreTypes.FullDataSet allData = DataModelSerialization.parseFullDataSet((JsonReader)TestUtil.jsonReaderFrom(json));
        TestUtil.assertDataSetEquals(DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{segment}).build(), (DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)allData);
    }

    @Test
    public void parsingFullDataSetFlagsAndSegments() throws Exception {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").version(1000).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("flag2").version(1001).build();
        DataModel.Segment segment1 = ModelBuilders.segmentBuilder("segment1").version(1000).build();
        DataModel.Segment segment2 = ModelBuilders.segmentBuilder("segment2").version(1001).build();
        String json = "{\"flags\":{\"flag1\":" + JsonHelpers.serialize((Object)flag1) + ",\"flag2\":" + JsonHelpers.serialize((Object)flag2) + "},\"segments\":{\"segment1\":" + JsonHelpers.serialize((Object)segment1) + ",\"segment2\":" + JsonHelpers.serialize((Object)segment2) + "}}";
        DataStoreTypes.FullDataSet allData = DataModelSerialization.parseFullDataSet((JsonReader)TestUtil.jsonReaderFrom(json));
        TestUtil.assertDataSetEquals(DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flag1, flag2}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{segment1, segment2}).build(), (DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)allData);
    }

    private void assertFlagFromJson(LDValue flagJson, Consumer<DataModel.FeatureFlag> action) {
        DataModel.FeatureFlag flag = (DataModel.FeatureFlag)DataModel.FEATURES.deserialize(flagJson.toJsonString()).getItem();
        action.accept(flag);
    }

    private void assertFlagRuleFromJson(LDValue ruleJson, Consumer<DataModel.Rule> action) {
        LDValue flagJson = LDValue.buildObject().put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{ruleJson})).build();
        this.assertFlagFromJson(flagJson, f -> action.accept((DataModel.Rule)f.getRules().get(0)));
    }

    private void assertClauseFromJson(LDValue clauseJson, Consumer<DataModel.Clause> action) {
        LDValue ruleJson = LDValue.buildObject().put("clauses", LDValue.arrayOf((LDValue[])new LDValue[]{clauseJson})).build();
        this.assertFlagRuleFromJson(ruleJson, r -> action.accept((DataModel.Clause)r.getClauses().get(0)));
    }

    private void assertSegmentFromJson(LDValue segmentJson, Consumer<DataModel.Segment> action) {
        DataModel.Segment segment = (DataModel.Segment)DataModel.SEGMENTS.deserialize(segmentJson.toJsonString()).getItem();
        action.accept(segment);
    }

    private void assertSegmentRuleFromJson(LDValue ruleJson, Consumer<DataModel.SegmentRule> action) {
        LDValue segmentJson = LDValue.buildObject().put("rules", LDValue.arrayOf((LDValue[])new LDValue[]{ruleJson})).build();
        this.assertSegmentFromJson(segmentJson, s -> action.accept((DataModel.SegmentRule)s.getRules().get(0)));
    }

    private ObjectBuilder baseBuilder(String key) {
        return LDValue.buildObject().put("key", key).put("version", 99);
    }

    private LDValue flagWithAllPropertiesJson() {
        return LDValue.buildObject().put("key", "flag-key").put("version", 99).put("on", true).put("prerequisites", LDValue.buildArray().build()).put("salt", "123").put("targets", LDValue.buildArray().add(LDValue.buildObject().put("variation", 1).put("values", LDValue.buildArray().add("key1").add("key2").build()).build()).build()).put("contextTargets", LDValue.buildArray().add(LDValue.buildObject().put("contextKind", "org").put("variation", 1).put("values", LDValue.buildArray().add("key3").add("key4").build()).build()).build()).put("rules", LDValue.arrayOf((LDValue[])new LDValue[0])).put("fallthrough", LDValue.buildObject().put("variation", 1).build()).put("offVariation", 2).put("variations", LDValue.buildArray().add("a").add("b").add("c").build()).put("clientSide", true).put("trackEvents", true).put("trackEventsFallthrough", true).put("debugEventsUntilDate", 1000).build();
    }

    private void assertFlagHasAllProperties(DataModel.FeatureFlag flag) {
        Assert.assertEquals((Object)"flag-key", (Object)flag.getKey());
        Assert.assertEquals((long)99L, (long)flag.getVersion());
        Assert.assertTrue((boolean)flag.isOn());
        Assert.assertEquals((Object)"123", (Object)flag.getSalt());
        Assert.assertNotNull((Object)flag.getTargets());
        Assert.assertEquals((long)1L, (long)flag.getTargets().size());
        DataModel.Target t0 = (DataModel.Target)flag.getTargets().get(0);
        Assert.assertNull((Object)t0.getContextKind());
        Assert.assertEquals((long)1L, (long)t0.getVariation());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key1", (Object)"key2"), (Object)t0.getValues());
        Assert.assertNotNull((Object)flag.getContextTargets());
        Assert.assertEquals((long)1L, (long)flag.getContextTargets().size());
        DataModel.Target ct0 = (DataModel.Target)flag.getContextTargets().get(0);
        Assert.assertEquals((Object)ContextKind.of((String)"org"), (Object)ct0.getContextKind());
        Assert.assertEquals((long)1L, (long)ct0.getVariation());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key3", (Object)"key4"), (Object)ct0.getValues());
        Assert.assertNotNull((Object)flag.getRules());
        Assert.assertEquals((long)0L, (long)flag.getRules().size());
        Assert.assertNotNull((Object)flag.getFallthrough());
        Assert.assertEquals((Object)1, (Object)flag.getFallthrough().getVariation());
        Assert.assertNull((Object)flag.getFallthrough().getRollout());
        Assert.assertEquals((Object)2, (Object)flag.getOffVariation());
        Assert.assertEquals((Object)ImmutableList.of((Object)LDValue.of((String)"a"), (Object)LDValue.of((String)"b"), (Object)LDValue.of((String)"c")), (Object)flag.getVariations());
        Assert.assertTrue((boolean)flag.isClientSide());
        Assert.assertTrue((boolean)flag.isTrackEvents());
        Assert.assertTrue((boolean)flag.isTrackEventsFallthrough());
        Assert.assertEquals((Object)1000L, (Object)flag.getDebugEventsUntilDate());
    }

    private LDValue segmentWithAllPropertiesJson() {
        return LDValue.buildObject().put("key", "segment-key").put("version", 99).put("included", LDValue.buildArray().add("key1").add("key2").build()).put("excluded", LDValue.buildArray().add("key3").add("key4").build()).put("includedContexts", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("contextKind", "kind1").put("values", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.of((String)"key5")})).build()})).put("excludedContexts", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.buildObject().put("contextKind", "kind2").put("values", LDValue.arrayOf((LDValue[])new LDValue[]{LDValue.of((String)"key6")})).build()})).put("salt", "123").put("rules", LDValue.arrayOf((LDValue[])new LDValue[0])).put("fallthrough", LDValue.buildObject().put("variation", 1).build()).put("variations", LDValue.buildArray().add("a").add("b").add("c").build()).build();
    }

    private void assertSegmentHasAllProperties(DataModel.Segment segment) {
        Assert.assertEquals((Object)"segment-key", (Object)segment.getKey());
        Assert.assertEquals((long)99L, (long)segment.getVersion());
        Assert.assertEquals((Object)"123", (Object)segment.getSalt());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key1", (Object)"key2"), (Object)segment.getIncluded());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key3", (Object)"key4"), (Object)segment.getExcluded());
        Assert.assertEquals((long)1L, (long)segment.getIncludedContexts().size());
        Assert.assertEquals((Object)ContextKind.of((String)"kind1"), (Object)((DataModel.SegmentTarget)segment.getIncludedContexts().get(0)).getContextKind());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key5"), (Object)((DataModel.SegmentTarget)segment.getIncludedContexts().get(0)).getValues());
        Assert.assertEquals((long)1L, (long)segment.getExcludedContexts().size());
        Assert.assertEquals((Object)ContextKind.of((String)"kind2"), (Object)((DataModel.SegmentTarget)segment.getExcludedContexts().get(0)).getContextKind());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key6"), (Object)((DataModel.SegmentTarget)segment.getExcludedContexts().get(0)).getValues());
        Assert.assertNotNull((Object)segment.getRules());
        Assert.assertEquals((long)0L, (long)segment.getRules().size());
        Assert.assertFalse((boolean)segment.isUnbounded());
        Assert.assertNull((Object)segment.getUnboundedContextKind());
        Assert.assertNull((Object)segment.getGeneration());
    }
}

