/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataSourceStatusProviderImplTest
extends BaseTest {
    private EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> broadcaster;
    private DataSourceUpdatesImpl updates;
    private DataSourceStatusProviderImpl statusProvider;

    public DataSourceStatusProviderImplTest() {
        this.broadcaster = EventBroadcasterImpl.forDataSourceStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)this.testLogger);
        this.updates = new DataSourceUpdatesImpl(TestComponents.inMemoryDataStore(), null, null, this.broadcaster, TestComponents.sharedExecutor, null, this.testLogger);
        this.statusProvider = new DataSourceStatusProviderImpl(this.broadcaster, this.updates);
    }

    @Test
    public void getStatus() throws Exception {
        MatcherAssert.assertThat((Object)this.statusProvider.getStatus().getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.INITIALIZING));
        Instant timeBefore = Instant.now();
        DataSourceStatusProvider.ErrorInfo errorInfo = DataSourceStatusProvider.ErrorInfo.fromHttpError((int)500);
        this.updates.updateStatus(DataSourceStatusProvider.State.VALID, errorInfo);
        DataSourceStatusProvider.Status newStatus = this.statusProvider.getStatus();
        MatcherAssert.assertThat((Object)newStatus.getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.VALID));
        MatcherAssert.assertThat((Object)newStatus.getStateSince(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)timeBefore));
        MatcherAssert.assertThat((Object)newStatus.getLastError(), (Matcher)Matchers.sameInstance((Object)errorInfo));
    }

    @Test
    public void statusListeners() throws Exception {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.statusProvider.addStatusListener(statuses::add);
        LinkedBlockingQueue unwantedStatuses = new LinkedBlockingQueue();
        DataSourceStatusProvider.StatusListener listener2 = unwantedStatuses::add;
        this.statusProvider.addStatusListener(listener2);
        this.statusProvider.removeStatusListener(listener2);
        this.updates.updateStatus(DataSourceStatusProvider.State.VALID, null);
        DataSourceStatusProvider.Status newStatus = (DataSourceStatusProvider.Status)ConcurrentHelpers.awaitValue(statuses, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)newStatus.getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.VALID));
        ConcurrentHelpers.assertNoMoreValues(unwantedStatuses, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void waitForStatusWithStatusAlreadyCorrect() throws Exception {
        this.updates.updateStatus(DataSourceStatusProvider.State.VALID, null);
        boolean success = this.statusProvider.waitFor(DataSourceStatusProvider.State.VALID, Duration.ofMillis(500L));
        MatcherAssert.assertThat((Object)success, (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void waitForStatusSucceeds() throws Exception {
        new Thread(() -> {
            ConcurrentHelpers.trySleep((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.updates.updateStatus(DataSourceStatusProvider.State.VALID, null);
        }).start();
        boolean success = this.statusProvider.waitFor(DataSourceStatusProvider.State.VALID, Duration.ZERO);
        MatcherAssert.assertThat((Object)success, (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void waitForStatusTimesOut() throws Exception {
        long timeStart = System.currentTimeMillis();
        boolean success = this.statusProvider.waitFor(DataSourceStatusProvider.State.VALID, Duration.ofMillis(300L));
        long timeEnd = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)success, (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)(timeEnd - timeStart), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(270L)));
    }

    @Test
    public void waitForStatusEndsIfShutDown() throws Exception {
        new Thread(() -> this.updates.updateStatus(DataSourceStatusProvider.State.OFF, null)).start();
        long timeStart = System.currentTimeMillis();
        boolean success = this.statusProvider.waitFor(DataSourceStatusProvider.State.VALID, Duration.ofMillis(500L));
        long timeEnd = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)success, (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)(timeEnd - timeStart), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(500L)));
    }
}

