/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataStoreStatusProviderImplTest
extends BaseTest {
    private EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> broadcaster;
    private MockDataStore store;
    private DataStoreUpdatesImpl updates;
    private DataStoreStatusProviderImpl statusProvider;

    public DataStoreStatusProviderImplTest() {
        this.broadcaster = EventBroadcasterImpl.forDataStoreStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)this.testLogger);
        this.store = new MockDataStore();
        this.updates = new DataStoreUpdatesImpl(this.broadcaster);
        this.statusProvider = new DataStoreStatusProviderImpl((DataStore)this.store, this.updates);
    }

    @Test
    public void getStatus() throws Exception {
        MatcherAssert.assertThat((Object)this.statusProvider.getStatus(), (Matcher)Matchers.equalTo((Object)new DataStoreStatusProvider.Status(true, false)));
        this.updates.updateStatus(new DataStoreStatusProvider.Status(false, false));
        MatcherAssert.assertThat((Object)this.statusProvider.getStatus(), (Matcher)Matchers.equalTo((Object)new DataStoreStatusProvider.Status(false, false)));
        this.updates.updateStatus(new DataStoreStatusProvider.Status(false, true));
        MatcherAssert.assertThat((Object)this.statusProvider.getStatus(), (Matcher)Matchers.equalTo((Object)new DataStoreStatusProvider.Status(false, true)));
    }

    @Test
    public void statusListeners() throws Exception {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.statusProvider.addStatusListener(statuses::add);
        LinkedBlockingQueue unwantedStatuses = new LinkedBlockingQueue();
        DataStoreStatusProvider.StatusListener listener2 = unwantedStatuses::add;
        this.statusProvider.addStatusListener(listener2);
        this.statusProvider.removeStatusListener(listener2);
        this.updates.updateStatus(new DataStoreStatusProvider.Status(false, false));
        DataStoreStatusProvider.Status newStatus = (DataStoreStatusProvider.Status)ConcurrentHelpers.awaitValue(statuses, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)newStatus, (Matcher)Matchers.equalTo((Object)new DataStoreStatusProvider.Status(false, false)));
        ConcurrentHelpers.assertNoMoreValues(unwantedStatuses, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void isStatusMonitoringEnabled() {
        MatcherAssert.assertThat((Object)this.statusProvider.isStatusMonitoringEnabled(), (Matcher)Matchers.equalTo((Object)false));
        this.store.statusMonitoringEnabled = true;
        MatcherAssert.assertThat((Object)this.statusProvider.isStatusMonitoringEnabled(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void cacheStats() {
        DataStoreStatusProvider.CacheStats stats;
        MatcherAssert.assertThat((Object)this.statusProvider.getCacheStats(), (Matcher)Matchers.nullValue());
        this.store.cacheStats = stats = new DataStoreStatusProvider.CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
        MatcherAssert.assertThat((Object)this.statusProvider.getCacheStats(), (Matcher)Matchers.equalTo((Object)stats));
    }

    private static final class MockDataStore
    implements DataStore {
        volatile boolean statusMonitoringEnabled;
        volatile DataStoreStatusProvider.CacheStats cacheStats;

        private MockDataStore() {
        }

        public void close() throws IOException {
        }

        public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        }

        public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
            return null;
        }

        public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
            return null;
        }

        public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            return false;
        }

        public boolean isInitialized() {
            return false;
        }

        public boolean isStatusMonitoringEnabled() {
            return this.statusMonitoringEnabled;
        }

        public DataStoreStatusProvider.CacheStats getCacheStats() {
            return this.cacheStats;
        }
    }
}

