/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DataStoreTestBase {
    protected DataStore store;
    protected DataStoreTestTypes.TestItem item1 = new DataStoreTestTypes.TestItem("key1", "first", 10);
    protected DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", "second", 10);
    protected DataStoreTestTypes.TestItem otherItem1 = new DataStoreTestTypes.TestItem("key1", "other-first", 11);

    protected abstract DataStore makeStore();

    @Before
    public void setup() {
        this.store = this.makeStore();
    }

    @After
    public void teardown() throws Exception {
        this.store.close();
    }

    @Test
    public void storeNotInitializedBeforeInit() {
        Assert.assertFalse((boolean)this.store.isInitialized());
    }

    @Test
    public void storeInitializedAfterInit() {
        this.store.init(new DataStoreTestTypes.DataBuilder().build());
        Assert.assertTrue((boolean)this.store.isInitialized());
    }

    @Test
    public void initCompletelyReplacesPreviousData() {
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData = new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).add(DataStoreTestTypes.OTHER_TEST_ITEMS, this.otherItem1).build();
        this.store.init(allData);
        DataStoreTestTypes.TestItem item2v2 = this.item2.withVersion(this.item2.version + 1);
        allData = new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item2v2).add(DataStoreTestTypes.OTHER_TEST_ITEMS, new DataStoreTestTypes.TestItem[0]).build();
        this.store.init(allData);
        Assert.assertNull((Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
        Assert.assertEquals((Object)item2v2.toItemDescriptor(), (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item2.key));
        Assert.assertNull((Object)this.store.get(DataStoreTestTypes.OTHER_TEST_ITEMS, this.otherItem1.key));
    }

    @Test
    public void getExistingItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        Assert.assertEquals((Object)this.item1.toItemDescriptor(), (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void getNonexistingItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        Assert.assertNull((Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, "biz"));
    }

    @Test
    public void getAll() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).add(DataStoreTestTypes.OTHER_TEST_ITEMS, this.otherItem1).build());
        Map items = DataStoreTestTypes.toItemsMap(this.store.getAll(DataStoreTestTypes.TEST_ITEMS));
        Assert.assertEquals((long)2L, (long)items.size());
        Assert.assertEquals((Object)this.item1.toItemDescriptor(), items.get(this.item1.key));
        Assert.assertEquals((Object)this.item2.toItemDescriptor(), items.get(this.item2.key));
    }

    @Test
    public void getAllWithDeletedItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTypes.ItemDescriptor deletedItem = DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.getVersion() + 1));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        Map items = DataStoreTestTypes.toItemsMap(this.store.getAll(DataStoreTestTypes.TEST_ITEMS));
        Assert.assertEquals((long)2L, (long)items.size());
        Assert.assertEquals((Object)deletedItem, items.get(this.item1.key));
        Assert.assertEquals((Object)this.item2.toItemDescriptor(), items.get(this.item2.key));
    }

    @Test
    public void upsertWithNewerVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTestTypes.TestItem newVer = this.item1.withVersion(this.item1.version + 1);
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, newVer.toItemDescriptor());
        Assert.assertEquals((Object)newVer.toItemDescriptor(), (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void upsertWithOlderVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTestTypes.TestItem oldVer = this.item1.withVersion(this.item1.version - 1);
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, oldVer.toItemDescriptor());
        Assert.assertEquals((Object)this.item1.toItemDescriptor(), (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void upsertNewItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTestTypes.TestItem newItem = new DataStoreTestTypes.TestItem("new-name", "new-key", 99);
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, newItem.key, newItem.toItemDescriptor());
        Assert.assertEquals((Object)newItem.toItemDescriptor(), (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, newItem.key));
    }

    @Test
    public void deleteWithNewerVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTypes.ItemDescriptor deletedItem = DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version + 1));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        Assert.assertEquals((Object)deletedItem, (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void deleteWithOlderVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTypes.ItemDescriptor deletedItem = DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version - 1));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        Assert.assertEquals((Object)this.item1.toItemDescriptor(), (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void deleteUnknownItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTypes.ItemDescriptor deletedItem = DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version - 1));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, "biz", deletedItem);
        Assert.assertEquals((Object)deletedItem, (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, "biz"));
    }

    @Test
    public void upsertOlderVersionAfterDelete() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).build());
        DataStoreTypes.ItemDescriptor deletedItem = DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version + 1));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, this.item1.toItemDescriptor());
        Assert.assertEquals((Object)deletedItem, (Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }
}

