/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataStoreUpdatesImplTest
extends BaseTest {
    private EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> broadcaster;
    private final DataStoreUpdatesImpl updates;

    public DataStoreUpdatesImplTest() {
        this.broadcaster = EventBroadcasterImpl.forDataStoreStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)this.testLogger);
        this.updates = new DataStoreUpdatesImpl(this.broadcaster);
    }

    @Test
    public void updateStatusBroadcastsNewStatus() {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.broadcaster.register(statuses::add);
        this.updates.updateStatus(new DataStoreStatusProvider.Status(false, false));
        DataStoreStatusProvider.Status newStatus = (DataStoreStatusProvider.Status)ConcurrentHelpers.awaitValue(statuses, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)newStatus, (Matcher)Matchers.equalTo((Object)new DataStoreStatusProvider.Status(false, false)));
        ConcurrentHelpers.assertNoMoreValues(statuses, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void updateStatusDoesNothingIfNewStatusIsSame() {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.broadcaster.register(statuses::add);
        this.updates.updateStatus(new DataStoreStatusProvider.Status(true, false));
        ConcurrentHelpers.assertNoMoreValues(statuses, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void updateStatusDoesNothingIfNewStatusIsNull() {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.broadcaster.register(statuses::add);
        this.updates.updateStatus(null);
        ConcurrentHelpers.assertNoMoreValues(statuses, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

