/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.internal.http.HttpErrors;
import com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.DefaultFeatureRequestor;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import com.launchdarkly.testhelpers.httptest.Handler;
import com.launchdarkly.testhelpers.httptest.Handlers;
import com.launchdarkly.testhelpers.httptest.HttpServer;
import com.launchdarkly.testhelpers.httptest.RequestInfo;
import com.launchdarkly.testhelpers.httptest.SpecialHttpConfigurations;
import java.net.URI;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFeatureRequestorTest
extends BaseTest {
    private static final String sdkKey = "sdk-key";
    private static final String flag1Key = "flag1";
    private static final DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").version(1000).build();
    private static final String flag1Json = JsonHelpers.serialize((Object)flag1);
    private static final String flagsJson = "{\"flag1\":" + flag1Json + "}";
    private static final String segment1Key = "segment1";
    private static final DataModel.Segment segment1 = ModelBuilders.segmentBuilder("segment1").version(2000).build();
    private static final String segment1Json = JsonHelpers.serialize((Object)segment1);
    private static final String segmentsJson = "{\"segment1\":" + segment1Json + "}";
    private static final String allDataJson = "{\"flags\":" + flagsJson + ",\"segments\":" + segmentsJson + "}";

    private DefaultFeatureRequestor makeRequestor(HttpServer server) {
        return this.makeRequestor(server, LDConfig.DEFAULT);
    }

    private DefaultFeatureRequestor makeRequestor(HttpServer server, LDConfig config) {
        return new DefaultFeatureRequestor(this.makeHttpConfig(config), server.getUri(), this.testLogger);
    }

    private HttpProperties makeHttpConfig(LDConfig config) {
        return ComponentsImpl.toHttpProperties((HttpConfiguration)((HttpConfiguration)config.http.build(new ClientContext(sdkKey))));
    }

    private void verifyExpectedData(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data) {
        Assert.assertNotNull(data);
        TestUtil.assertDataSetEquals(DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flag1}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{segment1}).build(), data);
    }

    @Test
    public void requestAllData() throws Exception {
        Handler resp = Handlers.bodyJson((String)allDataJson);
        try (HttpServer server = HttpServer.start((Handler)resp);
             DefaultFeatureRequestor r = this.makeRequestor(server);){
            DataStoreTypes.FullDataSet data = r.getAllData(true);
            RequestInfo req = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/sdk/latest-all", (Object)req.getPath());
            this.verifyHeaders(req);
            this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data);
        }
    }

    @Test
    public void responseIsCached() throws Exception {
        Handler cacheableResp = Handlers.all((Handler[])new Handler[]{Handlers.header((String)"ETag", (String)"aaa"), Handlers.header((String)"Cache-Control", (String)"max-age=0"), Handlers.bodyJson((String)allDataJson)});
        Handler cachedResp = Handlers.status((int)304);
        Handler cacheableThenCached = Handlers.sequential((Handler[])new Handler[]{cacheableResp, cachedResp});
        try (HttpServer server = HttpServer.start((Handler)cacheableThenCached);
             DefaultFeatureRequestor r = this.makeRequestor(server);){
            DataStoreTypes.FullDataSet data1 = r.getAllData(true);
            this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data1);
            RequestInfo req1 = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/sdk/latest-all", (Object)req1.getPath());
            this.verifyHeaders(req1);
            Assert.assertNull((Object)req1.getHeader("If-None-Match"));
            DataStoreTypes.FullDataSet data2 = r.getAllData(false);
            Assert.assertNull((Object)data2);
            RequestInfo req2 = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/sdk/latest-all", (Object)req2.getPath());
            this.verifyHeaders(req2);
            Assert.assertEquals((Object)"aaa", (Object)req2.getHeader("If-None-Match"));
        }
    }

    @Test
    public void responseIsCachedButWeWantDataAnyway() throws Exception {
        Handler cacheableResp = Handlers.all((Handler[])new Handler[]{Handlers.header((String)"ETag", (String)"aaa"), Handlers.header((String)"Cache-Control", (String)"max-age=0"), Handlers.bodyJson((String)allDataJson)});
        Handler cachedResp = Handlers.status((int)304);
        Handler cacheableThenCached = Handlers.sequential((Handler[])new Handler[]{cacheableResp, cachedResp});
        try (HttpServer server = HttpServer.start((Handler)cacheableThenCached);
             DefaultFeatureRequestor r = this.makeRequestor(server);){
            DataStoreTypes.FullDataSet data1 = r.getAllData(true);
            this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data1);
            RequestInfo req1 = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/sdk/latest-all", (Object)req1.getPath());
            this.verifyHeaders(req1);
            Assert.assertNull((Object)req1.getHeader("If-None-Match"));
            DataStoreTypes.FullDataSet data2 = r.getAllData(true);
            this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data2);
            RequestInfo req2 = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/sdk/latest-all", (Object)req2.getPath());
            this.verifyHeaders(req2);
            Assert.assertEquals((Object)"aaa", (Object)req2.getHeader("If-None-Match"));
        }
    }

    @Test
    public void testSpecialHttpConfigurations() throws Exception {
        Handler handler = Handlers.bodyJson((String)allDataJson);
        SpecialHttpConfigurations.testAll((Handler)handler, (serverUri, params) -> {
            boolean bl;
            LDConfig config = new LDConfig.Builder().http((ComponentConfigurer)TestUtil.makeHttpConfigurationFromTestParams(params)).build();
            DefaultFeatureRequestor r = new DefaultFeatureRequestor(this.makeHttpConfig(config), serverUri, this.testLogger);
            try {
                DataStoreTypes.FullDataSet data = r.getAllData(false);
                this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SerializationException e) {
                    throw new SpecialHttpConfigurations.UnexpectedResponseException(e.toString());
                }
                catch (HttpErrors.HttpErrorException e) {
                    throw new SpecialHttpConfigurations.UnexpectedResponseException(e.toString());
                }
            }
            r.close();
            return bl;
        });
    }

    @Test
    public void baseUriDoesNotNeedTrailingSlash() throws Exception {
        Handler resp = Handlers.bodyJson((String)allDataJson);
        try (HttpServer server = HttpServer.start((Handler)resp);
             DefaultFeatureRequestor r = new DefaultFeatureRequestor(this.makeHttpConfig(LDConfig.DEFAULT), server.getUri(), this.testLogger);){
            DataStoreTypes.FullDataSet data = r.getAllData(true);
            RequestInfo req = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/sdk/latest-all", (Object)req.getPath());
            this.verifyHeaders(req);
            this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data);
        }
    }

    @Test
    public void baseUriCanHaveContextPath() throws Exception {
        Handler resp = Handlers.bodyJson((String)allDataJson);
        try (HttpServer server = HttpServer.start((Handler)resp);){
            URI uri = server.getUri().resolve("/context/path");
            try (DefaultFeatureRequestor r = new DefaultFeatureRequestor(this.makeHttpConfig(LDConfig.DEFAULT), uri, this.testLogger);){
                DataStoreTypes.FullDataSet data = r.getAllData(true);
                RequestInfo req = server.getRecorder().requireRequest();
                Assert.assertEquals((Object)"/context/path/sdk/latest-all", (Object)req.getPath());
                this.verifyHeaders(req);
                this.verifyExpectedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data);
            }
        }
    }

    private void verifyHeaders(RequestInfo req) {
        HttpConfiguration httpConfig = TestComponents.clientContext(sdkKey, LDConfig.DEFAULT).getHttp();
        for (Map.Entry kv : httpConfig.getDefaultHeaders()) {
            MatcherAssert.assertThat((Object)req.getHeader((String)kv.getKey()), (Matcher)Matchers.equalTo((Object)((String)kv.getValue())));
        }
    }
}

