/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.EvalResult;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class EvalResultTest {
    private static final LDValue SOME_VALUE = LDValue.of((String)"value");
    private static final LDValue ARRAY_VALUE = LDValue.arrayOf((LDValue[])new LDValue[0]);
    private static final LDValue OBJECT_VALUE = LDValue.buildObject().build();
    private static final int SOME_VARIATION = 11;
    private static final EvaluationReason SOME_REASON = EvaluationReason.fallthrough();

    @Test
    public void getValue() {
        MatcherAssert.assertThat((Object)EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON)).getValue(), (Matcher)Matchers.equalTo((Object)SOME_VALUE));
        MatcherAssert.assertThat((Object)EvalResult.of((LDValue)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON).getValue(), (Matcher)Matchers.equalTo((Object)SOME_VALUE));
    }

    @Test
    public void getVariationIndex() {
        MatcherAssert.assertThat((Object)EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON)).getVariationIndex(), (Matcher)Matchers.equalTo((Object)11));
        MatcherAssert.assertThat((Object)EvalResult.of((LDValue)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON).getVariationIndex(), (Matcher)Matchers.equalTo((Object)11));
    }

    @Test
    public void getReason() {
        MatcherAssert.assertThat((Object)EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON)).getReason(), (Matcher)Matchers.equalTo((Object)SOME_REASON));
        MatcherAssert.assertThat((Object)EvalResult.of((LDValue)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON).getReason(), (Matcher)Matchers.equalTo((Object)SOME_REASON));
    }

    @Test
    public void isNoVariation() {
        MatcherAssert.assertThat((Object)EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON)).isNoVariation(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)EvalResult.of((LDValue)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON).isNoVariation(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)SOME_VALUE, (int)-1, (EvaluationReason)SOME_REASON)).isNoVariation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)EvalResult.of((LDValue)SOME_VALUE, (int)-1, (EvaluationReason)SOME_REASON).isNoVariation(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getAnyType() {
        this.testForType(SOME_VALUE, SOME_VALUE, r -> r.getAnyType());
    }

    @Test
    public void getAsBoolean() {
        this.testForType(true, LDValue.of((boolean)true), r -> r.getAsBoolean());
        this.testWrongType(false, LDValue.ofNull(), r -> r.getAsBoolean());
        this.testWrongType(false, LDValue.of((int)1), r -> r.getAsBoolean());
        this.testWrongType(false, LDValue.of((String)"a"), r -> r.getAsBoolean());
        this.testWrongType(false, ARRAY_VALUE, r -> r.getAsBoolean());
        this.testWrongType(false, OBJECT_VALUE, r -> r.getAsBoolean());
    }

    @Test
    public void getAsInteger() {
        this.testForType(99, LDValue.of((int)99), r -> r.getAsInteger());
        this.testForType(99, LDValue.of((double)99.25), r -> r.getAsInteger());
        this.testWrongType(0, LDValue.ofNull(), r -> r.getAsInteger());
        this.testWrongType(0, LDValue.of((boolean)true), r -> r.getAsInteger());
        this.testWrongType(0, LDValue.of((String)"a"), r -> r.getAsInteger());
        this.testWrongType(0, ARRAY_VALUE, r -> r.getAsInteger());
        this.testWrongType(0, OBJECT_VALUE, r -> r.getAsInteger());
    }

    @Test
    public void getAsDouble() {
        this.testForType(99.0, LDValue.of((int)99), r -> r.getAsDouble());
        this.testForType(99.25, LDValue.of((double)99.25), r -> r.getAsDouble());
        this.testWrongType(0.0, LDValue.ofNull(), r -> r.getAsDouble());
        this.testWrongType(0.0, LDValue.of((boolean)true), r -> r.getAsDouble());
        this.testWrongType(0.0, LDValue.of((String)"a"), r -> r.getAsDouble());
        this.testWrongType(0.0, ARRAY_VALUE, r -> r.getAsDouble());
        this.testWrongType(0.0, OBJECT_VALUE, r -> r.getAsDouble());
    }

    @Test
    public void getAsString() {
        this.testForType("a", LDValue.of((String)"a"), r -> r.getAsString());
        this.testForType(null, LDValue.ofNull(), r -> r.getAsString());
        this.testWrongType(null, LDValue.of((boolean)true), r -> r.getAsString());
        this.testWrongType(null, LDValue.of((int)1), r -> r.getAsString());
        this.testWrongType(null, ARRAY_VALUE, r -> r.getAsString());
        this.testWrongType(null, OBJECT_VALUE, r -> r.getAsString());
    }

    @Test
    public void withReason() {
        EvalResult r = EvalResult.of((LDValue)LDValue.of((boolean)true), (int)11, (EvaluationReason)EvaluationReason.fallthrough());
        EvalResult r1 = r.withReason(EvaluationReason.off());
        MatcherAssert.assertThat((Object)r1.getReason(), (Matcher)Matchers.equalTo((Object)EvaluationReason.off()));
        MatcherAssert.assertThat((Object)r1.getValue(), (Matcher)Matchers.equalTo((Object)r.getValue()));
        MatcherAssert.assertThat((Object)r1.getVariationIndex(), (Matcher)Matchers.equalTo((Object)r.getVariationIndex()));
    }

    @Test
    public void withForceReasonTracking() {
        EvalResult r = EvalResult.of((LDValue)SOME_VALUE, (int)11, (EvaluationReason)SOME_REASON);
        MatcherAssert.assertThat((Object)r.isForceReasonTracking(), (Matcher)Matchers.is((Object)false));
        EvalResult r0 = r.withForceReasonTracking(false);
        MatcherAssert.assertThat((Object)r0, (Matcher)Matchers.sameInstance((Object)r));
        EvalResult r1 = r.withForceReasonTracking(true);
        MatcherAssert.assertThat((Object)r1.isForceReasonTracking(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)r1.getAnyType(), (Matcher)Matchers.sameInstance((Object)r.getAnyType()));
    }

    private <T> void testForType(T value, LDValue ldValue, Function<EvalResult, T> getter) {
        MatcherAssert.assertThat(getter.apply(EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)ldValue, (int)11, (EvaluationReason)SOME_REASON))), (Matcher)Matchers.equalTo((Object)EvaluationDetail.fromValue(value, (int)11, (EvaluationReason)SOME_REASON)));
        MatcherAssert.assertThat(getter.apply(EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)ldValue, (int)11, (EvaluationReason)SOME_REASON))), (Matcher)Matchers.equalTo((Object)EvaluationDetail.fromValue(value, (int)11, (EvaluationReason)SOME_REASON)));
    }

    private <T> void testWrongType(T value, LDValue ldValue, Function<EvalResult, T> getter) {
        MatcherAssert.assertThat(getter.apply(EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)ldValue, (int)11, (EvaluationReason)SOME_REASON))), (Matcher)Matchers.equalTo((Object)EvaluationDetail.fromValue(value, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE))));
        MatcherAssert.assertThat(getter.apply(EvalResult.of((EvaluationDetail)EvaluationDetail.fromValue((Object)ldValue, (int)11, (EvaluationReason)SOME_REASON))), (Matcher)Matchers.equalTo((Object)EvaluationDetail.fromValue(value, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE))));
    }
}

