/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EvaluatorTestBase;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorBigSegmentTest
extends EvaluatorTestBase {
    private static final LDContext testUser = LDContext.create((String)"userkey");

    @Test
    public void bigSegmentWithNoProviderIsNotMatched() {
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).generation(1).included(testUser.getKey()).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("key", ModelBuilders.clauseMatchingSegment(segment));
        Evaluator evaluator = this.evaluatorBuilder().withStoredSegments(segment).withBigSegmentQueryResult(testUser.getKey(), null).build();
        EvalResult result = evaluator.evaluate(flag, testUser, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)false), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED, (Object)result.getReason().getBigSegmentsStatus());
    }

    @Test
    public void bigSegmentWithNoGenerationIsNotMatched() {
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("key", ModelBuilders.clauseMatchingSegment(segment));
        Evaluator evaluator = this.evaluatorBuilder().withStoredSegments(segment).build();
        EvalResult result = evaluator.evaluate(flag, testUser, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)false), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED, (Object)result.getReason().getBigSegmentsStatus());
    }

    @Test
    public void matchedWithIncludeForDefaultKind() {
        this.testMatchedWithInclude(false, false);
        this.testMatchedWithInclude(false, true);
    }

    @Test
    public void matchedWithIncludeForNonDefaultKind() {
        this.testMatchedWithInclude(true, false);
        this.testMatchedWithInclude(true, true);
    }

    private void testMatchedWithInclude(boolean nonDefaultKind, boolean multiKindContext) {
        String targetKey = "contextkey";
        ContextKind kind1 = ContextKind.of((String)"kind1");
        LDContext singleKindContext = nonDefaultKind ? LDContext.create((ContextKind)kind1, (String)targetKey) : LDContext.create((String)targetKey);
        LDContext evalContext = multiKindContext ? LDContext.createMulti((LDContext[])new LDContext[]{singleKindContext, LDContext.create((ContextKind)ContextKind.of((String)"kind2"), (String)"key2")}) : singleKindContext;
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).unboundedContextKind((ContextKind)(nonDefaultKind ? kind1 : null)).generation(2).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flagkey", ModelBuilders.clauseMatchingSegment(segment));
        BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult = new BigSegmentStoreWrapper.BigSegmentsQueryResult();
        queryResult.status = EvaluationReason.BigSegmentsStatus.HEALTHY;
        queryResult.membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList(Evaluator.makeBigSegmentRef((DataModel.Segment)segment)), null);
        Evaluator evaluator = this.evaluatorBuilder().withStoredSegments(segment).withBigSegmentQueryResult(targetKey, queryResult).build();
        EvalResult result = evaluator.evaluate(flag, evalContext, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)true), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)result.getReason().getBigSegmentsStatus());
    }

    @Test
    public void matchedWithRule() {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(testUser);
        DataModel.SegmentRule segmentRule = ModelBuilders.segmentRuleBuilder().clauses(clause).build();
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).generation(2).rules(segmentRule).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("key", ModelBuilders.clauseMatchingSegment(segment));
        BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult = new BigSegmentStoreWrapper.BigSegmentsQueryResult();
        queryResult.status = EvaluationReason.BigSegmentsStatus.HEALTHY;
        queryResult.membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null);
        Evaluator evaluator = this.evaluatorBuilder().withStoredSegments(segment).withBigSegmentQueryResult(testUser.getKey(), queryResult).build();
        EvalResult result = evaluator.evaluate(flag, testUser, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)true), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)result.getReason().getBigSegmentsStatus());
    }

    @Test
    public void unmatchedByExcludeRegardlessOfRule() {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(testUser);
        DataModel.SegmentRule segmentRule = ModelBuilders.segmentRuleBuilder().clauses(clause).build();
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).generation(2).rules(segmentRule).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("key", ModelBuilders.clauseMatchingSegment(segment));
        BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult = new BigSegmentStoreWrapper.BigSegmentsQueryResult();
        queryResult.status = EvaluationReason.BigSegmentsStatus.HEALTHY;
        queryResult.membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Arrays.asList(Evaluator.makeBigSegmentRef((DataModel.Segment)segment)));
        Evaluator evaluator = this.evaluatorBuilder().withStoredSegments(segment).withBigSegmentQueryResult(testUser.getKey(), queryResult).build();
        EvalResult result = evaluator.evaluate(flag, testUser, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)false), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)result.getReason().getBigSegmentsStatus());
    }

    @Test
    public void bigSegmentStatusIsReturnedFromProvider() {
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).generation(2).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("key", ModelBuilders.clauseMatchingSegment(segment));
        BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult = new BigSegmentStoreWrapper.BigSegmentsQueryResult();
        queryResult.status = EvaluationReason.BigSegmentsStatus.STALE;
        queryResult.membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList(Evaluator.makeBigSegmentRef((DataModel.Segment)segment)), null);
        Evaluator evaluator = this.evaluatorBuilder().withStoredSegments(segment).withBigSegmentQueryResult(testUser.getKey(), queryResult).build();
        EvalResult result = evaluator.evaluate(flag, testUser, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)true), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.STALE, (Object)result.getReason().getBigSegmentsStatus());
    }

    @Test
    public void bigSegmentStateIsQueriedOnlyOncePerKeyEvenIfFlagReferencesMultipleSegments() {
        ContextKind kind1 = ContextKind.of((String)"kind1");
        ContextKind kind2 = ContextKind.of((String)"kind2");
        ContextKind kind3 = ContextKind.of((String)"kind3");
        String key1 = "contextkey1";
        String key2 = "contextkey2";
        LDContext context = LDContext.createMulti((LDContext[])new LDContext[]{LDContext.create((ContextKind)kind1, (String)key1), LDContext.create((ContextKind)kind2, (String)key2), LDContext.create((ContextKind)kind3, (String)key2)});
        DataModel.Segment segment1 = ModelBuilders.segmentBuilder("segmentkey1").unbounded(true).unboundedContextKind(kind1).generation(2).build();
        DataModel.Segment segment2 = ModelBuilders.segmentBuilder("segmentkey2").unbounded(true).unboundedContextKind(kind2).generation(3).build();
        DataModel.Segment segment3 = ModelBuilders.segmentBuilder("segmentkey3").unbounded(true).unboundedContextKind(kind3).generation(4).build();
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("key").on(true).fallthroughVariation(0).variations(false, true).rules(ModelBuilders.ruleBuilder().variation(1).clauses(ModelBuilders.clauseMatchingSegment(segment1)).build(), ModelBuilders.ruleBuilder().variation(1).clauses(ModelBuilders.clauseMatchingSegment(segment2)).build(), ModelBuilders.ruleBuilder().variation(1).clauses(ModelBuilders.clauseMatchingSegment(segment3)).build()).build();
        BigSegmentStoreWrapper.BigSegmentsQueryResult queryResultForKey2 = new BigSegmentStoreWrapper.BigSegmentsQueryResult();
        queryResultForKey2.status = EvaluationReason.BigSegmentsStatus.HEALTHY;
        queryResultForKey2.membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList(Evaluator.makeBigSegmentRef((DataModel.Segment)segment3)), null);
        Evaluator.Getters mockGetters = (Evaluator.Getters)EasyMock.strictMock(Evaluator.Getters.class);
        EasyMock.expect((Object)mockGetters.getSegment(segment1.getKey())).andReturn((Object)segment1);
        EasyMock.expect((Object)mockGetters.getBigSegments(key1)).andReturn(null).times(1);
        EasyMock.expect((Object)mockGetters.getSegment(segment2.getKey())).andReturn((Object)segment2);
        EasyMock.expect((Object)mockGetters.getBigSegments(key2)).andReturn((Object)queryResultForKey2).times(1);
        EasyMock.expect((Object)mockGetters.getSegment(segment3.getKey())).andReturn((Object)segment3);
        EasyMock.replay((Object[])new Object[]{mockGetters});
        Evaluator evaluator = new Evaluator(mockGetters, this.testLogger);
        EvalResult result = evaluator.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((boolean)true), (Object)result.getValue());
        Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)result.getReason().getBigSegmentsStatus());
    }
}

