/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorBucketingTest {
    private Integer noSeed = null;

    @Test
    public void variationIndexIsReturnedForBucket() {
        LDContext context = LDContext.create((String)"userkey");
        String flagKey = "flagkey";
        String salt = "salt";
        int bucketValue = (int)(EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)flagKey, null, (String)salt) * 100000.0f);
        MatcherAssert.assertThat((Object)bucketValue, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((Object)bucketValue, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(100000)));
        int badVariationA = 0;
        int matchedVariation = 1;
        int badVariationB = 2;
        List<DataModel.WeightedVariation> variations = Arrays.asList(new DataModel.WeightedVariation(badVariationA, bucketValue, true), new DataModel.WeightedVariation(matchedVariation, 1, true), new DataModel.WeightedVariation(badVariationB, 100000 - (bucketValue + 1), true));
        DataModel.Rollout rollout = new DataModel.Rollout(null, variations, null, DataModel.RolloutKind.rollout, null);
        EvaluatorBucketingTest.assertVariationIndexFromRollout(matchedVariation, rollout, context, flagKey, salt);
    }

    @Test
    public void usingSeedIsDifferentThanSalt() {
        LDContext context = LDContext.create((String)"userkey");
        String flagKey = "flagkey";
        String salt = "salt";
        Integer seed = 123;
        float bucketValue1 = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)flagKey, null, (String)salt);
        float bucketValue2 = EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed, (LDContext)context, null, (String)flagKey, null, (String)salt);
        assert (bucketValue1 != bucketValue2);
    }

    @Test
    public void differentSeedsProduceDifferentAssignment() {
        LDContext context = LDContext.create((String)"userkey");
        String flagKey = "flagkey";
        String salt = "salt";
        Integer seed1 = 123;
        Integer seed2 = 456;
        float bucketValue1 = EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed1, (LDContext)context, null, (String)flagKey, null, (String)salt);
        float bucketValue2 = EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed2, (LDContext)context, null, (String)flagKey, null, (String)salt);
        assert (bucketValue1 != bucketValue2);
    }

    @Test
    public void flagKeyAndSaltDoNotMatterWhenSeedIsUsed() {
        LDContext context = LDContext.create((String)"userkey");
        String flagKey1 = "flagkey";
        String flagKey2 = "flagkey2";
        String salt1 = "salt";
        String salt2 = "salt2";
        Integer seed = 123;
        float bucketValue1 = EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed, (LDContext)context, null, (String)flagKey1, null, (String)salt1);
        float bucketValue2 = EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed, (LDContext)context, null, (String)flagKey2, null, (String)salt2);
        assert (bucketValue1 == bucketValue2);
    }

    @Test
    public void lastBucketIsUsedIfBucketValueEqualsTotalWeight() {
        LDContext context = LDContext.create((String)"userkey");
        String flagKey = "flagkey";
        String salt = "salt";
        int bucketValue = (int)(EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)flagKey, null, (String)salt) * 100000.0f);
        List<DataModel.WeightedVariation> variations = Arrays.asList(new DataModel.WeightedVariation(0, bucketValue, true));
        DataModel.Rollout rollout = new DataModel.Rollout(null, variations, null, DataModel.RolloutKind.rollout, null);
        EvaluatorBucketingTest.assertVariationIndexFromRollout(0, rollout, context, flagKey, salt);
    }

    @Test
    public void canBucketByIntAttributeSameAsString() {
        LDContext context = LDContext.builder((String)"key").set("stringattr", "33333").set("intattr", 33333).build();
        float resultForString = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)"key", (AttributeRef)AttributeRef.fromLiteral((String)"stringattr"), (String)"salt");
        float resultForInt = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)"key", (AttributeRef)AttributeRef.fromLiteral((String)"intattr"), (String)"salt");
        Assert.assertEquals((float)resultForString, (float)resultForInt, (float)Float.MIN_VALUE);
    }

    @Test
    public void cannotBucketByFloatAttribute() {
        LDContext context = LDContext.builder((String)"key").set("floatattr", 33.5).build();
        float result = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)"key", (AttributeRef)AttributeRef.fromLiteral((String)"floatattr"), (String)"salt");
        Assert.assertEquals((float)0.0f, (float)result, (float)Float.MIN_VALUE);
    }

    @Test
    public void cannotBucketByBooleanAttribute() {
        LDContext context = LDContext.builder((String)"key").set("boolattr", true).build();
        float result = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)context, null, (String)"key", (AttributeRef)AttributeRef.fromLiteral((String)"boolattr"), (String)"salt");
        Assert.assertEquals((float)0.0f, (float)result, (float)Float.MIN_VALUE);
    }

    private static void assertVariationIndexFromRollout(int expectedVariation, DataModel.Rollout rollout, LDContext context, String flagKey, String salt) {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder(flagKey).on(true).generatedVariations(3).fallthrough(rollout).salt(salt).build();
        EvalResult result1 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(flag1, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        MatcherAssert.assertThat((Object)result1.getReason(), (Matcher)Matchers.equalTo((Object)EvaluationReason.fallthrough()));
        MatcherAssert.assertThat((Object)result1.getVariationIndex(), (Matcher)Matchers.equalTo((Object)expectedVariation));
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder(flagKey).on(true).generatedVariations(3).rules(ModelBuilders.ruleBuilder().rollout(rollout).clauses(ModelBuilders.clauseMatchingContext(context)).build()).salt(salt).build();
        EvalResult result2 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(flag2, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        MatcherAssert.assertThat((Object)result2.getReason().getKind(), (Matcher)Matchers.equalTo((Object)EvaluationReason.Kind.RULE_MATCH));
        MatcherAssert.assertThat((Object)result2.getVariationIndex(), (Matcher)Matchers.equalTo((Object)expectedVariation));
    }
}

