/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EvaluatorTestBase;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.testhelpers.JsonAssertions;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorClauseTest
extends EvaluatorTestBase {
    private static void assertMatch(Evaluator eval, DataModel.FeatureFlag flag, LDContext context, boolean expectMatch) {
        Assert.assertEquals((Object)LDValue.of((boolean)expectMatch), (Object)eval.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals()).getValue());
    }

    private static DataModel.Segment makeSegmentThatMatchesUser(String segmentKey, String userKey) {
        return ModelBuilders.segmentBuilder(segmentKey).included(userKey).build();
    }

    @Test
    public void clauseCanMatchBuiltInAttribute() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("name", DataModel.Operator.in, LDValue.of((String)"Bob"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").name("Bob").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseCanMatchCustomAttribute() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("legs", DataModel.Operator.in, LDValue.of((int)4));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("legs", 4).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseReturnsFalseForMissingAttribute() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("legs", DataModel.Operator.in, LDValue.of((int)4));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").name("Bob").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void clauseMatchesContextValueToAnyOfMultipleValues() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("name", DataModel.Operator.in, LDValue.of((String)"Bob"), LDValue.of((String)"Carol"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").name("Carol").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseMatchesContextValueToAnyOfMultipleValuesWithNonEqualityOperator() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("name", DataModel.Operator.contains, LDValue.of((String)"Bob"), LDValue.of((String)"Carol"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").name("Caroline").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseMatchesArrayOfContextValuesToClauseValue() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("alias", DataModel.Operator.in, LDValue.of((String)"Maurice"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("alias", LDValue.buildArray().add("Space Cowboy").add("Maurice").build()).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseFindsNoMatchInArrayOfContextValues() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("alias", DataModel.Operator.in, LDValue.of((String)"Ma"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("alias", LDValue.buildArray().add("Mary").add("May").build()).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void matchFailsIfContextValueIsAnArrayOfArrays() throws Exception {
        LDValue arrayValue = LDValue.buildArray().add("thing").build();
        LDValue arrayOfArrays = LDValue.buildArray().add(arrayValue).build();
        DataModel.Clause clause = ModelBuilders.clause("data", DataModel.Operator.in, arrayOfArrays);
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("data", arrayOfArrays).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void matchFailsIfContextValueIsAnObject() throws Exception {
        LDValue objectValue = LDValue.buildObject().put("thing", LDValue.of((boolean)true)).build();
        DataModel.Clause clause = ModelBuilders.clause("data", DataModel.Operator.in, objectValue);
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("data", objectValue).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void matchFailsIfContextValueIsAnArrayOfObjects() throws Exception {
        LDValue objectValue = LDValue.buildObject().put("thing", LDValue.of((boolean)true)).build();
        LDValue arrayOfObjects = LDValue.buildArray().add(objectValue).build();
        DataModel.Clause clause = ModelBuilders.clause("data", DataModel.Operator.in, arrayOfObjects);
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("data", arrayOfObjects).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void clauseReturnsFalseForNullOperator() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause("key", null, LDValue.of((String)"key"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.create((String)"key");
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void clauseCanBeNegatedToReturnFalse() throws Exception {
        DataModel.Clause clause = ModelBuilders.negateClause(ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"key")));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").name("Bob").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void clauseCanBeNegatedToReturnTrue() throws Exception {
        DataModel.Clause clause = ModelBuilders.negateClause(ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"other")));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").name("Bob").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseWithUnsupportedOperatorStringIsUnmarshalledWithNullOperator() throws Exception {
        String badClauseJson = "{\"attribute\":\"name\",\"operator\":\"doesSomethingUnsupported\",\"values\":[\"x\"]}";
        DataModel.Clause clause = (DataModel.Clause)TestUtil.TEST_GSON_INSTANCE.fromJson(badClauseJson, DataModel.Clause.class);
        Assert.assertNotNull((Object)clause);
        String json = TestUtil.TEST_GSON_INSTANCE.toJson((Object)clause);
        String expectedJson = "{\"attribute\":\"name\",\"values\":[\"x\"],\"negate\":false}";
        JsonAssertions.assertJsonEquals((String)expectedJson, (String)json);
    }

    @Test
    public void clauseWithNullOperatorDoesNotMatch() throws Exception {
        DataModel.Clause badClause = ModelBuilders.clause("name", null, LDValue.of((String)"Bob"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", badClause);
        LDContext context = LDContext.builder((String)"key").name("Bob").build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, false);
    }

    @Test
    public void clauseWithNullOperatorDoesNotStopSubsequentRuleFromMatching() throws Exception {
        DataModel.Clause badClause = ModelBuilders.clause("name", null, LDValue.of((String)"Bob"));
        DataModel.Rule badRule = ModelBuilders.ruleBuilder().id("rule1").clauses(badClause).variation(1).build();
        DataModel.Clause goodClause = ModelBuilders.clause("name", DataModel.Operator.in, LDValue.of((String)"Bob"));
        DataModel.Rule goodRule = ModelBuilders.ruleBuilder().id("rule2").clauses(goodClause).variation(1).build();
        DataModel.FeatureFlag f = ModelBuilders.flagBuilder("feature").on(true).rules(badRule, goodRule).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(0).variations(LDValue.of((boolean)false), LDValue.of((boolean)true)).build();
        LDContext context = LDContext.builder((String)"key").name("Bob").build();
        EvaluationDetail details = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, context, EvaluatorTestUtil.expectNoPrerequisiteEvals()).getAnyType();
        Assert.assertEquals((Object)EvaluationDetail.fromValue((Object)LDValue.of((boolean)true), (int)1, (EvaluationReason)EvaluationReason.ruleMatch((int)1, (String)"rule2")), (Object)details);
    }

    @Test
    public void clauseCanGetValueWithAttributeReference() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause(null, AttributeRef.fromPath((String)"/address/city"), DataModel.Operator.in, LDValue.of((String)"Oakland"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.builder((String)"key").set("address", LDValue.parse((String)"{\"city\":\"Oakland\",\"state\":\"CA\"}")).build();
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context, true);
    }

    @Test
    public void clauseMatchUsesContextKind() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause(ContextKind.of((String)"company"), "name", DataModel.Operator.in, LDValue.of((String)"Catco"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context1 = LDContext.builder((String)"cc").kind("company").name("Catco").build();
        LDContext context2 = LDContext.builder((String)"l").name("Lucy").build();
        LDContext context3 = LDContext.createMulti((LDContext[])new LDContext[]{context1, context2});
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context1, true);
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context2, false);
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context3, true);
    }

    @Test
    public void clauseMatchByKindAttribute() throws Exception {
        DataModel.Clause clause = ModelBuilders.clause(null, "kind", DataModel.Operator.startsWith, LDValue.of((String)"a"));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context1 = LDContext.create((String)"key");
        LDContext context2 = LDContext.create((ContextKind)ContextKind.of((String)"ab"), (String)"key");
        LDContext context3 = LDContext.createMulti((LDContext[])new LDContext[]{LDContext.create((ContextKind)ContextKind.of((String)"cd"), (String)"key"), LDContext.create((ContextKind)ContextKind.of((String)"ab"), (String)"key")});
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context1, false);
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context2, true);
        EvaluatorClauseTest.assertMatch(EvaluatorTestUtil.BASE_EVALUATOR, f, context3, true);
    }

    @Test
    public void clauseReturnsMalformedFlagErrorForAttributeNotSpecified() {
        DataModel.Clause clause = ModelBuilders.clause(null, (AttributeRef)null, DataModel.Operator.in, LDValue.of((int)4));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.create((String)"key");
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void clauseReturnsMalformedFlagErrorForMalformedAttributeReference() {
        DataModel.Clause clause = ModelBuilders.clause(null, AttributeRef.fromPath((String)"///"), DataModel.Operator.in, LDValue.of((int)4));
        DataModel.FeatureFlag f = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.create((String)"key");
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void testSegmentMatchClauseRetrievesSegmentFromStore() throws Exception {
        String segmentKey = "segkey";
        DataModel.Clause clause = ModelBuilders.clauseMatchingSegment(segmentKey);
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flag", clause);
        DataModel.Segment segment = EvaluatorClauseTest.makeSegmentThatMatchesUser(segmentKey, "foo");
        LDContext context = LDContext.create((String)"foo");
        Evaluator e = this.evaluatorBuilder().withStoredSegments(segment).build();
        EvaluatorClauseTest.assertMatch(e, flag, context, true);
    }

    @Test
    public void testSegmentMatchClauseFallsThroughIfSegmentNotFound() throws Exception {
        String segmentKey = "segkey";
        DataModel.Clause clause = ModelBuilders.clauseMatchingSegment(segmentKey);
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flag", clause);
        LDContext context = LDContext.create((String)"foo");
        Evaluator e = this.evaluatorBuilder().withNonexistentSegment(segmentKey).build();
        EvaluatorClauseTest.assertMatch(e, flag, context, false);
    }

    @Test
    public void testSegmentMatchClauseIgnoresNonStringValues() throws Exception {
        String segmentKey = "segkey";
        DataModel.Clause clause = ModelBuilders.clause(null, (AttributeRef)null, DataModel.Operator.segmentMatch, LDValue.of((int)123), LDValue.of((String)segmentKey));
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flag", clause);
        DataModel.Segment segment = EvaluatorClauseTest.makeSegmentThatMatchesUser(segmentKey, "foo");
        LDContext context = LDContext.create((String)"foo");
        Evaluator e = this.evaluatorBuilder().withStoredSegments(segment).build();
        EvaluatorClauseTest.assertMatch(e, flag, context, true);
    }
}

