/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.EvaluatorHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluatorOperatorsParameterizedTest {
    private static final LDValue invalidVer = LDValue.of((String)"xbad%ver");
    private static final AttributeRef userAttr = AttributeRef.fromLiteral((String)"attr");
    private final DataModel.Operator op;
    private final LDValue userValue;
    private final LDValue clauseValue;
    private final LDValue[] extraClauseValues;
    private final boolean shouldBe;

    public EvaluatorOperatorsParameterizedTest(DataModel.Operator op, LDValue userValue, LDValue clauseValue, LDValue[] extraClauseValues, boolean shouldBe) {
        this.op = op;
        this.userValue = userValue;
        this.clauseValue = clauseValue;
        this.extraClauseValues = extraClauseValues;
        this.shouldBe = shouldBe;
    }

    @Parameterized.Parameters(name="{1} {0} {2}+{3} should be {4}")
    public static Iterable<Object[]> data() {
        ImmutableList.Builder tests = ImmutableList.builder();
        tests.add((Object[])new Object[][]{{DataModel.Operator.in, LDValue.of((int)99), LDValue.of((int)99), null, true}, {DataModel.Operator.in, LDValue.of((int)99), LDValue.of((int)99), new LDValue[]{LDValue.of((int)98), LDValue.of((int)97), LDValue.of((int)96)}, true}, {DataModel.Operator.in, LDValue.of((double)99.0001), LDValue.of((double)99.0001), new LDValue[]{LDValue.of((int)98), LDValue.of((int)97), LDValue.of((int)96)}, true}, {DataModel.Operator.in, LDValue.of((double)99.0001), LDValue.of((double)99.0001), null, true}, {DataModel.Operator.in, LDValue.of((int)99), LDValue.of((double)99.0001), null, false}, {DataModel.Operator.in, LDValue.of((double)99.0001), LDValue.of((int)99), null, false}, {DataModel.Operator.lessThan, LDValue.of((int)99), LDValue.of((double)99.0001), null, true}, {DataModel.Operator.lessThan, LDValue.of((double)99.0001), LDValue.of((int)99), null, false}, {DataModel.Operator.lessThan, LDValue.of((int)99), LDValue.of((int)99), null, false}, {DataModel.Operator.lessThanOrEqual, LDValue.of((int)99), LDValue.of((double)99.0001), null, true}, {DataModel.Operator.lessThanOrEqual, LDValue.of((double)99.0001), LDValue.of((int)99), null, false}, {DataModel.Operator.lessThanOrEqual, LDValue.of((int)99), LDValue.of((int)99), null, true}, {DataModel.Operator.greaterThan, LDValue.of((double)99.0001), LDValue.of((int)99), null, true}, {DataModel.Operator.greaterThan, LDValue.of((int)99), LDValue.of((double)99.0001), null, false}, {DataModel.Operator.greaterThan, LDValue.of((int)99), LDValue.of((int)99), null, false}, {DataModel.Operator.greaterThanOrEqual, LDValue.of((double)99.0001), LDValue.of((int)99), null, true}, {DataModel.Operator.greaterThanOrEqual, LDValue.of((int)99), LDValue.of((double)99.0001), null, false}, {DataModel.Operator.greaterThanOrEqual, LDValue.of((int)99), LDValue.of((int)99), null, true}, {DataModel.Operator.in, LDValue.of((String)"x"), LDValue.of((String)"x"), null, true}, {DataModel.Operator.in, LDValue.of((String)"x"), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.in, LDValue.of((String)"x"), LDValue.of((String)"x"), new LDValue[]{LDValue.of((String)"a"), LDValue.of((String)"b"), LDValue.of((String)"c")}, true}, {DataModel.Operator.startsWith, LDValue.of((String)"xyz"), LDValue.of((String)"x"), null, true}, {DataModel.Operator.startsWith, LDValue.of((String)"x"), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.startsWith, LDValue.of((int)1), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.startsWith, LDValue.of((String)"1xyz"), LDValue.of((int)1), null, false}, {DataModel.Operator.endsWith, LDValue.of((String)"xyz"), LDValue.of((String)"z"), null, true}, {DataModel.Operator.endsWith, LDValue.of((String)"z"), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.endsWith, LDValue.of((int)1), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.endsWith, LDValue.of((String)"xyz1"), LDValue.of((int)1), null, false}, {DataModel.Operator.contains, LDValue.of((String)"xyz"), LDValue.of((String)"y"), null, true}, {DataModel.Operator.contains, LDValue.of((String)"y"), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.contains, LDValue.of((int)2), LDValue.of((String)"xyz"), null, false}, {DataModel.Operator.contains, LDValue.of((String)"that 2 is not a string"), LDValue.of((int)2), null, false}, {DataModel.Operator.in, LDValue.of((String)"99"), LDValue.of((int)99), null, false}, {DataModel.Operator.in, LDValue.of((int)99), LDValue.of((String)"99"), null, false}, {DataModel.Operator.contains, LDValue.of((String)"99"), LDValue.of((int)99), null, false}, {DataModel.Operator.startsWith, LDValue.of((String)"99"), LDValue.of((int)99), null, false}, {DataModel.Operator.endsWith, LDValue.of((String)"99"), LDValue.of((int)99), null, false}, {DataModel.Operator.lessThanOrEqual, LDValue.of((String)"99"), LDValue.of((int)99), null, false}, {DataModel.Operator.lessThanOrEqual, LDValue.of((int)99), LDValue.of((String)"99"), null, false}, {DataModel.Operator.greaterThanOrEqual, LDValue.of((String)"99"), LDValue.of((int)99), null, false}, {DataModel.Operator.greaterThanOrEqual, LDValue.of((int)99), LDValue.of((String)"99"), null, false}, {DataModel.Operator.in, LDValue.of((boolean)true), LDValue.of((boolean)true), null, true}, {DataModel.Operator.in, LDValue.of((boolean)false), LDValue.of((boolean)false), null, true}, {DataModel.Operator.in, LDValue.of((boolean)true), LDValue.of((boolean)false), null, false}, {DataModel.Operator.in, LDValue.of((boolean)false), LDValue.of((boolean)true), null, false}, {DataModel.Operator.in, LDValue.of((boolean)true), LDValue.of((boolean)false), new LDValue[]{LDValue.of((boolean)true)}, true}, {DataModel.Operator.matches, LDValue.of((String)"hello world"), LDValue.of((String)"hello.*rld"), null, true}, {DataModel.Operator.matches, LDValue.of((String)"hello world"), LDValue.of((String)"hello.*orl"), null, true}, {DataModel.Operator.matches, LDValue.of((String)"hello world"), LDValue.of((String)"l+"), null, true}, {DataModel.Operator.matches, LDValue.of((String)"hello world"), LDValue.of((String)"(world|planet)"), null, true}, {DataModel.Operator.matches, LDValue.of((String)"hello world"), LDValue.of((String)"aloha"), null, false}, {DataModel.Operator.matches, LDValue.of((String)"hello world"), LDValue.of((String)"***not a regex"), null, false}, {DataModel.Operator.matches, LDValue.of((int)2), LDValue.of((String)"that 2 is not a string"), null, false}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2.0.1"), LDValue.of((String)"2.0.1"), null, true}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2.0.2"), LDValue.of((String)"2.0.1"), null, false}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2.0"), LDValue.of((String)"2.0.0"), null, true}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2"), LDValue.of((String)"2.0.0"), null, true}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2-rc1"), LDValue.of((String)"2.0.0-rc1"), null, true}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2+build2"), LDValue.of((String)"2.0.0+build2"), null, true}, {DataModel.Operator.semVerEqual, LDValue.of((String)"xxx"), LDValue.of((String)"2.0.1"), null, false}, {DataModel.Operator.semVerEqual, LDValue.of((int)2), LDValue.of((String)"2.0.1"), null, false}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2.0.1"), LDValue.of((String)"xxx"), null, false}, {DataModel.Operator.semVerEqual, LDValue.of((String)"2.0.1"), LDValue.of((int)2), null, false}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0.0"), LDValue.of((String)"2.0.1"), null, true}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0"), LDValue.of((String)"2.0.1"), null, true}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0.1"), LDValue.of((String)"2.0.0"), null, false}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0.1"), LDValue.of((String)"2.0"), null, false}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0.0-rc"), LDValue.of((String)"2.0.0"), null, true}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0.0-rc"), LDValue.of((String)"2.0.0-rc.beta"), null, true}, {DataModel.Operator.semVerGreaterThan, LDValue.of((String)"2.0.1"), LDValue.of((String)"2.0.0"), null, true}, {DataModel.Operator.semVerGreaterThan, LDValue.of((String)"2.0.1"), LDValue.of((String)"2.0"), null, true}, {DataModel.Operator.semVerGreaterThan, LDValue.of((String)"2.0.0"), LDValue.of((String)"2.0.1"), null, false}, {DataModel.Operator.semVerGreaterThan, LDValue.of((String)"2.0"), LDValue.of((String)"2.0.1"), null, false}, {DataModel.Operator.semVerGreaterThan, LDValue.of((String)"2.0.0-rc.1"), LDValue.of((String)"2.0.0-rc.0"), null, true}, {DataModel.Operator.semVerLessThan, LDValue.of((String)"2.0.1"), invalidVer, null, false}, {DataModel.Operator.semVerGreaterThan, LDValue.of((String)"2.0.1"), invalidVer, null, false}, {null, LDValue.of((String)"x"), LDValue.of((String)"y"), null, false}, {DataModel.Operator.segmentMatch, LDValue.of((String)"x"), LDValue.of((String)"y"), null, false}});
        LDValue dateStr1 = LDValue.of((String)"2017-12-06T00:00:00.000-07:00");
        LDValue dateStrUtc1 = LDValue.of((String)"2017-12-06T07:00:00.000Z");
        LDValue dateMs1 = LDValue.of((long)1512543600000L);
        LDValue dateStr2 = LDValue.of((String)"2017-12-06T00:00:01.000-07:00");
        LDValue dateStrUtc2 = LDValue.of((String)"2017-12-06T07:00:01.000Z");
        LDValue dateMs2 = LDValue.of((long)1512543601000L);
        LDValue invalidDate = LDValue.of((String)"hey what's this?");
        for (LDValue lowerValue : new LDValue[]{dateStr1, dateStrUtc1, dateMs1}) {
            for (LDValue higherValue : new LDValue[]{dateStr2, dateStrUtc2, dateMs2}) {
                tests.add((Object)new Object[]{DataModel.Operator.before, lowerValue, higherValue, null, true});
                tests.add((Object)new Object[]{DataModel.Operator.before, lowerValue, lowerValue, null, false});
                tests.add((Object)new Object[]{DataModel.Operator.before, higherValue, lowerValue, null, false});
                tests.add((Object)new Object[]{DataModel.Operator.before, lowerValue, invalidDate, null, false});
                tests.add((Object)new Object[]{DataModel.Operator.after, higherValue, lowerValue, null, true});
                tests.add((Object)new Object[]{DataModel.Operator.after, lowerValue, lowerValue, null, false});
                tests.add((Object)new Object[]{DataModel.Operator.after, lowerValue, higherValue, null, false});
                tests.add((Object)new Object[]{DataModel.Operator.after, lowerValue, invalidDate, null, false});
            }
        }
        return tests.build();
    }

    @Test
    public void parameterizedTestComparison() {
        ArrayList<LDValue> values = new ArrayList<LDValue>(5);
        if (this.extraClauseValues != null) {
            values.addAll(Arrays.asList(this.extraClauseValues));
        }
        values.add(this.clauseValue);
        DataModel.Clause clause1 = new DataModel.Clause(null, userAttr, this.op, values, false);
        Assert.assertEquals((String)"without preprocessing", (Object)this.shouldBe, (Object)EvaluatorHelpers.matchClauseWithoutSegments((DataModel.Clause)clause1, (LDValue)this.userValue));
        DataModel.Clause clause2 = new DataModel.Clause(null, userAttr, this.op, values, false);
        DataModelPreprocessing.preprocessClause((DataModel.Clause)clause2);
        Assert.assertEquals((String)"without preprocessing", (Object)this.shouldBe, (Object)EvaluatorHelpers.matchClauseWithoutSegments((DataModel.Clause)clause2, (LDValue)this.userValue));
    }
}

