/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.Iterables;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorPrerequisiteTest {
    @Test
    public void flagReturnsOffVariationIfPrerequisiteIsNotFound() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withNonexistentFlag("feature1").build();
        EvalResult result = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)expectedReason), (Object)result);
    }

    @Test
    public void flagReturnsOffVariationAndEventIfPrerequisiteIsOff() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(false).offVariation(1).build();
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withStoredFlags(f1).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)expectedReason), (Object)result);
        Assert.assertEquals((long)1L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f1, (Object)eval.flag);
        Assert.assertEquals((Object)f0, (Object)eval.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval.result.getValue());
    }

    @Test
    public void flagReturnsOffVariationAndEventIfPrerequisiteIsNotMet() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(true).fallthroughVariation(0).build();
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withStoredFlags(f1).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)expectedReason), (Object)result);
        Assert.assertEquals((long)1L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f1, (Object)eval.flag);
        Assert.assertEquals((Object)f0, (Object)eval.prereqOfFlag);
        Assert.assertEquals((long)0L, (long)eval.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.RED_VALUE, (Object)eval.result.getValue());
    }

    @Test
    public void prerequisiteFailedResultInstanceIsReusedForSamePrerequisite() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withNonexistentFlag("feature1").build();
        EvalResult result0 = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult result1 = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)expectedReason, (Object)result0.getReason());
        Assert.assertSame((Object)result0, (Object)result1);
    }

    @Test
    public void prerequisiteFailedReasonInstanceCanBeCreatedFromScratch() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).disablePreprocessing(true).build();
        Assert.assertNull((Object)((DataModel.Prerequisite)f0.getPrerequisites().get((int)0)).preprocessed);
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withNonexistentFlag("feature1").build();
        EvalResult result0 = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult result1 = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)expectedReason, (Object)result0.getReason());
        Assert.assertNotSame((Object)result0.getReason(), (Object)result1.getReason());
        Assert.assertEquals((Object)result0.getReason(), (Object)result1.getReason());
    }

    @Test
    public void flagReturnsFallthroughVariationAndEventIfPrerequisiteIsMetAndThereAreNoRules() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(true).fallthroughVariation(1).version(2).build();
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withStoredFlags(f1).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.FALLTHROUGH_VALUE, (int)1, (EvaluationReason)EvaluationReason.fallthrough()), (Object)result);
        Assert.assertEquals((long)1L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f1, (Object)eval.flag);
        Assert.assertEquals((Object)f0, (Object)eval.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval.result.getValue());
    }

    @Test
    public void multipleLevelsOfPrerequisitesProduceMultipleEvents() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(true).prerequisites(ModelBuilders.prerequisite("feature2", 1)).fallthroughVariation(1).build();
        DataModel.FeatureFlag f2 = EvaluatorTestUtil.buildRedGreenFlag("feature2").on(true).fallthroughVariation(1).build();
        Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withStoredFlags(f1, f2).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, EvaluatorTestUtil.BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.FALLTHROUGH_VALUE, (int)1, (EvaluationReason)EvaluationReason.fallthrough()), (Object)result);
        Assert.assertEquals((long)2L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval0 = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f2, (Object)eval0.flag);
        Assert.assertEquals((Object)f1, (Object)eval0.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval0.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval0.result.getValue());
        EvaluatorTestUtil.PrereqEval eval1 = recordPrereqs.evals.get(1);
        Assert.assertEquals((Object)f1, (Object)eval1.flag);
        Assert.assertEquals((Object)f0, (Object)eval1.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval1.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval1.result.getValue());
    }

    @Test
    public void prerequisiteCycleDetection() {
        for (int depth = 1; depth <= 4; ++depth) {
            String[] flagKeys = new String[depth];
            for (int i = 0; i < depth; ++i) {
                flagKeys[i] = "flagkey" + i;
            }
            DataModel.FeatureFlag[] flags = new DataModel.FeatureFlag[depth];
            for (int i = 0; i < depth; ++i) {
                flags[i] = ModelBuilders.flagBuilder(flagKeys[i]).on(true).variations(false, true).offVariation(0).prerequisites(new DataModel.Prerequisite(flagKeys[(i + 1) % depth], 0)).build();
            }
            Evaluator e = EvaluatorTestUtil.evaluatorBuilder().withStoredFlags(flags).build();
            LDContext context = LDContext.create((String)"foo");
            EvalResult result = e.evaluate(flags[0], context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
            Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
        }
    }
}

