/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorRuleTest {
    private static final LDContext BASE_USER = LDContext.create((String)"userkey");
    private static final LDContext OTHER_USER = LDContext.create((String)"otherkey");
    private static final int FALLTHROUGH_VARIATION = 0;
    private static final int MATCH_VARIATION = 1;

    private ModelBuilders.FlagBuilder buildBooleanFlagWithRules(String flagKey, DataModel.Rule ... rules) {
        return ModelBuilders.flagBuilder(flagKey).on(true).rules(rules).fallthroughVariation(0).offVariation(0).variations(LDValue.of((boolean)false), LDValue.of((boolean)true));
    }

    private ModelBuilders.RuleBuilder buildTestRule(String id, DataModel.Clause ... clauses) {
        return ModelBuilders.ruleBuilder().id(id).clauses(clauses).variation(1);
    }

    @Test
    public void ruleMatchResultInstanceIsReusedForSameRule() {
        DataModel.Clause clause0 = ModelBuilders.clauseMatchingContext(OTHER_USER);
        DataModel.Clause clause1 = ModelBuilders.clauseMatchingContext(BASE_USER);
        DataModel.Rule rule0 = this.buildTestRule("ruleid0", clause0).build();
        DataModel.Rule rule1 = this.buildTestRule("ruleid1", clause1).build();
        DataModel.FeatureFlag f = this.buildBooleanFlagWithRules("feature", rule0, rule1).build();
        EvalResult sameResult0 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult sameResult1 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult otherResult = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, OTHER_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvaluationReason.ruleMatch((int)1, (String)"ruleid1"), (Object)sameResult0.getReason());
        Assert.assertSame((Object)sameResult0, (Object)sameResult1);
        Assert.assertEquals((Object)EvaluationReason.ruleMatch((int)0, (String)"ruleid0"), (Object)otherResult.getReason());
    }

    @Test
    public void ruleMatchResultInstanceCanBeCreatedFromScratch() {
        DataModel.Clause clause = ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"userkey"));
        DataModel.Rule rule = this.buildTestRule("ruleid", clause).build();
        LDContext user = LDContext.create((String)"userkey");
        DataModel.FeatureFlag f = this.buildBooleanFlagWithRules("feature", rule).disablePreprocessing(true).build();
        Assert.assertNull((Object)((DataModel.Rule)f.getRules().get((int)0)).preprocessed);
        EvalResult result1 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, user, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult result2 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, user, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvaluationReason.ruleMatch((int)0, (String)"ruleid"), (Object)result1.getReason());
        Assert.assertNotSame((Object)result1, (Object)result2);
        Assert.assertEquals((Object)result1, (Object)result2);
    }

    @Test
    public void ruleWithTooHighVariationReturnsMalformedFlagError() {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(BASE_USER);
        DataModel.Rule rule = this.buildTestRule("ruleid", clause).variation(999).build();
        DataModel.FeatureFlag f = this.buildBooleanFlagWithRules("feature", rule).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void ruleWithNegativeVariationReturnsMalformedFlagError() {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(BASE_USER);
        DataModel.Rule rule = this.buildTestRule("ruleid", clause).variation(-1).build();
        DataModel.FeatureFlag f = this.buildBooleanFlagWithRules("feature", rule).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void ruleWithNoVariationOrRolloutReturnsMalformedFlagError() {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(BASE_USER);
        DataModel.Rule rule = this.buildTestRule("ruleid", clause).variation(null).build();
        DataModel.FeatureFlag f = this.buildBooleanFlagWithRules("feature", rule).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void ruleWithRolloutWithEmptyVariationsListReturnsMalformedFlagError() {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(BASE_USER);
        DataModel.Rule rule = this.buildTestRule("ruleid", clause).variation(null).rollout(ModelBuilders.emptyRollout()).build();
        DataModel.FeatureFlag f = this.buildBooleanFlagWithRules("feature", rule).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void rolloutUsesCorrectBucketValue() {
        LDContext c = LDContext.create((String)"foo");
        EvaluatorRuleTest.testRolloutBucketing("foo", c, null, null, DataModel.RolloutKind.rollout);
    }

    @Test
    public void rolloutUsesContextKind() {
        LDContext c1 = LDContext.create((ContextKind)ContextKind.of((String)"kind1"), (String)"foo");
        LDContext c2 = LDContext.create((ContextKind)ContextKind.of((String)"kind2"), (String)"bar");
        LDContext multi = LDContext.createMulti((LDContext[])new LDContext[]{c1, c2});
        EvaluatorRuleTest.testRolloutBucketing("foo", multi, ContextKind.of((String)"kind1"), null, DataModel.RolloutKind.rollout);
    }

    @Test
    public void rolloutUsesBucketBy() {
        LDContext c = LDContext.builder((String)"xxx").set("attr1", LDValue.parse((String)"{\"prop1\":\"foo\"}")).build();
        EvaluatorRuleTest.testRolloutBucketing("foo", c, null, AttributeRef.fromPath((String)"/attr1/prop1"), DataModel.RolloutKind.rollout);
    }

    @Test
    public void experimentIgnoresBucketBy() {
        LDContext c = LDContext.builder((String)"xxx").set("attr1", LDValue.parse((String)"{\"prop1\":\"foo\"}")).build();
        EvaluatorRuleTest.testRolloutBucketing("xxx", c, null, AttributeRef.fromPath((String)"/attr1/prop1"), DataModel.RolloutKind.experiment);
    }

    private static void testRolloutBucketing(String bucketByValue, LDContext context, ContextKind contextKind, AttributeRef bucketBy, DataModel.RolloutKind rolloutKind) {
        String flagKey = "feature";
        String salt = "abc";
        float expectedBucketValue = EvaluatorBucketing.computeBucketValue((boolean)false, null, (LDContext)LDContext.create((String)bucketByValue), null, (String)flagKey, null, (String)salt);
        int bucketValueAsInt = (int)(expectedBucketValue * 100000.0f);
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(context);
        DataModel.Rollout rollout = new DataModel.Rollout(contextKind, Arrays.asList(new DataModel.WeightedVariation(0, bucketValueAsInt - 1, false), new DataModel.WeightedVariation(1, 2, false), new DataModel.WeightedVariation(2, 100000 - (bucketValueAsInt + 1), false)), bucketBy, rolloutKind, null);
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder(flagKey).on(true).variations(LDValue.of((String)"no"), LDValue.of((String)"yes"), LDValue.of((String)"no")).rules(ModelBuilders.ruleBuilder().id("rule").clauses(clause).rollout(rollout).build()).salt(salt).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)LDValue.of((String)"yes"), (Object)result.getValue());
        Assert.assertEquals((long)1L, (long)result.getVariationIndex());
        Assert.assertEquals((Object)EvaluationReason.Kind.RULE_MATCH, (Object)result.getReason().getKind());
    }
}

