/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorTestBase;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorSegmentMatchTest
extends EvaluatorTestBase {
    private static final String SEGMENT_KEY = "segmentkey";
    private static final String ARBITRARY_SALT = "abcdef";
    private static final int maxWeight = 100000;

    @Test
    public void explicitIncludeUser() {
        LDContext c = LDContext.create((String)"foo");
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().included(c.getKey()).build();
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void explicitExcludeUser() {
        LDContext c = LDContext.create((String)"foo");
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().excluded(c.getKey()).rules(ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingContext(c)).build()).build();
        Assert.assertFalse((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void explicitIncludeHasPrecedence() {
        LDContext c = LDContext.create((String)"foo");
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().included(c.getKey()).excluded(c.getKey()).build();
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void includedKeyForContextKind() {
        ContextKind kind1 = ContextKind.of((String)"kind1");
        String key = "foo";
        LDContext c1 = LDContext.create((String)key);
        LDContext c2 = LDContext.create((ContextKind)kind1, (String)key);
        LDContext c3 = LDContext.createMulti((LDContext[])new LDContext[]{c1, c2});
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().includedContexts(kind1, key).build();
        Assert.assertFalse((boolean)this.segmentMatchesContext(s, c1));
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c2));
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c3));
    }

    @Test
    public void excludedKeyForContextKind() {
        ContextKind kind1 = ContextKind.of((String)"kind1");
        String key = "foo";
        LDContext c1 = LDContext.create((String)key);
        LDContext c2 = LDContext.create((ContextKind)kind1, (String)key);
        LDContext c3 = LDContext.createMulti((LDContext[])new LDContext[]{c1, c2});
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().excludedContexts(kind1, key).rules(ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingContext(c1)).build(), ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingContext(c2)).build(), ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingContext(c3)).build()).build();
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c1));
        Assert.assertFalse((boolean)this.segmentMatchesContext(s, c2));
        Assert.assertFalse((boolean)this.segmentMatchesContext(s, c3));
    }

    @Test
    public void matchingRuleWithFullRollout() {
        LDContext c = LDContext.create((String)"foo");
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(c);
        DataModel.SegmentRule rule = ModelBuilders.segmentRuleBuilder().clauses(clause).weight(100000).build();
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().rules(rule).build();
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void matchingRuleWithZeroRollout() {
        LDContext c = LDContext.create((String)"foo");
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(c);
        DataModel.SegmentRule rule = ModelBuilders.segmentRuleBuilder().clauses(clause).weight(0).build();
        DataModel.Segment s = EvaluatorSegmentMatchTest.baseSegmentBuilder().rules(rule).build();
        Assert.assertFalse((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void matchingRuleWithMultipleClauses() {
        DataModel.Clause clause1 = ModelBuilders.clause("email", DataModel.Operator.in, LDValue.of((String)"test@example.com"));
        DataModel.Clause clause2 = ModelBuilders.clause("name", DataModel.Operator.in, LDValue.of((String)"bob"));
        DataModel.SegmentRule rule = ModelBuilders.segmentRuleBuilder().clauses(clause1, clause2).build();
        DataModel.Segment s = ModelBuilders.segmentBuilder("test").salt(ARBITRARY_SALT).rules(rule).build();
        LDContext c = LDContext.builder((String)"foo").set("email", "test@example.com").name("bob").build();
        Assert.assertTrue((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void nonMatchingRuleWithMultipleClauses() {
        DataModel.Clause clause1 = ModelBuilders.clause("email", DataModel.Operator.in, LDValue.of((String)"test@example.com"));
        DataModel.Clause clause2 = ModelBuilders.clause("name", DataModel.Operator.in, LDValue.of((String)"bill"));
        DataModel.SegmentRule rule = ModelBuilders.segmentRuleBuilder().clauses(clause1, clause2).build();
        DataModel.Segment s = ModelBuilders.segmentBuilder("test").salt(ARBITRARY_SALT).rules(rule).build();
        LDContext c = LDContext.builder((String)"foo").set("email", "test@example.com").name("bob").build();
        Assert.assertFalse((boolean)this.segmentMatchesContext(s, c));
    }

    @Test
    public void rolloutUsesCorrectBucketValue() {
        LDContext c = LDContext.create((String)"foo");
        this.testRolloutBucketing("foo", c, null, null);
    }

    @Test
    public void rolloutUsesContextKind() {
        LDContext c1 = LDContext.create((ContextKind)ContextKind.of((String)"kind1"), (String)"foo");
        LDContext c2 = LDContext.create((ContextKind)ContextKind.of((String)"kind2"), (String)"bar");
        LDContext multi = LDContext.createMulti((LDContext[])new LDContext[]{c1, c2});
        this.testRolloutBucketing("foo", multi, ContextKind.of((String)"kind1"), null);
    }

    @Test
    public void rolloutUsesBucketBy() {
        LDContext c = LDContext.builder((String)"xxx").set("attr1", LDValue.parse((String)"{\"prop1\":\"foo\"}")).build();
        this.testRolloutBucketing("foo", c, null, AttributeRef.fromPath((String)"/attr1/prop1"));
    }

    private void testRolloutBucketing(String bucketByValue, LDContext context, ContextKind contextKind, AttributeRef bucketBy) {
        float expectedBucketValue = EvaluatorBucketing.computeBucketValue((boolean)false, null, (LDContext)LDContext.create((String)bucketByValue), null, (String)SEGMENT_KEY, null, (String)ARBITRARY_SALT);
        int bucketValueAsInt = (int)(expectedBucketValue * 100000.0f);
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(context);
        DataModel.Segment s1 = EvaluatorSegmentMatchTest.baseSegmentBuilder().rules(ModelBuilders.segmentRuleBuilder().clauses(clause).weight(bucketValueAsInt + 1).rolloutContextKind(contextKind).bucketBy(bucketBy).build()).build();
        Assert.assertTrue((boolean)this.segmentMatchesContext(s1, context));
        DataModel.Segment s2 = EvaluatorSegmentMatchTest.baseSegmentBuilder().rules(ModelBuilders.segmentRuleBuilder().clauses(clause).weight(bucketValueAsInt - 1).rolloutContextKind(contextKind).bucketBy(bucketBy).build()).build();
        Assert.assertFalse((boolean)this.segmentMatchesContext(s2, context));
    }

    @Test
    public void segmentReferencingSegment() {
        LDContext context = LDContext.create((String)"foo");
        DataModel.Segment segment0 = ModelBuilders.segmentBuilder("segmentkey0").rules(ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segmentkey1")).build()).build();
        DataModel.Segment segment1 = ModelBuilders.segmentBuilder("segmentkey1").included(context.getKey()).build();
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flag", ModelBuilders.clauseMatchingSegment(segment0));
        Evaluator e = this.evaluatorBuilder().withStoredSegments(segment0, segment1).build();
        EvalResult result = e.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertTrue((boolean)result.getValue().booleanValue());
    }

    @Test
    public void segmentCycleDetection() {
        for (int depth = 1; depth <= 4; ++depth) {
            String[] segmentKeys = new String[depth];
            for (int i = 0; i < depth; ++i) {
                segmentKeys[i] = SEGMENT_KEY + i;
            }
            DataModel.Segment[] segments = new DataModel.Segment[depth];
            for (int i = 0; i < depth; ++i) {
                segments[i] = ModelBuilders.segmentBuilder(segmentKeys[i]).rules(ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingSegment(segmentKeys[(i + 1) % depth])).build()).build();
            }
            DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flag", ModelBuilders.clauseMatchingSegment(segments[0]));
            Evaluator e = this.evaluatorBuilder().withStoredSegments(segments).build();
            LDContext context = LDContext.create((String)"foo");
            EvalResult result = e.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
            Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
        }
    }

    private static ModelBuilders.SegmentBuilder baseSegmentBuilder() {
        return ModelBuilders.segmentBuilder(SEGMENT_KEY).version(1).salt(ARBITRARY_SALT);
    }

    private boolean segmentMatchesContext(DataModel.Segment segment, LDContext context) {
        DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flag", ModelBuilders.clauseMatchingSegment(segment));
        Evaluator e = this.evaluatorBuilder().withStoredSegments(segment).build();
        return e.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals()).getValue().booleanValue();
    }
}

