/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class EvaluatorTargetTest {
    private static final int FALLTHROUGH_VAR = 0;
    private static final int MATCH_VAR_1 = 1;
    private static final int MATCH_VAR_2 = 2;
    private static final LDValue[] VARIATIONS = new LDValue[]{LDValue.of((String)"fallthrough"), LDValue.of((String)"match1"), LDValue.of((String)"match2")};
    private static final ContextKind CAT_KIND = ContextKind.of((String)"cat");
    private static final ContextKind DOG_KIND = ContextKind.of((String)"dog");

    @Test
    public void userTargetsOnly() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTargetTest.baseFlagBuilder().targets(ModelBuilders.target(1, "c"), ModelBuilders.target(2, "b", "a")).build();
        EvaluatorTargetTest.expectMatch(f, EvaluatorTargetTest.user("a"), 2);
        EvaluatorTargetTest.expectMatch(f, EvaluatorTargetTest.user("b"), 2);
        EvaluatorTargetTest.expectMatch(f, EvaluatorTargetTest.user("c"), 1);
        EvaluatorTargetTest.expectFallthrough(f, EvaluatorTargetTest.user("z"));
        EvaluatorTargetTest.expectMatch(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("b"), EvaluatorTargetTest.user("a")}), 2);
        EvaluatorTargetTest.expectMatch(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("a"), EvaluatorTargetTest.user("c")}), 1);
        EvaluatorTargetTest.expectFallthrough(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("b"), EvaluatorTargetTest.user("z")}));
        EvaluatorTargetTest.expectFallthrough(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("a"), EvaluatorTargetTest.cat("b")}));
    }

    @Test
    public void userTargetsAndContextTargets() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTargetTest.baseFlagBuilder().targets(ModelBuilders.target(1, "c"), ModelBuilders.target(2, "b", "a")).contextTargets(ModelBuilders.target(DOG_KIND, 1, "a", "b"), ModelBuilders.target(DOG_KIND, 2, "c"), ModelBuilders.target(ContextKind.DEFAULT, 1, new String[0]), ModelBuilders.target(ContextKind.DEFAULT, 2, new String[0])).build();
        EvaluatorTargetTest.expectMatch(f, EvaluatorTargetTest.user("a"), 2);
        EvaluatorTargetTest.expectMatch(f, EvaluatorTargetTest.user("b"), 2);
        EvaluatorTargetTest.expectMatch(f, EvaluatorTargetTest.user("c"), 1);
        EvaluatorTargetTest.expectFallthrough(f, EvaluatorTargetTest.user("z"));
        EvaluatorTargetTest.expectMatch(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("b"), EvaluatorTargetTest.user("a")}), 1);
        EvaluatorTargetTest.expectMatch(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("z"), EvaluatorTargetTest.user("a")}), 2);
        EvaluatorTargetTest.expectFallthrough(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("x"), EvaluatorTargetTest.user("z")}));
        EvaluatorTargetTest.expectMatch(f, LDContext.createMulti((LDContext[])new LDContext[]{EvaluatorTargetTest.dog("a"), EvaluatorTargetTest.cat("b")}), 1);
    }

    private static ModelBuilders.FlagBuilder baseFlagBuilder() {
        return ModelBuilders.flagBuilder("feature").on(true).variations(VARIATIONS).fallthroughVariation(0).offVariation(0);
    }

    private static void expectMatch(DataModel.FeatureFlag f, LDContext c, int v) {
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, c, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        MatcherAssert.assertThat((Object)result.getVariationIndex(), (Matcher)Matchers.equalTo((Object)v));
        MatcherAssert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)VARIATIONS[v]));
        MatcherAssert.assertThat((Object)result.getReason(), (Matcher)Matchers.equalTo((Object)EvaluationReason.targetMatch()));
    }

    private static void expectFallthrough(DataModel.FeatureFlag f, LDContext c) {
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, c, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        MatcherAssert.assertThat((Object)result.getVariationIndex(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)VARIATIONS[0]));
        MatcherAssert.assertThat((Object)result.getReason(), (Matcher)Matchers.equalTo((Object)EvaluationReason.fallthrough()));
    }

    private static LDContext user(String key) {
        return LDContext.create((String)key);
    }

    private static LDContext cat(String key) {
        return LDContext.create((ContextKind)CAT_KIND, (String)key);
    }

    private static LDContext dog(String key) {
        return LDContext.create((ContextKind)DOG_KIND, (String)key);
    }
}

