/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.Iterables;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EvaluatorTestBase;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorTest
extends EvaluatorTestBase {
    private static final LDContext BASE_USER = LDContext.create((String)"x");

    private static DataModel.Rollout buildRollout(boolean isExperiment, boolean untrackedVariations) {
        ArrayList<DataModel.WeightedVariation> variations = new ArrayList<DataModel.WeightedVariation>();
        variations.add(new DataModel.WeightedVariation(1, 50000, untrackedVariations));
        variations.add(new DataModel.WeightedVariation(2, 50000, untrackedVariations));
        DataModel.RolloutKind kind = isExperiment ? DataModel.RolloutKind.experiment : DataModel.RolloutKind.rollout;
        Integer seed = 123;
        DataModel.Rollout rollout = new DataModel.Rollout(null, variations, null, kind, seed);
        return rollout;
    }

    @Test
    public void evaluationReturnsErrorIfContextIsNull() throws Exception {
        DataModel.FeatureFlag f = ModelBuilders.flagBuilder("feature").build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, null, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.EXCEPTION), (Object)result);
    }

    @Test
    public void evaluationReturnsErrorIfContextIsInvalid() throws Exception {
        DataModel.FeatureFlag f = ModelBuilders.flagBuilder("feature").build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, LDContext.create((String)""), EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.EXCEPTION), (Object)result);
    }

    @Test
    public void flagReturnsOffVariationIfFlagIsOff() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(false).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)EvaluationReason.off()), (Object)result);
    }

    @Test
    public void flagReturnsNullIfFlagIsOffAndOffVariationIsUnspecified() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(false).offVariation(null).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.of((LDValue)LDValue.ofNull(), (int)-1, (EvaluationReason)EvaluationReason.off()), (Object)result);
    }

    @Test
    public void flagReturnsErrorIfFlagIsOffAndOffVariationIsTooHigh() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(false).offVariation(999).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void flagReturnsErrorIfFlagIsOffAndOffVariationIsNegative() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(false).offVariation(-1).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void flagReturnsInExperimentForFallthroughWhenInExperimentVariation() throws Exception {
        DataModel.Rollout rollout = EvaluatorTest.buildRollout(true, false);
        DataModel.VariationOrRollout vr = new DataModel.VariationOrRollout(null, rollout);
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthrough(vr).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (result.getReason().isInExperiment());
    }

    @Test
    public void flagReturnsNotInExperimentForFallthroughWhenNotInExperimentVariation() throws Exception {
        DataModel.Rollout rollout = EvaluatorTest.buildRollout(true, true);
        DataModel.VariationOrRollout vr = new DataModel.VariationOrRollout(null, rollout);
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthrough(vr).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (!result.getReason().isInExperiment());
    }

    @Test
    public void flagReturnsNotInExperimentForFallthrougWhenInExperimentVariationButNonExperimentRollout() throws Exception {
        DataModel.Rollout rollout = EvaluatorTest.buildRollout(false, false);
        DataModel.VariationOrRollout vr = new DataModel.VariationOrRollout(null, rollout);
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthrough(vr).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (!result.getReason().isInExperiment());
    }

    @Test
    public void flagReturnsInExperimentForRuleMatchWhenInExperimentVariation() throws Exception {
        DataModel.Rollout rollout = EvaluatorTest.buildRollout(true, false);
        DataModel.Rule rule = ModelBuilders.ruleBuilder().id("ruleid0").clauses(ModelBuilders.clauseMatchingContext(BASE_USER)).rollout(rollout).build();
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).rules(rule).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (result.getReason().isInExperiment());
    }

    @Test
    public void flagReturnsNotInExperimentForRuleMatchWhenNotInExperimentVariation() throws Exception {
        DataModel.Rollout rollout = EvaluatorTest.buildRollout(true, true);
        DataModel.Rule rule = ModelBuilders.ruleBuilder().id("ruleid0").clauses(ModelBuilders.clauseMatchingContext(BASE_USER)).rollout(rollout).build();
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).rules(rule).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (!result.getReason().isInExperiment());
    }

    @Test
    public void flagReturnsNotInExperimentWhenContextKindIsNotFound() throws Exception {
        DataModel.Rollout rollout = new DataModel.Rollout(ContextKind.of((String)"nonexistent"), Arrays.asList(new DataModel.WeightedVariation(0, 1, false), new DataModel.WeightedVariation(1, 99999, false)), null, DataModel.RolloutKind.experiment, null);
        DataModel.Rule rule = ModelBuilders.ruleBuilder().id("ruleid0").clauses(ModelBuilders.clauseMatchingContext(BASE_USER)).rollout(rollout).build();
        DataModel.FeatureFlag flagWithRule = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).rules(rule).build();
        EvalResult result1 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(flagWithRule, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (!result1.getReason().isInExperiment());
        DataModel.FeatureFlag flagWithFallthrough = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthrough(rollout).rules(rule).build();
        EvalResult result2 = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(flagWithFallthrough, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        assert (!result2.getReason().isInExperiment());
    }

    @Test
    public void flagReturnsFallthroughIfFlagIsOnAndThereAreNoRules() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.FALLTHROUGH_VALUE, (int)1, (EvaluationReason)EvaluationReason.fallthrough()), (Object)result);
    }

    @Test
    public void fallthroughResultHasForceReasonTrackingTrueIfTrackEventsFallthroughIstrue() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).trackEventsFallthrough(true).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.FALLTHROUGH_VALUE, (int)1, (EvaluationReason)EvaluationReason.fallthrough()).withForceReasonTracking(true), (Object)result);
    }

    @Test
    public void flagReturnsErrorIfFallthroughHasTooHighVariation() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthroughVariation(999).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void flagReturnsErrorIfFallthroughHasNegativeVariation() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthroughVariation(-1).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void flagReturnsErrorIfFallthroughHasNeitherVariationNorRollout() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthrough(new DataModel.VariationOrRollout(null, null)).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void flagReturnsErrorIfFallthroughHasEmptyRolloutVariationList() throws Exception {
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).fallthrough(new DataModel.VariationOrRollout(null, ModelBuilders.emptyRollout())).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG), (Object)result);
    }

    @Test
    public void flagReturnsOffVariationIfPrerequisiteIsNotFound() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        Evaluator e = this.evaluatorBuilder().withNonexistentFlag("feature1").build();
        EvalResult result = e.evaluate(f0, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)expectedReason), (Object)result);
    }

    @Test
    public void flagReturnsOffVariationAndEventIfPrerequisiteIsOff() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(false).offVariation(1).build();
        Evaluator e = this.evaluatorBuilder().withStoredFlags(f1).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)expectedReason), (Object)result);
        Assert.assertEquals((long)1L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f1, (Object)eval.flag);
        Assert.assertEquals((Object)f0, (Object)eval.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval.result.getValue());
    }

    @Test
    public void flagReturnsOffVariationAndEventIfPrerequisiteIsNotMet() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(true).fallthroughVariation(0).build();
        Evaluator e = this.evaluatorBuilder().withStoredFlags(f1).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.OFF_VALUE, (int)0, (EvaluationReason)expectedReason), (Object)result);
        Assert.assertEquals((long)1L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f1, (Object)eval.flag);
        Assert.assertEquals((Object)f0, (Object)eval.prereqOfFlag);
        Assert.assertEquals((long)0L, (long)eval.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.RED_VALUE, (Object)eval.result.getValue());
    }

    @Test
    public void prerequisiteFailedResultInstanceIsReusedForSamePrerequisite() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        Evaluator e = this.evaluatorBuilder().withNonexistentFlag("feature1").build();
        EvalResult result0 = e.evaluate(f0, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult result1 = e.evaluate(f0, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)expectedReason, (Object)result0.getReason());
        Assert.assertSame((Object)result0, (Object)result1);
    }

    @Test
    public void prerequisiteFailedReasonInstanceCanBeCreatedFromScratch() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).disablePreprocessing(true).build();
        Assert.assertNull((Object)((DataModel.Prerequisite)f0.getPrerequisites().get((int)0)).preprocessed);
        Evaluator e = this.evaluatorBuilder().withNonexistentFlag("feature1").build();
        EvalResult result0 = e.evaluate(f0, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvalResult result1 = e.evaluate(f0, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        EvaluationReason expectedReason = EvaluationReason.prerequisiteFailed((String)"feature1");
        Assert.assertEquals((Object)expectedReason, (Object)result0.getReason());
        Assert.assertNotSame((Object)result0.getReason(), (Object)result1.getReason());
        Assert.assertEquals((Object)result0.getReason(), (Object)result1.getReason());
    }

    @Test
    public void flagReturnsFallthroughVariationAndEventIfPrerequisiteIsMetAndThereAreNoRules() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(true).fallthroughVariation(1).version(2).build();
        Evaluator e = this.evaluatorBuilder().withStoredFlags(f1).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.FALLTHROUGH_VALUE, (int)1, (EvaluationReason)EvaluationReason.fallthrough()), (Object)result);
        Assert.assertEquals((long)1L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f1, (Object)eval.flag);
        Assert.assertEquals((Object)f0, (Object)eval.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval.result.getValue());
    }

    @Test
    public void multipleLevelsOfPrerequisitesProduceMultipleEvents() throws Exception {
        DataModel.FeatureFlag f0 = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).build();
        DataModel.FeatureFlag f1 = EvaluatorTestUtil.buildRedGreenFlag("feature1").on(true).prerequisites(ModelBuilders.prerequisite("feature2", 1)).fallthroughVariation(1).build();
        DataModel.FeatureFlag f2 = EvaluatorTestUtil.buildRedGreenFlag("feature2").on(true).fallthroughVariation(1).build();
        Evaluator e = this.evaluatorBuilder().withStoredFlags(f1, f2).build();
        EvaluatorTestUtil.PrereqRecorder recordPrereqs = new EvaluatorTestUtil.PrereqRecorder();
        EvalResult result = e.evaluate(f0, BASE_USER, (Evaluator.PrerequisiteEvaluationSink)recordPrereqs);
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.FALLTHROUGH_VALUE, (int)1, (EvaluationReason)EvaluationReason.fallthrough()), (Object)result);
        Assert.assertEquals((long)2L, (long)Iterables.size(recordPrereqs.evals));
        EvaluatorTestUtil.PrereqEval eval0 = recordPrereqs.evals.get(0);
        Assert.assertEquals((Object)f2, (Object)eval0.flag);
        Assert.assertEquals((Object)f1, (Object)eval0.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval0.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval0.result.getValue());
        EvaluatorTestUtil.PrereqEval eval1 = recordPrereqs.evals.get(1);
        Assert.assertEquals((Object)f1, (Object)eval1.flag);
        Assert.assertEquals((Object)f0, (Object)eval1.prereqOfFlag);
        Assert.assertEquals((long)1L, (long)eval1.result.getVariationIndex());
        Assert.assertEquals((Object)EvaluatorTestUtil.GREEN_VALUE, (Object)eval1.result.getValue());
    }

    @Test
    public void flagMatchesUserFromRules() {
        DataModel.Clause clause0 = ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"wrongkey"));
        DataModel.Clause clause1 = ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"userkey"));
        DataModel.Rule rule0 = ModelBuilders.ruleBuilder().id("ruleid0").clauses(clause0).variation(2).build();
        DataModel.Rule rule1 = ModelBuilders.ruleBuilder().id("ruleid1").clauses(clause1).variation(2).build();
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).rules(rule0, rule1).build();
        LDContext user = LDContext.create((String)"userkey");
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, user, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.MATCH_VALUE, (int)2, (EvaluationReason)EvaluationReason.ruleMatch((int)1, (String)"ruleid1")), (Object)result);
    }

    @Test
    public void ruleMatchReasonHasTrackReasonTrueIfRuleLevelTrackEventsIsTrue() {
        DataModel.Clause clause0 = ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"wrongkey"));
        DataModel.Clause clause1 = ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"userkey"));
        DataModel.Rule rule0 = ModelBuilders.ruleBuilder().id("ruleid0").clauses(clause0).variation(2).build();
        DataModel.Rule rule1 = ModelBuilders.ruleBuilder().id("ruleid1").clauses(clause1).variation(2).trackEvents(true).build();
        DataModel.FeatureFlag f = EvaluatorTestUtil.buildThreeWayFlag("feature").on(true).rules(rule0, rule1).build();
        LDContext user = LDContext.create((String)"userkey");
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(f, user, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        Assert.assertEquals((Object)EvalResult.of((LDValue)EvaluatorTestUtil.MATCH_VALUE, (int)2, (EvaluationReason)EvaluationReason.ruleMatch((int)1, (String)"ruleid1")).withForceReasonTracking(true), (Object)result);
    }

    @Test(expected=RuntimeException.class)
    public void canSimulateErrorUsingTestInstrumentationFlagKey() {
        DataModel.FeatureFlag badFlag = ModelBuilders.flagBuilder("$ test error flag $").build();
        EvaluatorTestUtil.BASE_EVALUATOR.evaluate(badFlag, BASE_USER, EvaluatorTestUtil.expectNoPrerequisiteEvals());
    }
}

