/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.ModelBuilders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class EvaluatorTestUtil {
    public static final LDContext BASE_USER = LDContext.create((String)"x");
    public static final int OFF_VARIATION = 0;
    public static final LDValue OFF_VALUE = LDValue.of((String)"off");
    public static final int FALLTHROUGH_VARIATION = 1;
    public static final LDValue FALLTHROUGH_VALUE = LDValue.of((String)"fall");
    public static final int MATCH_VARIATION = 2;
    public static final LDValue MATCH_VALUE = LDValue.of((String)"match");
    public static final LDValue[] THREE_VARIATIONS = new LDValue[]{OFF_VALUE, FALLTHROUGH_VALUE, MATCH_VALUE};
    public static final int RED_VARIATION = 0;
    public static final LDValue RED_VALUE = LDValue.of((String)"red");
    public static final int GREEN_VARIATION = 1;
    public static final LDValue GREEN_VALUE = LDValue.of((String)"green");
    public static final LDValue[] RED_GREEN_VARIATIONS = new LDValue[]{RED_VALUE, GREEN_VALUE};
    public static Evaluator BASE_EVALUATOR = new EvaluatorBuilder().build();

    public static ModelBuilders.FlagBuilder buildThreeWayFlag(String flagKey) {
        return ModelBuilders.flagBuilder(flagKey).fallthroughVariation(1).offVariation(0).variations(THREE_VARIATIONS).version(EvaluatorTestUtil.versionFromKey(flagKey));
    }

    public static ModelBuilders.FlagBuilder buildRedGreenFlag(String flagKey) {
        return ModelBuilders.flagBuilder(flagKey).fallthroughVariation(1).offVariation(0).variations(RED_GREEN_VARIATIONS).version(EvaluatorTestUtil.versionFromKey(flagKey));
    }

    public static int versionFromKey(String flagKey) {
        return Math.abs(flagKey.hashCode());
    }

    public static EvaluatorBuilder evaluatorBuilder() {
        return new EvaluatorBuilder();
    }

    public static Evaluator.PrerequisiteEvaluationSink expectNoPrerequisiteEvals() {
        return (f1, f2, u, r) -> {
            throw new AssertionError((Object)"did not expect any prerequisite evaluations, but got one");
        };
    }

    public static final class PrereqRecorder
    implements Evaluator.PrerequisiteEvaluationSink {
        public final List<PrereqEval> evals = new ArrayList<PrereqEval>();

        public void recordPrerequisiteEvaluation(DataModel.FeatureFlag flag, DataModel.FeatureFlag prereqOfFlag, LDContext context, EvalResult result) {
            this.evals.add(new PrereqEval(flag, prereqOfFlag, context, result));
        }
    }

    public static final class PrereqEval {
        public final DataModel.FeatureFlag flag;
        public final DataModel.FeatureFlag prereqOfFlag;
        public final LDContext context;
        public final EvalResult result;

        public PrereqEval(DataModel.FeatureFlag flag, DataModel.FeatureFlag prereqOfFlag, LDContext context, EvalResult result) {
            this.flag = flag;
            this.prereqOfFlag = prereqOfFlag;
            this.context = context;
            this.result = result;
        }
    }

    public static class EvaluatorBuilder {
        HashMap<String, DataModel.FeatureFlag> flagMap = new HashMap();
        HashMap<String, DataModel.Segment> segmentMap = new HashMap();
        HashMap<String, BigSegmentStoreWrapper.BigSegmentsQueryResult> bigSegmentMap = new HashMap();
        private final LDLogger logger;

        EvaluatorBuilder() {
            this(LDLogger.withAdapter((LDLogAdapter)Logs.none(), (String)""));
        }

        EvaluatorBuilder(LDLogger logger) {
            this.logger = logger;
        }

        public Evaluator build() {
            return new Evaluator(new Evaluator.Getters(){

                public DataModel.FeatureFlag getFlag(String key) {
                    if (!flagMap.containsKey(key)) {
                        throw new IllegalStateException("Evaluator unexpectedly tried to query flag: " + key);
                    }
                    return flagMap.get(key);
                }

                public DataModel.Segment getSegment(String key) {
                    if (!segmentMap.containsKey(key)) {
                        throw new IllegalStateException("Evaluator unexpectedly tried to query segment: " + key);
                    }
                    return segmentMap.get(key);
                }

                public BigSegmentStoreWrapper.BigSegmentsQueryResult getBigSegments(String key) {
                    if (!bigSegmentMap.containsKey(key)) {
                        throw new IllegalStateException("Evaluator unexpectedly tried to query Big Segment: " + key);
                    }
                    return bigSegmentMap.get(key);
                }
            }, this.logger);
        }

        public EvaluatorBuilder withStoredFlags(DataModel.FeatureFlag ... flags) {
            for (DataModel.FeatureFlag f : flags) {
                this.flagMap.put(f.getKey(), f);
            }
            return this;
        }

        public EvaluatorBuilder withNonexistentFlag(String nonexistentFlagKey) {
            this.flagMap.put(nonexistentFlagKey, null);
            return this;
        }

        public EvaluatorBuilder withStoredSegments(DataModel.Segment ... segments) {
            for (DataModel.Segment s : segments) {
                this.segmentMap.put(s.getKey(), s);
            }
            return this;
        }

        public EvaluatorBuilder withNonexistentSegment(String nonexistentSegmentKey) {
            this.segmentMap.put(nonexistentSegmentKey, null);
            return this;
        }

        public EvaluatorBuilder withBigSegmentQueryResult(String userKey, BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult) {
            this.bigSegmentMap.put(userKey, queryResult);
            return this;
        }
    }
}

