/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.sdk.json.LDJackson;
import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.testhelpers.JsonAssertions;
import com.launchdarkly.testhelpers.TypeBehavior;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class FeatureFlagsStateTest {
    @Test
    public void canGetFlagValue() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[0]).add("key", LDValue.of((String)"value"), Integer.valueOf(1), null, 10, false, null).build();
        Assert.assertEquals((Object)LDValue.of((String)"value"), (Object)state.getFlagValue("key"));
    }

    @Test
    public void unknownFlagReturnsNullValue() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[0]).build();
        Assert.assertNull((Object)state.getFlagValue("key"));
    }

    @Test
    public void canGetFlagReason() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).add("key", LDValue.of((String)"value"), Integer.valueOf(1), EvaluationReason.off(), 10, false, null).build();
        Assert.assertEquals((Object)EvaluationReason.off(), (Object)state.getFlagReason("key"));
    }

    @Test
    public void unknownFlagReturnsNullReason() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[0]).build();
        Assert.assertNull((Object)state.getFlagReason("key"));
    }

    @Test
    public void reasonIsNullIfReasonsWereNotRecorded() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[0]).add("key", LDValue.of((String)"value"), Integer.valueOf(1), EvaluationReason.off(), 10, false, null).build();
        Assert.assertNull((Object)state.getFlagReason("key"));
    }

    @Test
    public void flagIsTreatedAsTrackedIfDebugEventsUntilDateIsInFuture() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS, FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS}).add("key", LDValue.of((String)"value"), Integer.valueOf(1), EvaluationReason.off(), 10, false, Long.valueOf(System.currentTimeMillis() + 1000000L)).build();
        Assert.assertNotNull((Object)state.getFlagReason("key"));
    }

    @Test
    public void flagIsNotTreatedAsTrackedIfDebugEventsUntilDateIsInPast() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS, FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS}).add("key", LDValue.of((String)"value"), Integer.valueOf(1), EvaluationReason.off(), 10, false, Long.valueOf(System.currentTimeMillis() - 1000000L)).build();
        Assert.assertNull((Object)state.getFlagReason("key"));
    }

    @Test
    public void flagCanHaveNullValue() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[0]).add("key", LDValue.ofNull(), Integer.valueOf(1), null, 10, false, null).build();
        Assert.assertEquals((Object)LDValue.ofNull(), (Object)state.getFlagValue("key"));
    }

    @Test
    public void canConvertToValuesMap() {
        FeatureFlagsState state = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[0]).add("key1", LDValue.of((String)"value1"), Integer.valueOf(0), null, 10, false, null).add("key2", LDValue.of((String)"value2"), Integer.valueOf(1), null, 10, false, null).build();
        ImmutableMap expected = ImmutableMap.of((Object)"key1", (Object)LDValue.of((String)"value1"), (Object)"key2", (Object)LDValue.of((String)"value2"));
        Assert.assertEquals((Object)expected, (Object)state.toValuesMap());
    }

    @Test
    public void equalInstancesAreEqual() {
        FeatureFlagsState justOneFlag = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).add("key1", LDValue.of((String)"value1"), Integer.valueOf(0), EvaluationReason.off(), 10, false, null).build();
        FeatureFlagsState sameFlagsDifferentInstances1 = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).add("key1", LDValue.of((String)"value1"), Integer.valueOf(0), EvaluationReason.off(), 10, false, null).add("key2", LDValue.of((String)"value2"), Integer.valueOf(1), EvaluationReason.fallthrough(), 10, false, null).build();
        FeatureFlagsState sameFlagsDifferentInstances2 = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).add("key1", LDValue.of((String)"value1"), Integer.valueOf(0), EvaluationReason.off(), 10, false, null).add("key2", LDValue.of((String)"value2"), Integer.valueOf(1), EvaluationReason.fallthrough(), 10, false, null).build();
        FeatureFlagsState sameFlagsDifferentMetadata = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).add("key1", LDValue.of((String)"value1"), Integer.valueOf(1), EvaluationReason.off(), 10, false, null).add("key2", LDValue.of((String)"value2"), Integer.valueOf(1), EvaluationReason.fallthrough(), 10, false, null).build();
        FeatureFlagsState noFlagsButValid = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).build();
        FeatureFlagsState noFlagsAndNotValid = FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).valid(false).build();
        Assert.assertEquals((Object)sameFlagsDifferentInstances1, (Object)sameFlagsDifferentInstances2);
        Assert.assertEquals((long)sameFlagsDifferentInstances1.hashCode(), (long)sameFlagsDifferentInstances2.hashCode());
        Assert.assertNotEquals((Object)justOneFlag, (Object)sameFlagsDifferentInstances1);
        Assert.assertNotEquals((Object)sameFlagsDifferentInstances1, (Object)sameFlagsDifferentMetadata);
        Assert.assertNotEquals((Object)noFlagsButValid, (Object)noFlagsAndNotValid);
        Assert.assertNotEquals((Object)noFlagsButValid, (Object)"");
    }

    @Test
    public void equalMetadataInstancesAreEqual() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (LDValue value : new LDValue[]{LDValue.of((int)1), LDValue.of((int)2)}) {
            for (Integer variation : new Integer[]{null, 0, 1}) {
                for (EvaluationReason reason : new EvaluationReason[]{null, EvaluationReason.off(), EvaluationReason.fallthrough()}) {
                    for (Integer version : new Integer[]{null, 10, 11}) {
                        for (boolean trackEvents : new boolean[]{false, true}) {
                            for (boolean trackReason : new boolean[]{false, true}) {
                                for (Long debugEventsUntilDate : new Long[]{null, 1000L, 1001L}) {
                                    allPermutations.add(() -> new FeatureFlagsState.FlagMetadata(value, variation, reason, version, trackEvents, trackReason, debugEventsUntilDate));
                                }
                            }
                        }
                    }
                }
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void optionsHaveHumanReadableNames() {
        Assert.assertEquals((Object)"CLIENT_SIDE_ONLY", (Object)FlagsStateOption.CLIENT_SIDE_ONLY.toString());
        Assert.assertEquals((Object)"WITH_REASONS", (Object)FlagsStateOption.WITH_REASONS.toString());
        Assert.assertEquals((Object)"DETAILS_ONLY_FOR_TRACKED_FLAGS", (Object)FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS.toString());
    }

    @Test
    public void canConvertToJson() {
        String actualJsonString = JsonSerialization.serialize((JsonSerializable)FeatureFlagsStateTest.makeInstanceForSerialization());
        JsonAssertions.assertJsonEquals((String)FeatureFlagsStateTest.makeExpectedJsonSerialization(), (String)actualJsonString);
    }

    @Test
    public void canConvertFromJson() throws SerializationException {
        FeatureFlagsState state = (FeatureFlagsState)JsonSerialization.deserialize((String)FeatureFlagsStateTest.makeExpectedJsonSerialization(), FeatureFlagsState.class);
        Assert.assertEquals((Object)FeatureFlagsStateTest.makeInstanceForSerialization(), (Object)state);
    }

    private static FeatureFlagsState makeInstanceForSerialization() {
        EvalResult eval1 = EvalResult.of((LDValue)LDValue.of((String)"value1"), (int)0, (EvaluationReason)EvaluationReason.off());
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("key1").version(100).trackEvents(false).build();
        EvalResult eval2 = EvalResult.of((LDValue)LDValue.of((String)"value2"), (int)1, (EvaluationReason)EvaluationReason.fallthrough());
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("key2").version(200).trackEvents(true).debugEventsUntilDate(1000L).build();
        EvalResult eval3 = EvalResult.of((LDValue)LDValue.ofNull(), (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.MALFORMED_FLAG));
        DataModel.FeatureFlag flag3 = ModelBuilders.flagBuilder("key3").version(300).build();
        return FeatureFlagsState.builder((FlagsStateOption[])new FlagsStateOption[]{FlagsStateOption.WITH_REASONS}).addFlag(flag1, eval1).addFlag(flag2, eval2).addFlag(flag3, eval3).build();
    }

    private static String makeExpectedJsonSerialization() {
        return "{\"key1\":\"value1\",\"key2\":\"value2\",\"key3\":null,\"$flagsState\":{\"key1\":{\"variation\":0,\"version\":100,\"reason\":{\"kind\":\"OFF\"}},\"key2\":{\"variation\":1,\"version\":200,\"reason\":{\"kind\":\"FALLTHROUGH\"},\"trackEvents\":true,\"debugEventsUntilDate\":1000},\"key3\":{\"version\":300,\"reason\":{\"kind\":\"ERROR\",\"errorKind\":\"MALFORMED_FLAG\"}}},\"$valid\":true}";
    }

    @Test
    public void canSerializeAndDeserializeWithJackson() throws Exception {
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.registerModule(LDJackson.module());
        String actualJsonString = jacksonMapper.writeValueAsString((Object)FeatureFlagsStateTest.makeInstanceForSerialization());
        JsonAssertions.assertJsonEquals((String)FeatureFlagsStateTest.makeExpectedJsonSerialization(), (String)actualJsonString);
        FeatureFlagsState state = (FeatureFlagsState)jacksonMapper.readValue(FeatureFlagsStateTest.makeExpectedJsonSerialization(), FeatureFlagsState.class);
        Assert.assertEquals((Object)FeatureFlagsStateTest.makeInstanceForSerialization(), (Object)state);
    }
}

