/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.FlagTrackerImpl;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeEvent;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class FlagTrackerImplTest
extends BaseTest {
    @Test
    public void flagChangeListeners() throws Exception {
        String flagKey = "flagkey";
        EventBroadcasterImpl broadcaster = EventBroadcasterImpl.forFlagChangeEvents((ExecutorService)TestComponents.sharedExecutor, (LDLogger)this.testLogger);
        FlagTrackerImpl tracker = new FlagTrackerImpl(broadcaster, null);
        LinkedBlockingQueue eventSink1 = new LinkedBlockingQueue();
        LinkedBlockingQueue eventSink2 = new LinkedBlockingQueue();
        FlagChangeListener listener1 = eventSink1::add;
        FlagChangeListener listener2 = eventSink2::add;
        tracker.addFlagChangeListener(listener1);
        tracker.addFlagChangeListener(listener2);
        ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        broadcaster.broadcast((Object)new FlagChangeEvent(flagKey));
        FlagChangeEvent event1 = (FlagChangeEvent)ConcurrentHelpers.awaitValue(eventSink1, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        FlagChangeEvent event2 = (FlagChangeEvent)ConcurrentHelpers.awaitValue(eventSink2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)event1.getKey(), (Matcher)Matchers.equalTo((Object)"flagkey"));
        MatcherAssert.assertThat((Object)event2.getKey(), (Matcher)Matchers.equalTo((Object)"flagkey"));
        ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        tracker.removeFlagChangeListener(listener1);
        broadcaster.broadcast((Object)new FlagChangeEvent(flagKey));
        FlagChangeEvent event3 = (FlagChangeEvent)ConcurrentHelpers.awaitValue(eventSink2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)event3.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
        ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void flagValueChangeListener() throws Exception {
        String flagKey = "important-flag";
        LDContext user = LDContext.create((String)"important-user");
        LDUser userAsOldUserType = new LDUser(user.getKey());
        LDContext otherUser = LDContext.create((String)"unimportant-user");
        EventBroadcasterImpl broadcaster = EventBroadcasterImpl.forFlagChangeEvents((ExecutorService)TestComponents.sharedExecutor, (LDLogger)this.testLogger);
        HashMap<AbstractMap.SimpleEntry<String, LDContext>, LDValue> resultMap = new HashMap<AbstractMap.SimpleEntry<String, LDContext>, LDValue>();
        FlagTrackerImpl tracker = new FlagTrackerImpl(broadcaster, (k, u) -> LDValue.normalize((LDValue)((LDValue)resultMap.get(new AbstractMap.SimpleEntry<String, LDContext>((String)k, (LDContext)u)))));
        resultMap.put(new AbstractMap.SimpleEntry<String, LDContext>(flagKey, user), LDValue.of((boolean)false));
        resultMap.put(new AbstractMap.SimpleEntry<String, LDContext>(flagKey, otherUser), LDValue.of((boolean)false));
        LinkedBlockingQueue eventSink1 = new LinkedBlockingQueue();
        LinkedBlockingQueue eventSink1WithOldUser = new LinkedBlockingQueue();
        LinkedBlockingQueue eventSink2 = new LinkedBlockingQueue();
        LinkedBlockingQueue eventSink3 = new LinkedBlockingQueue();
        tracker.addFlagValueChangeListener(flagKey, user, eventSink1::add);
        tracker.addFlagValueChangeListener(flagKey, userAsOldUserType, eventSink1WithOldUser::add);
        FlagChangeListener listener2 = tracker.addFlagValueChangeListener(flagKey, user, eventSink2::add);
        tracker.removeFlagChangeListener(listener2);
        tracker.addFlagValueChangeListener(flagKey, otherUser, eventSink3::add);
        ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ConcurrentHelpers.assertNoMoreValues(eventSink3, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        resultMap.put(new AbstractMap.SimpleEntry<String, LDContext>(flagKey, user), LDValue.of((boolean)true));
        broadcaster.broadcast((Object)new FlagChangeEvent(flagKey));
        FlagValueChangeEvent event1 = (FlagValueChangeEvent)ConcurrentHelpers.awaitValue(eventSink1, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)event1.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
        MatcherAssert.assertThat((Object)event1.getOldValue(), (Matcher)Matchers.equalTo((Object)LDValue.of((boolean)false)));
        MatcherAssert.assertThat((Object)event1.getNewValue(), (Matcher)Matchers.equalTo((Object)LDValue.of((boolean)true)));
        ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        FlagValueChangeEvent event1a = (FlagValueChangeEvent)ConcurrentHelpers.awaitValue(eventSink1WithOldUser, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)event1a.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
        MatcherAssert.assertThat((Object)event1a.getOldValue(), (Matcher)Matchers.equalTo((Object)LDValue.of((boolean)false)));
        MatcherAssert.assertThat((Object)event1a.getNewValue(), (Matcher)Matchers.equalTo((Object)LDValue.of((boolean)true)));
        ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

