/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.annotations.JsonAdapter;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import org.junit.Assert;
import org.junit.Test;

public class JsonHelpersTest {
    @Test
    public void serialize() {
        MySerializableClass instance = new MySerializableClass();
        instance.value = 3;
        Assert.assertEquals((Object)"{\"value\":3}", (Object)JsonHelpers.serialize((Object)instance));
    }

    @Test
    public void deserialize() {
        MySerializableClass instance = (MySerializableClass)JsonHelpers.deserialize((String)"{\"value\":3}", MySerializableClass.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)3L, (long)instance.value);
    }

    @Test(expected=SerializationException.class)
    public void deserializeInvalidJson() {
        JsonHelpers.deserialize((String)"{\"value", MySerializableClass.class);
    }

    @Test
    public void postProcessingTypeAdapterFactoryCallsAfterDeserializedIfApplicable() {
        MyClassWithAnAfterDeserializeMethod instance = (MyClassWithAnAfterDeserializeMethod)JsonHelpers.gsonInstance().fromJson("{}", MyClassWithAnAfterDeserializeMethod.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)instance.wasCalled);
    }

    @Test
    public void postProcessingTypeAdapterFactoryDoesNothingIfClassDoesNotImplementInterface() {
        SomeOtherClass instance = (SomeOtherClass)JsonHelpers.gsonInstance().fromJson("{}", SomeOtherClass.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void postProcessingTypeAdapterFactoryDoesNotAffectSerialization() {
        MyClassWithAnAfterDeserializeMethod instance = new MyClassWithAnAfterDeserializeMethod();
        String json = JsonHelpers.gsonInstance().toJson((Object)instance);
        Assert.assertEquals((Object)"{\"wasCalled\":false}", (Object)json);
    }

    @JsonAdapter(value=JsonHelpers.PostProcessingDeserializableTypeAdapterFactory.class)
    static class SomeOtherClass {
        SomeOtherClass() {
        }
    }

    @JsonAdapter(value=JsonHelpers.PostProcessingDeserializableTypeAdapterFactory.class)
    static class MyClassWithAnAfterDeserializeMethod
    implements JsonHelpers.PostProcessingDeserializable {
        boolean wasCalled = false;

        MyClassWithAnAfterDeserializeMethod() {
        }

        public void afterDeserialized() {
            this.wasCalled = true;
        }
    }

    static class MySerializableClass {
        int value;

        MySerializableClass() {
        }
    }
}

