/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.testhelpers.httptest.Handler;
import com.launchdarkly.testhelpers.httptest.Handlers;
import com.launchdarkly.testhelpers.httptest.HttpServer;
import com.launchdarkly.testhelpers.httptest.RequestInfo;
import com.launchdarkly.testhelpers.httptest.SpecialHttpConfigurations;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LDClientEndToEndTest
extends BaseTest {
    private static final Gson gson = new Gson();
    private static final String sdkKey = "sdk-key";
    private static final String flagKey = "flag1";
    private static final DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag1").offVariation(0).variations(LDValue.of((boolean)true)).build();
    private static final LDContext user = LDContext.create((String)"user-key");

    private static Handler makePollingSuccessResponse() {
        return Handlers.bodyJson((String)LDClientEndToEndTest.makeAllDataJson());
    }

    private static Handler makeStreamingSuccessResponse() {
        String streamData = "event: put\ndata: {\"data\":" + LDClientEndToEndTest.makeAllDataJson() + "}";
        return Handlers.all((Handler[])new Handler[]{Handlers.SSE.start(), Handlers.SSE.event((String)streamData), Handlers.SSE.leaveOpen()});
    }

    private static Handler makeInvalidSdkKeyResponse() {
        return Handlers.status((int)401);
    }

    private static Handler makeServiceUnavailableResponse() {
        return Handlers.status((int)503);
    }

    @Test
    public void clientStartsInPollingMode() throws Exception {
        try (HttpServer server = HttpServer.start((Handler)LDClientEndToEndTest.makePollingSuccessResponse());){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().polling(server.getUri())).dataSource((ComponentConfigurer)Components.pollingDataSource()).events(Components.noEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertTrue((boolean)client.isInitialized());
                Assert.assertTrue((boolean)client.boolVariation(flagKey, user, false));
            }
        }
    }

    @Test
    public void clientStartsInPollingModeAfterRecoverableError() throws Exception {
        Handler errorThenSuccess = Handlers.sequential((Handler[])new Handler[]{LDClientEndToEndTest.makeServiceUnavailableResponse(), LDClientEndToEndTest.makePollingSuccessResponse()});
        try (HttpServer server = HttpServer.start((Handler)errorThenSuccess);){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().polling(server.getUri())).dataSource((ComponentConfigurer)Components.pollingDataSourceInternal().pollIntervalWithNoMinimum(Duration.ofMillis(5L))).events(Components.noEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertTrue((boolean)client.isInitialized());
                Assert.assertTrue((boolean)client.boolVariation(flagKey, user, false));
            }
        }
    }

    @Test
    public void clientFailsInPollingModeWith401Error() throws Exception {
        try (HttpServer server = HttpServer.start((Handler)LDClientEndToEndTest.makeInvalidSdkKeyResponse());){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().polling(server.getUri())).dataSource((ComponentConfigurer)Components.pollingDataSourceInternal().pollIntervalWithNoMinimum(Duration.ofMillis(5L))).events(Components.noEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertFalse((boolean)client.isInitialized());
                Assert.assertFalse((boolean)client.boolVariation(flagKey, user, false));
                server.getRecorder().requireRequest();
                server.getRecorder().requireNoRequests(Duration.ofMillis(100L));
            }
        }
    }

    @Test
    public void testPollingModeSpecialHttpConfigurations() throws Exception {
        LDClientEndToEndTest.testWithSpecialHttpConfigurations(LDClientEndToEndTest.makePollingSuccessResponse(), (serverUri, httpConfig) -> this.baseConfig().serviceEndpoints(Components.serviceEndpoints().polling(serverUri)).dataSource((ComponentConfigurer)Components.pollingDataSource()).events(Components.noEvents()).http(httpConfig));
    }

    @Test
    public void clientStartsInStreamingMode() throws Exception {
        try (HttpServer server = HttpServer.start((Handler)LDClientEndToEndTest.makeStreamingSuccessResponse());){
            LDConfig config = this.baseConfig().dataSource((ComponentConfigurer)Components.streamingDataSource()).serviceEndpoints(Components.serviceEndpoints().streaming(server.getUri())).events(Components.noEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertTrue((boolean)client.isInitialized());
                Assert.assertTrue((boolean)client.boolVariation(flagKey, user, false));
            }
        }
    }

    @Test
    public void clientStartsInStreamingModeAfterRecoverableError() throws Exception {
        Handler errorThenStream = Handlers.sequential((Handler[])new Handler[]{LDClientEndToEndTest.makeServiceUnavailableResponse(), LDClientEndToEndTest.makeStreamingSuccessResponse()});
        try (HttpServer server = HttpServer.start((Handler)errorThenStream);){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().streaming(server.getUri())).dataSource((ComponentConfigurer)Components.streamingDataSource().initialReconnectDelay(Duration.ZERO)).events(Components.noEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertTrue((boolean)client.isInitialized());
                Assert.assertTrue((boolean)client.boolVariation(flagKey, user, false));
                server.getRecorder().requireRequest();
                server.getRecorder().requireRequest();
                server.getRecorder().requireNoRequests(Duration.ofMillis(100L));
            }
        }
    }

    @Test
    public void clientFailsInStreamingModeWith401Error() throws Exception {
        try (HttpServer server = HttpServer.start((Handler)LDClientEndToEndTest.makeInvalidSdkKeyResponse());){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().streaming(server.getUri())).dataSource((ComponentConfigurer)Components.streamingDataSource().initialReconnectDelay(Duration.ZERO)).events(Components.noEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertFalse((boolean)client.isInitialized());
                Assert.assertFalse((boolean)client.boolVariation(flagKey, user, false));
                LinkedBlockingQueue statuses = new LinkedBlockingQueue();
                client.getDataSourceStatusProvider().addStatusListener(statuses::add);
                Thread.sleep(100L);
                MatcherAssert.assertThat((Object)client.getDataSourceStatusProvider().getStatus().getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.OFF));
                while (!statuses.isEmpty()) {
                    MatcherAssert.assertThat((Object)((DataSourceStatusProvider.Status)statuses.take()).getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.OFF));
                }
                MatcherAssert.assertThat((Object)statuses.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
                server.getRecorder().requireRequest();
                server.getRecorder().requireNoRequests(Duration.ofMillis(100L));
            }
        }
    }

    @Test
    public void testStreamingModeSpecialHttpConfigurations() throws Exception {
        LDClientEndToEndTest.testWithSpecialHttpConfigurations(LDClientEndToEndTest.makeStreamingSuccessResponse(), (serverUri, httpConfig) -> this.baseConfig().serviceEndpoints(Components.serviceEndpoints().streaming(serverUri)).dataSource((ComponentConfigurer)Components.streamingDataSource()).events(Components.noEvents()).http(httpConfig));
    }

    @Test
    public void clientSendsAnalyticsEvent() throws Exception {
        Handler resp = Handlers.status((int)202);
        try (HttpServer server = HttpServer.start((Handler)resp);){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().events(server.getUri())).dataSource(Components.externalUpdatesOnly()).diagnosticOptOut(true).events((ComponentConfigurer)Components.sendEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertTrue((boolean)client.isInitialized());
                client.identify(user);
            }
            RequestInfo req = server.getRecorder().requireRequest();
            Assert.assertEquals((Object)"/bulk", (Object)req.getPath());
        }
    }

    @Test
    public void clientSendsDiagnosticEvent() throws Exception {
        Handler resp = Handlers.status((int)202);
        try (HttpServer server = HttpServer.start((Handler)resp);){
            LDConfig config = this.baseConfig().serviceEndpoints(Components.serviceEndpoints().events(server.getUri())).dataSource(Components.externalUpdatesOnly()).events((ComponentConfigurer)Components.sendEvents()).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                Assert.assertTrue((boolean)client.isInitialized());
                RequestInfo req = server.getRecorder().requireRequest();
                Assert.assertEquals((Object)"/diagnostic", (Object)req.getPath());
            }
        }
    }

    private static void testWithSpecialHttpConfigurations(Handler handler, BiFunction<URI, ComponentConfigurer<HttpConfiguration>, LDConfig.Builder> makeConfig) throws Exception {
        SpecialHttpConfigurations.testAll((Handler)handler, (serverUri, params) -> {
            LDConfig config = ((LDConfig.Builder)makeConfig.apply(serverUri, (ComponentConfigurer<HttpConfiguration>)TestUtil.makeHttpConfigurationFromTestParams(params))).startWait(Duration.ofSeconds(10L)).build();
            try (LDClient client = new LDClient(sdkKey, config);){
                if (!client.isInitialized()) {
                    throw new IOException("client did not initialize successfully");
                }
                if (!client.boolVariation(flagKey, user, false)) {
                    throw new IOException("client said it initialized, but did not have correct flag data");
                }
            }
            return true;
        });
    }

    private static String makeAllDataJson() {
        JsonObject flagsData = new JsonObject();
        flagsData.add(flagKey, gson.toJsonTree((Object)flag));
        JsonObject allData = new JsonObject();
        allData.add("flags", (JsonElement)flagsData);
        allData.add("segments", (JsonElement)new JsonObject());
        return gson.toJson((JsonElement)allData);
    }
}

