/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LDClientEventTest
extends BaseTest {
    private static final LDContext context = LDContext.create((String)"userkey");
    private static final LDUser contextAsUser = new LDUser(context.getKey());
    private static final LDContext invalidContext = LDContext.create(null);
    private DataStore dataStore = TestComponents.initedDataStore();
    private TestComponents.TestEventProcessor eventSink = new TestComponents.TestEventProcessor();
    private LDConfig config = this.baseConfig().dataStore(TestComponents.specificComponent(this.dataStore)).events(TestComponents.specificComponent(this.eventSink)).build();
    private LDClientInterface client = new LDClient("SDK_KEY", this.config);

    @Test
    public void identifySendsEvent() throws Exception {
        this.client.identify(context);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Identify.class, e.getClass());
        Event.Identify ie = (Event.Identify)e;
        Assert.assertEquals((Object)context.getKey(), (Object)ie.getContext().getKey());
    }

    @Test
    public void identifySendsEventForOldUser() throws Exception {
        this.client.identify(contextAsUser);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Identify.class, e.getClass());
        Event.Identify ie = (Event.Identify)e;
        Assert.assertEquals((Object)contextAsUser.getKey(), (Object)ie.getContext().getKey());
    }

    @Test
    public void identifyWithNullContextOrUserDoesNotSendEvent() {
        this.client.identify((LDContext)null);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
        this.client.identify((LDUser)null);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
    }

    @Test
    public void identifyWithInvalidContextDoesNotSendEvent() {
        this.client.identify(invalidContext);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
    }

    @Test
    public void trackSendsEventWithoutData() throws Exception {
        this.client.track("eventkey", context);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Custom.class, e.getClass());
        Event.Custom ce = (Event.Custom)e;
        Assert.assertEquals((Object)context.getKey(), (Object)ce.getContext().getKey());
        Assert.assertEquals((Object)"eventkey", (Object)ce.getKey());
        Assert.assertEquals((Object)LDValue.ofNull(), (Object)ce.getData());
    }

    @Test
    public void trackSendsEventForOldUser() throws Exception {
        this.client.track("eventkey", contextAsUser);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Custom.class, e.getClass());
        Event.Custom ce = (Event.Custom)e;
        Assert.assertEquals((Object)contextAsUser.getKey(), (Object)ce.getContext().getKey());
        Assert.assertEquals((Object)"eventkey", (Object)ce.getKey());
        Assert.assertEquals((Object)LDValue.ofNull(), (Object)ce.getData());
    }

    @Test
    public void trackSendsEventWithData() throws Exception {
        LDValue data = LDValue.buildObject().put("thing", LDValue.of((String)"stuff")).build();
        this.client.trackData("eventkey", context, data);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Custom.class, e.getClass());
        Event.Custom ce = (Event.Custom)e;
        Assert.assertEquals((Object)context.getKey(), (Object)ce.getContext().getKey());
        Assert.assertEquals((Object)"eventkey", (Object)ce.getKey());
        Assert.assertEquals((Object)data, (Object)ce.getData());
    }

    @Test
    public void trackSendsEventWithDataForOldUser() throws Exception {
        LDValue data = LDValue.buildObject().put("thing", LDValue.of((String)"stuff")).build();
        this.client.trackData("eventkey", contextAsUser, data);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Custom.class, e.getClass());
        Event.Custom ce = (Event.Custom)e;
        Assert.assertEquals((Object)contextAsUser.getKey(), (Object)ce.getContext().getKey());
        Assert.assertEquals((Object)"eventkey", (Object)ce.getKey());
        Assert.assertEquals((Object)data, (Object)ce.getData());
    }

    @Test
    public void trackSendsEventWithDataAndMetricValue() throws Exception {
        LDValue data = LDValue.buildObject().put("thing", LDValue.of((String)"stuff")).build();
        double metricValue = 1.5;
        this.client.trackMetric("eventkey", context, data, metricValue);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Custom.class, e.getClass());
        Event.Custom ce = (Event.Custom)e;
        Assert.assertEquals((Object)context.getKey(), (Object)ce.getContext().getKey());
        Assert.assertEquals((Object)"eventkey", (Object)ce.getKey());
        Assert.assertEquals((Object)data, (Object)ce.getData());
        Assert.assertEquals((Object)metricValue, (Object)ce.getMetricValue());
    }

    @Test
    public void trackSendsEventWithDataAndMetricValueForOldUser() throws Exception {
        LDValue data = LDValue.buildObject().put("thing", LDValue.of((String)"stuff")).build();
        double metricValue = 1.5;
        this.client.trackMetric("eventkey", contextAsUser, data, metricValue);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event e = this.eventSink.events.get(0);
        Assert.assertEquals(Event.Custom.class, e.getClass());
        Event.Custom ce = (Event.Custom)e;
        Assert.assertEquals((Object)contextAsUser.getKey(), (Object)ce.getContext().getKey());
        Assert.assertEquals((Object)"eventkey", (Object)ce.getKey());
        Assert.assertEquals((Object)data, (Object)ce.getData());
        Assert.assertEquals((Object)metricValue, (Object)ce.getMetricValue());
    }

    @Test
    public void trackWithNullContextOrUserDoesNotSendEvent() {
        this.client.track("eventkey", (LDContext)null);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
        this.client.track("eventkey", (LDUser)null);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
        this.client.trackData("eventkey", (LDContext)null, LDValue.of((int)1));
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
        this.client.trackMetric("eventkey", (LDContext)null, LDValue.of((int)1), 1.5);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
    }

    @Test
    public void trackWithInvalidContextDoesNotSendEvent() {
        this.client.track("eventkey", invalidContext);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
        this.client.trackData("eventkey", invalidContext, LDValue.of((int)1));
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
        this.client.trackMetric("eventkey", invalidContext, LDValue.of((int)1), 1.5);
        Assert.assertEquals((long)0L, (long)this.eventSink.events.size());
    }

    @Test
    public void boolVariationSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((boolean)true));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.boolVariation("key", context, false);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((boolean)true), LDValue.of((boolean)false), null, null);
    }

    @Test
    public void boolVariationSendsEventForUnknownFlag() throws Exception {
        this.client.boolVariation("key", context, false);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((boolean)false), null, null);
    }

    @Test
    public void boolVariationDetailSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((boolean)true));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.boolVariationDetail("key", context, false);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((boolean)true), LDValue.of((boolean)false), null, EvaluationReason.off());
    }

    @Test
    public void boolVariationDetailSendsEventForUnknownFlag() throws Exception {
        this.client.boolVariationDetail("key", context, false);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((boolean)false), null, EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
    }

    @Test
    public void intVariationSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((int)2));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.intVariation("key", context, 1);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((int)2), LDValue.of((int)1), null, null);
    }

    @Test
    public void intVariationSendsEventForUnknownFlag() throws Exception {
        this.client.intVariation("key", context, 1);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((int)1), null, null);
    }

    @Test
    public void intVariationDetailSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((int)2));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.intVariationDetail("key", context, 1);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((int)2), LDValue.of((int)1), null, EvaluationReason.off());
    }

    @Test
    public void intVariationDetailSendsEventForUnknownFlag() throws Exception {
        this.client.intVariationDetail("key", context, 1);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((int)1), null, EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
    }

    @Test
    public void doubleVariationSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((double)2.5));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.doubleVariation("key", context, 1.0);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((double)2.5), LDValue.of((double)1.0), null, null);
    }

    @Test
    public void doubleVariationSendsEventForUnknownFlag() throws Exception {
        this.client.doubleVariation("key", context, 1.0);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((double)1.0), null, null);
    }

    @Test
    public void doubleVariationDetailSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((double)2.5));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.doubleVariationDetail("key", context, 1.0);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((double)2.5), LDValue.of((double)1.0), null, EvaluationReason.off());
    }

    @Test
    public void doubleVariationDetailSendsEventForUnknownFlag() throws Exception {
        this.client.doubleVariationDetail("key", context, 1.0);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((double)1.0), null, EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
    }

    @Test
    public void stringVariationSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((String)"b"));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariation("key", context, "a");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((String)"b"), LDValue.of((String)"a"), null, null);
    }

    @Test
    public void stringVariationSendsEventForUnknownFlag() throws Exception {
        this.client.stringVariation("key", context, "a");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((String)"a"), null, null);
    }

    @Test
    public void stringVariationDetailSendsEvent() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((String)"b"));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariationDetail("key", context, "a");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, LDValue.of((String)"b"), LDValue.of((String)"a"), null, EvaluationReason.off());
    }

    @Test
    public void stringVariationDetailSendsEventForUnknownFlag() throws Exception {
        this.client.stringVariationDetail("key", context, "a");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", LDValue.of((String)"a"), null, EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
    }

    @Test
    public void jsonValueVariationDetailSendsEvent() throws Exception {
        LDValue data = LDValue.buildObject().put("thing", LDValue.of((String)"stuff")).build();
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", data);
        TestUtil.upsertFlag(this.dataStore, flag);
        LDValue defaultVal = LDValue.of((int)42);
        this.client.jsonValueVariationDetail("key", context, defaultVal);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), flag, data, defaultVal, null, EvaluationReason.off());
    }

    @Test
    public void jsonValueVariationDetailSendsEventForUnknownFlag() throws Exception {
        LDValue defaultVal = LDValue.of((int)42);
        this.client.jsonValueVariationDetail("key", context, defaultVal);
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkUnknownFeatureEvent(this.eventSink.events.get(0), "key", defaultVal, null, EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
    }

    @Test
    public void variationDoesNotSendEventForInvalidContextOrNullUser() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((String)"value"));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.boolVariation(flag.getKey(), invalidContext, false);
        MatcherAssert.assertThat(this.eventSink.events, (Matcher)Matchers.empty());
        this.client.boolVariation(flag.getKey(), (LDUser)null, false);
        MatcherAssert.assertThat(this.eventSink.events, (Matcher)Matchers.empty());
        this.client.boolVariationDetail(flag.getKey(), invalidContext, false);
        MatcherAssert.assertThat(this.eventSink.events, (Matcher)Matchers.empty());
        this.client.boolVariationDetail(flag.getKey(), (LDUser)null, false);
        MatcherAssert.assertThat(this.eventSink.events, (Matcher)Matchers.empty());
    }

    @Test
    public void eventTrackingAndReasonCanBeForcedForRule() throws Exception {
        DataModel.Clause clause = ModelBuilders.clauseMatchingContext(context);
        DataModel.Rule rule = ModelBuilders.ruleBuilder().id("id").clauses(clause).variation(1).trackEvents(true).build();
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag").on(true).rules(rule).offVariation(0).variations(LDValue.of((String)"off"), LDValue.of((String)"on")).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariation("flag", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event.FeatureRequest event = (Event.FeatureRequest)this.eventSink.events.get(0);
        Assert.assertTrue((boolean)event.isTrackEvents());
        Assert.assertEquals((Object)EvaluationReason.ruleMatch((int)0, (String)"id"), (Object)event.getReason());
    }

    @Test
    public void eventTrackingAndReasonAreNotForcedIfFlagIsNotSetForMatchingRule() throws Exception {
        DataModel.Clause clause0 = ModelBuilders.clauseNotMatchingContext(context);
        DataModel.Clause clause1 = ModelBuilders.clauseMatchingContext(context);
        DataModel.Rule rule0 = ModelBuilders.ruleBuilder().id("id0").clauses(clause0).variation(1).trackEvents(true).build();
        DataModel.Rule rule1 = ModelBuilders.ruleBuilder().id("id1").clauses(clause1).variation(1).trackEvents(false).build();
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag").on(true).rules(rule0, rule1).offVariation(0).variations(LDValue.of((String)"off"), LDValue.of((String)"on")).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariation("flag", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event.FeatureRequest event = (Event.FeatureRequest)this.eventSink.events.get(0);
        Assert.assertFalse((boolean)event.isTrackEvents());
        Assert.assertNull((Object)event.getReason());
    }

    @Test
    public void eventTrackingAndReasonCanBeForcedForFallthrough() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag").on(true).fallthrough(new DataModel.VariationOrRollout(Integer.valueOf(0), null)).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).trackEventsFallthrough(true).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariation("flag", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event.FeatureRequest event = (Event.FeatureRequest)this.eventSink.events.get(0);
        Assert.assertTrue((boolean)event.isTrackEvents());
        Assert.assertEquals((Object)EvaluationReason.fallthrough(), (Object)event.getReason());
    }

    @Test
    public void eventTrackingAndReasonAreNotForcedForFallthroughIfFlagIsNotSet() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag").on(true).fallthrough(new DataModel.VariationOrRollout(Integer.valueOf(0), null)).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).trackEventsFallthrough(false).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariation("flag", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event.FeatureRequest event = (Event.FeatureRequest)this.eventSink.events.get(0);
        Assert.assertFalse((boolean)event.isTrackEvents());
        Assert.assertNull((Object)event.getReason());
    }

    @Test
    public void eventTrackingAndReasonAreNotForcedForFallthroughIfReasonIsNotFallthrough() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag").on(false).offVariation(1).fallthrough(new DataModel.VariationOrRollout(Integer.valueOf(0), null)).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).trackEventsFallthrough(true).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        this.client.stringVariation("flag", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        Event.FeatureRequest event = (Event.FeatureRequest)this.eventSink.events.get(0);
        Assert.assertFalse((boolean)event.isTrackEvents());
        Assert.assertNull((Object)event.getReason());
    }

    @Test
    public void eventIsSentForExistingPrererequisiteFlag() throws Exception {
        DataModel.FeatureFlag f0 = ModelBuilders.flagBuilder("feature0").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).version(1).build();
        DataModel.FeatureFlag f1 = ModelBuilders.flagBuilder("feature1").on(true).fallthrough(ModelBuilders.fallthroughVariation(1)).variations(LDValue.of((String)"nogo"), LDValue.of((String)"go")).version(2).build();
        TestUtil.upsertFlag(this.dataStore, f0);
        TestUtil.upsertFlag(this.dataStore, f1);
        this.client.stringVariation("feature0", context, "default");
        Assert.assertEquals((long)2L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), f1, LDValue.of((String)"go"), LDValue.ofNull(), "feature0", null);
        this.checkFeatureEvent(this.eventSink.events.get(1), f0, LDValue.of((String)"fall"), LDValue.of((String)"default"), null, null);
    }

    @Test
    public void eventIsSentWithReasonForExistingPrererequisiteFlag() throws Exception {
        DataModel.FeatureFlag f0 = ModelBuilders.flagBuilder("feature0").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).version(1).build();
        DataModel.FeatureFlag f1 = ModelBuilders.flagBuilder("feature1").on(true).fallthrough(ModelBuilders.fallthroughVariation(1)).variations(LDValue.of((String)"nogo"), LDValue.of((String)"go")).version(2).build();
        TestUtil.upsertFlag(this.dataStore, f0);
        TestUtil.upsertFlag(this.dataStore, f1);
        this.client.stringVariationDetail("feature0", context, "default");
        Assert.assertEquals((long)2L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), f1, LDValue.of((String)"go"), LDValue.ofNull(), "feature0", EvaluationReason.fallthrough());
        this.checkFeatureEvent(this.eventSink.events.get(1), f0, LDValue.of((String)"fall"), LDValue.of((String)"default"), null, EvaluationReason.fallthrough());
    }

    @Test
    public void eventIsNotSentForUnknownPrererequisiteFlag() throws Exception {
        DataModel.FeatureFlag f0 = ModelBuilders.flagBuilder("feature0").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).version(1).build();
        TestUtil.upsertFlag(this.dataStore, f0);
        this.client.stringVariation("feature0", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), f0, LDValue.of((String)"off"), LDValue.of((String)"default"), null, null);
    }

    @Test
    public void failureReasonIsGivenForUnknownPrererequisiteFlagIfDetailsWereRequested() throws Exception {
        DataModel.FeatureFlag f0 = ModelBuilders.flagBuilder("feature0").on(true).prerequisites(ModelBuilders.prerequisite("feature1", 1)).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((String)"fall"), LDValue.of((String)"off"), LDValue.of((String)"on")).version(1).build();
        TestUtil.upsertFlag(this.dataStore, f0);
        this.client.stringVariationDetail("feature0", context, "default");
        Assert.assertEquals((long)1L, (long)this.eventSink.events.size());
        this.checkFeatureEvent(this.eventSink.events.get(0), f0, LDValue.of((String)"off"), LDValue.of((String)"default"), null, EvaluationReason.prerequisiteFailed((String)"feature1"));
    }

    @Test
    public void canFlush() {
        Assert.assertEquals((long)0L, (long)this.eventSink.flushCount);
        this.client.flush();
        Assert.assertEquals((long)1L, (long)this.eventSink.flushCount);
    }

    @Test
    public void identifyWithEventsDisabledDoesNotCauseError() throws Exception {
        LDConfig config = this.baseConfig().events(Components.noEvents()).dataSource(Components.externalUpdatesOnly()).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            client.identify(context);
        }
    }

    @Test
    public void trackWithEventsDisabledDoesNotCauseError() throws Exception {
        LDConfig config = this.baseConfig().events(Components.noEvents()).dataSource(Components.externalUpdatesOnly()).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            client.track("event", context);
        }
    }

    @Test
    public void flushWithEventsDisabledDoesNotCauseError() throws Exception {
        LDConfig config = this.baseConfig().events(Components.noEvents()).dataSource(Components.externalUpdatesOnly()).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            client.flush();
        }
    }

    @Test
    public void allFlagsStateGeneratesNoEvaluationEvents() {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag").on(true).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((boolean)true), LDValue.of((boolean)false)).version(1).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[0]);
        MatcherAssert.assertThat((Object)state.toValuesMap(), (Matcher)Matchers.hasKey((Object)flag.getKey()));
        MatcherAssert.assertThat(this.eventSink.events, (Matcher)Matchers.empty());
    }

    @Test
    public void allFlagsStateGeneratesNoPrerequisiteEvaluationEvents() {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").on(true).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((boolean)true), LDValue.of((boolean)false)).version(1).build();
        DataModel.FeatureFlag flag0 = ModelBuilders.flagBuilder("flag0").on(true).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(1).variations(LDValue.of((boolean)true), LDValue.of((boolean)false)).prerequisites(new DataModel.Prerequisite(flag1.getKey(), 0)).version(1).build();
        TestUtil.upsertFlag(this.dataStore, flag1);
        TestUtil.upsertFlag(this.dataStore, flag0);
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[0]);
        MatcherAssert.assertThat((Object)state.toValuesMap(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)flag0.getKey()), (Matcher)Matchers.hasKey((Object)flag1.getKey())));
        MatcherAssert.assertThat(this.eventSink.events, (Matcher)Matchers.empty());
    }

    private void checkFeatureEvent(Event e, DataModel.FeatureFlag flag, LDValue value, LDValue defaultVal, String prereqOf, EvaluationReason reason) {
        Assert.assertEquals(Event.FeatureRequest.class, e.getClass());
        Event.FeatureRequest fe = (Event.FeatureRequest)e;
        Assert.assertEquals((Object)flag.getKey(), (Object)fe.getKey());
        Assert.assertEquals((Object)context.getKey(), (Object)fe.getContext().getKey());
        Assert.assertEquals((long)flag.getVersion(), (long)fe.getVersion());
        Assert.assertEquals((Object)value, (Object)fe.getValue());
        Assert.assertEquals((Object)defaultVal, (Object)fe.getDefaultVal());
        Assert.assertEquals((Object)prereqOf, (Object)fe.getPrereqOf());
        Assert.assertEquals((Object)reason, (Object)fe.getReason());
        Assert.assertEquals((Object)flag.isTrackEvents(), (Object)fe.isTrackEvents());
        Assert.assertEquals((Object)flag.getDebugEventsUntilDate(), (Object)fe.getDebugEventsUntilDate());
    }

    private void checkUnknownFeatureEvent(Event e, String key, LDValue defaultVal, String prereqOf, EvaluationReason reason) {
        Assert.assertEquals(Event.FeatureRequest.class, e.getClass());
        Event.FeatureRequest fe = (Event.FeatureRequest)e;
        Assert.assertEquals((Object)key, (Object)fe.getKey());
        Assert.assertEquals((Object)context.getKey(), (Object)fe.getContext().getKey());
        Assert.assertEquals((long)-1L, (long)fe.getVersion());
        Assert.assertEquals((long)-1L, (long)fe.getVariation());
        Assert.assertEquals((Object)defaultVal, (Object)fe.getValue());
        Assert.assertEquals((Object)defaultVal, (Object)fe.getDefaultVal());
        Assert.assertEquals((Object)prereqOf, (Object)fe.getPrereqOf());
        Assert.assertEquals((Object)reason, (Object)fe.getReason());
        Assert.assertFalse((boolean)fe.isTrackEvents());
        Assert.assertNull((Object)fe.getDebugEventsUntilDate());
    }
}

