/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DefaultEventProcessorWrapper;
import com.launchdarkly.sdk.server.DefaultFeatureRequestor;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.PollingProcessor;
import com.launchdarkly.sdk.server.StreamProcessor;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.MockPersistentDataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LDClientTest
extends BaseTest {
    private static final String SDK_KEY = "SDK_KEY";
    private DataSource dataSource;
    private EventProcessor eventProcessor;
    private Future<Void> initFuture;
    private LDClientInterface client;
    private final EasyMockSupport mocks = new EasyMockSupport();

    @Before
    public void before() {
        this.dataSource = (DataSource)this.mocks.createStrictMock(DataSource.class);
        this.eventProcessor = (EventProcessor)this.mocks.createStrictMock(EventProcessor.class);
        this.initFuture = (Future)this.mocks.createStrictMock(Future.class);
    }

    @Test
    public void constructorThrowsExceptionForNullSdkKey() throws Exception {
        try (LDClient client = new LDClient(null);){
            Assert.fail((String)"expected exception");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"sdkKey must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void constructorWithConfigThrowsExceptionForNullSdkKey() throws Exception {
        try (LDClient client = new LDClient(null, new LDConfig.Builder().build());){
            Assert.fail((String)"expected exception");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"sdkKey must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void constructorThrowsExceptionForSdkKeyWithControlCharacter() throws Exception {
        try (LDClient client = new LDClient("SDK_KEY\n");){
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)SDK_KEY)));
        }
    }

    @Test
    public void constructorWithConfigThrowsExceptionForSdkKeyWithControlCharacter() throws Exception {
        try (LDClient client = new LDClient("SDK_KEY\n", LDConfig.DEFAULT);){
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)SDK_KEY)));
        }
    }

    @Test
    public void constructorAllowsSdkKeyToBeEmpty() throws Exception {
        LDClient client = new LDClient("", this.baseConfig().build());
        client.close();
    }

    @Test
    public void constructorThrowsExceptionForNullConfig() throws Exception {
        try (LDClient client = new LDClient(SDK_KEY, null);){
            Assert.fail((String)"expected exception");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"config must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void clientHasDefaultEventProcessorWithDefaultConfig() throws Exception {
        LDConfig config = new LDConfig.Builder().dataSource(Components.externalUpdatesOnly()).diagnosticOptOut(true).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals(DefaultEventProcessorWrapper.class, client.eventProcessor.getClass());
        }
    }

    @Test
    public void clientHasDefaultEventProcessorWithSendEvents() throws Exception {
        LDConfig config = new LDConfig.Builder().dataSource(Components.externalUpdatesOnly()).events((ComponentConfigurer)Components.sendEvents()).diagnosticOptOut(true).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals(DefaultEventProcessorWrapper.class, client.eventProcessor.getClass());
        }
    }

    @Test
    public void clientHasNullEventProcessorWithNoEvents() throws Exception {
        LDConfig config = new LDConfig.Builder().dataSource(Components.externalUpdatesOnly()).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals(ComponentsImpl.NullEventProcessor.class, client.eventProcessor.getClass());
        }
    }

    @Test
    public void streamingClientHasStreamProcessor() throws Exception {
        LDConfig config = new LDConfig.Builder().serviceEndpoints(Components.serviceEndpoints().streaming("http://fake")).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals(StreamProcessor.class, client.dataSource.getClass());
        }
    }

    @Test
    public void canSetCustomStreamingEndpoint() throws Exception {
        URI su = URI.create("http://fake");
        LDConfig config = new LDConfig.Builder().serviceEndpoints(Components.serviceEndpoints().streaming(su)).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals((Object)su, (Object)((StreamProcessor)client.dataSource).streamUri);
        }
    }

    @Test
    public void pollingClientHasPollingProcessor() throws IOException {
        LDConfig config = new LDConfig.Builder().dataSource((ComponentConfigurer)Components.pollingDataSource()).serviceEndpoints(Components.serviceEndpoints().polling("http://fake")).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals(PollingProcessor.class, client.dataSource.getClass());
        }
    }

    @Test
    public void canSetCustomPollingEndpoint() throws Exception {
        URI pu = URI.create("http://fake");
        LDConfig config = new LDConfig.Builder().dataSource((ComponentConfigurer)Components.pollingDataSource()).serviceEndpoints(Components.serviceEndpoints().polling(pu)).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals((Object)pu, (Object)((DefaultFeatureRequestor)((PollingProcessor)client.dataSource).requestor).baseUri);
        }
    }

    @Test
    public void sameDiagnosticStorePassedToFactoriesWhenSupported() throws IOException {
        ComponentConfigurer mockDataSourceFactory = (ComponentConfigurer)this.mocks.createStrictMock(ComponentConfigurer.class);
        LDConfig config = new LDConfig.Builder().serviceEndpoints(Components.serviceEndpoints().events("fake-host")).dataSource(mockDataSourceFactory).events((ComponentConfigurer)Components.sendEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).startWait(Duration.ZERO).build();
        Capture capturedDataSourceContext = Capture.newInstance();
        EasyMock.expect((Object)((DataSource)mockDataSourceFactory.build((ClientContext)EasyMock.capture((Capture)capturedDataSourceContext)))).andReturn((Object)TestComponents.failedDataSource());
        this.mocks.replayAll();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            this.mocks.verifyAll();
            Assert.assertNotNull((Object)ClientContextImpl.get((ClientContext)((ClientContext)capturedDataSourceContext.getValue())).diagnosticStore);
        }
    }

    @Test
    public void nullDiagnosticStorePassedToFactoriesWhenOptedOut() throws IOException {
        ComponentConfigurer mockDataSourceFactory = (ComponentConfigurer)this.mocks.createStrictMock(ComponentConfigurer.class);
        LDConfig config = new LDConfig.Builder().dataSource(mockDataSourceFactory).diagnosticOptOut(true).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).startWait(Duration.ZERO).build();
        Capture capturedDataSourceContext = Capture.newInstance();
        EasyMock.expect((Object)((DataSource)mockDataSourceFactory.build((ClientContext)EasyMock.capture((Capture)capturedDataSourceContext)))).andReturn((Object)TestComponents.failedDataSource());
        this.mocks.replayAll();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            this.mocks.verifyAll();
            Assert.assertNull((Object)ClientContextImpl.get((ClientContext)((ClientContext)capturedDataSourceContext.getValue())).diagnosticStore);
        }
    }

    @Test
    public void noWaitForDataSourceIfWaitMillisIsZero() throws Exception {
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ZERO);
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isInitialized());
        this.mocks.verifyAll();
    }

    @Test
    public void willWaitForDataSourceIfWaitMillisIsGreaterThanZero() throws Exception {
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ofMillis(10L));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.initFuture.get(10L, TimeUnit.MILLISECONDS)).andReturn(null);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false).anyTimes();
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isInitialized());
        this.mocks.verifyAll();
    }

    @Test
    public void noWaitForDataSourceIfWaitMillisIsNegative() throws Exception {
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ofMillis(-10L));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isInitialized());
        this.mocks.verifyAll();
    }

    @Test
    public void dataSourceCanTimeOut() throws Exception {
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ofMillis(10L));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.initFuture.get(10L, TimeUnit.MILLISECONDS)).andThrow((Throwable)new TimeoutException());
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false).anyTimes();
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isInitialized());
        this.mocks.verifyAll();
    }

    @Test
    public void clientCatchesRuntimeExceptionFromDataSource() throws Exception {
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ofMillis(10L));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.initFuture.get(10L, TimeUnit.MILLISECONDS)).andThrow((Throwable)new RuntimeException());
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false).anyTimes();
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isInitialized());
        this.mocks.verifyAll();
    }

    @Test
    public void isFlagKnownReturnsTrueForExistingFlag() throws Exception {
        DataStore testDataStore = TestComponents.initedDataStore();
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ZERO).dataStore(TestComponents.specificComponent(testDataStore));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)true).times(1);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        TestUtil.upsertFlag(testDataStore, ModelBuilders.flagWithValue("key", LDValue.of((int)1)));
        Assert.assertTrue((boolean)this.client.isFlagKnown("key"));
        this.mocks.verifyAll();
    }

    @Test
    public void isFlagKnownReturnsFalseForUnknownFlag() throws Exception {
        DataStore testDataStore = TestComponents.initedDataStore();
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ZERO).dataStore(TestComponents.specificComponent(testDataStore));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)true).times(1);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isFlagKnown("key"));
        this.mocks.verifyAll();
    }

    @Test
    public void isFlagKnownReturnsFalseIfStoreAndClientAreNotInitialized() throws Exception {
        InMemoryDataStore testDataStore = new InMemoryDataStore();
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ZERO).dataStore(TestComponents.specificComponent(testDataStore));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false).times(1);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        TestUtil.upsertFlag((DataStore)testDataStore, ModelBuilders.flagWithValue("key", LDValue.of((int)1)));
        Assert.assertFalse((boolean)this.client.isFlagKnown("key"));
        this.mocks.verifyAll();
    }

    @Test
    public void isFlagKnownUsesStoreIfStoreIsInitializedButClientIsNot() throws Exception {
        DataStore testDataStore = TestComponents.initedDataStore();
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ZERO).dataStore(TestComponents.specificComponent(testDataStore));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false).times(1);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        TestUtil.upsertFlag(testDataStore, ModelBuilders.flagWithValue("key", LDValue.of((int)1)));
        Assert.assertTrue((boolean)this.client.isFlagKnown("key"));
        this.mocks.verifyAll();
    }

    @Test
    public void isFlagKnownCatchesExceptionFromDataStore() throws Exception {
        DataStore badStore = TestComponents.dataStoreThatThrowsException(new RuntimeException("sorry"));
        LDConfig.Builder config = new LDConfig.Builder().startWait(Duration.ZERO).dataStore(TestComponents.specificComponent(badStore));
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)false).times(1);
        this.mocks.replayAll();
        this.client = this.createMockClient(config);
        Assert.assertFalse((boolean)this.client.isFlagKnown("key"));
    }

    @Test
    public void getVersion() throws Exception {
        LDConfig config = new LDConfig.Builder().dataSource(Components.externalUpdatesOnly()).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging)).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            Assert.assertEquals((Object)"6.0.0", (Object)client.version());
        }
    }

    @Test
    public void canGetCacheStatsFromDataStoreStatusProvider() throws Exception {
        LDConfig config1 = this.baseConfig().build();
        try (LDClient client1 = new LDClient(SDK_KEY, config1);){
            Assert.assertNull((Object)client1.getDataStoreStatusProvider().getCacheStats());
        }
        LDConfig config2 = this.baseConfig().dataStore((ComponentConfigurer)Components.persistentDataStore(c -> new MockPersistentDataStore())).build();
        try (LDClient client2 = new LDClient(SDK_KEY, config2);){
            DataStoreStatusProvider.CacheStats expectedStats = new DataStoreStatusProvider.CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
            Assert.assertEquals((Object)expectedStats, (Object)client2.getDataStoreStatusProvider().getCacheStats());
        }
    }

    @Test
    public void testSecureModeHash() throws IOException {
        this.setupMockDataSourceToInitialize(true);
        LDContext context = LDContext.create((String)"userkey");
        LDUser contextAsUser = new LDUser(context.getKey());
        String expectedHash = "c097a70924341660427c2e487b86efee789210f9e6dafc3b5f50e75bc596ff99";
        this.client = this.createMockClient(new LDConfig.Builder().startWait(Duration.ZERO));
        Assert.assertEquals((Object)expectedHash, (Object)this.client.secureModeHash(context));
        Assert.assertEquals((Object)expectedHash, (Object)this.client.secureModeHash(contextAsUser));
        Assert.assertNull((Object)this.client.secureModeHash((LDContext)null));
        Assert.assertNull((Object)this.client.secureModeHash((LDUser)null));
        Assert.assertNull((Object)this.client.secureModeHash(LDContext.create(null)));
    }

    private void setupMockDataSourceToInitialize(boolean willInitialize) {
        EasyMock.expect((Object)this.dataSource.start()).andReturn(this.initFuture);
        EasyMock.expect((Object)this.dataSource.isInitialized()).andReturn((Object)willInitialize);
        this.mocks.replayAll();
    }

    private LDClient createMockClient(LDConfig.Builder config) {
        config.dataSource(TestComponents.specificComponent(this.dataSource));
        config.events(TestComponents.specificComponent(this.eventProcessor));
        config.logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging));
        return new LDClient(SDK_KEY, config.build());
    }
}

