/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.JsonHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ModelBuilders {
    public static FlagBuilder flagBuilder(String key) {
        return new FlagBuilder(key);
    }

    public static FlagBuilder flagBuilder(DataModel.FeatureFlag fromFlag) {
        return new FlagBuilder(fromFlag);
    }

    public static DataModel.FeatureFlag booleanFlagWithClauses(String key, DataModel.Clause ... clauses) {
        DataModel.Rule rule = ModelBuilders.ruleBuilder().variation(1).clauses(clauses).build();
        return ModelBuilders.flagBuilder(key).on(true).rules(rule).fallthrough(ModelBuilders.fallthroughVariation(0)).offVariation(0).variations(LDValue.of((boolean)false), LDValue.of((boolean)true)).build();
    }

    public static DataModel.FeatureFlag flagWithValue(String key, LDValue value) {
        return ModelBuilders.flagBuilder(key).on(false).offVariation(0).variations(value).build();
    }

    public static DataModel.VariationOrRollout fallthroughVariation(int variation) {
        return new DataModel.VariationOrRollout(Integer.valueOf(variation), null);
    }

    public static RuleBuilder ruleBuilder() {
        return new RuleBuilder();
    }

    public static DataModel.Clause clause(ContextKind contextKind, AttributeRef attribute, DataModel.Operator op, LDValue ... values) {
        return new DataModel.Clause(contextKind, attribute, op, Arrays.asList(values), false);
    }

    public static DataModel.Clause clause(ContextKind contextKind, String attributeName, DataModel.Operator op, LDValue ... values) {
        return ModelBuilders.clause(contextKind, AttributeRef.fromLiteral((String)attributeName), op, values);
    }

    public static DataModel.Clause clause(String attributeName, DataModel.Operator op, LDValue ... values) {
        return ModelBuilders.clause(null, attributeName, op, values);
    }

    public static DataModel.Clause clauseMatchingContext(LDContext context) {
        if (context.isMultiple()) {
            return ModelBuilders.clauseMatchingContext(context.getIndividualContext(0));
        }
        return ModelBuilders.clause(context.getKind(), AttributeRef.fromLiteral((String)"key"), DataModel.Operator.in, LDValue.of((String)context.getKey()));
    }

    public static DataModel.Clause clauseNotMatchingContext(LDContext context) {
        return ModelBuilders.negateClause(ModelBuilders.clauseMatchingContext(context));
    }

    public static DataModel.Clause clauseMatchingSegment(String ... segmentKeys) {
        LDValue[] values = new LDValue[segmentKeys.length];
        for (int i = 0; i < segmentKeys.length; ++i) {
            values[i] = LDValue.of((String)segmentKeys[i]);
        }
        return ModelBuilders.clause(null, (AttributeRef)null, DataModel.Operator.segmentMatch, values);
    }

    public static DataModel.Clause clauseMatchingSegment(DataModel.Segment segment) {
        return ModelBuilders.clauseMatchingSegment(segment.getKey());
    }

    public static DataModel.Clause negateClause(DataModel.Clause clause) {
        return new DataModel.Clause(clause.getContextKind(), clause.getAttribute(), clause.getOp(), clause.getValues(), !clause.isNegate());
    }

    public static DataModel.Target target(ContextKind contextKind, int variation, String ... userKeys) {
        return new DataModel.Target(contextKind, (Set)ImmutableSet.copyOf((Object[])userKeys), variation);
    }

    public static DataModel.Target target(int variation, String ... userKeys) {
        return ModelBuilders.target(null, variation, userKeys);
    }

    public static DataModel.Prerequisite prerequisite(String key, int variation) {
        return new DataModel.Prerequisite(key, variation);
    }

    public static DataModel.Rollout emptyRollout() {
        return new DataModel.Rollout(null, (List)ImmutableList.of(), null, DataModel.RolloutKind.rollout, null);
    }

    public static SegmentBuilder segmentBuilder(String key) {
        return new SegmentBuilder(key);
    }

    public static SegmentRuleBuilder segmentRuleBuilder() {
        return new SegmentRuleBuilder();
    }

    public static class SegmentRuleBuilder {
        private List<DataModel.Clause> clauses = new ArrayList<DataModel.Clause>();
        private Integer weight;
        private ContextKind rolloutContextKind;
        private AttributeRef bucketBy;

        private SegmentRuleBuilder() {
        }

        public DataModel.SegmentRule build() {
            return new DataModel.SegmentRule(this.clauses, this.weight, this.rolloutContextKind, this.bucketBy);
        }

        public SegmentRuleBuilder clauses(DataModel.Clause ... clauses) {
            this.clauses = ImmutableList.copyOf((Object[])clauses);
            return this;
        }

        public SegmentRuleBuilder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public SegmentRuleBuilder rolloutContextKind(ContextKind rolloutContextKind) {
            this.rolloutContextKind = rolloutContextKind;
            return this;
        }

        public SegmentRuleBuilder bucketBy(AttributeRef bucketBy) {
            this.bucketBy = bucketBy;
            return this;
        }
    }

    public static class SegmentBuilder {
        private String key;
        private Set<String> included = new HashSet<String>();
        private Set<String> excluded = new HashSet<String>();
        private List<DataModel.SegmentTarget> includedContexts = new ArrayList<DataModel.SegmentTarget>();
        private List<DataModel.SegmentTarget> excludedContexts = new ArrayList<DataModel.SegmentTarget>();
        private String salt = "";
        private List<DataModel.SegmentRule> rules = new ArrayList<DataModel.SegmentRule>();
        private int version = 0;
        private boolean deleted;
        private boolean unbounded;
        private ContextKind unboundedContextKind;
        private Integer generation;
        private boolean disablePreprocessing;

        private SegmentBuilder(String key) {
            this.key = key;
        }

        private SegmentBuilder(DataModel.Segment from) {
            this.key = from.getKey();
            this.included = new HashSet<String>(from.getIncluded());
            this.excluded = new HashSet<String>(from.getExcluded());
            this.includedContexts = new ArrayList<DataModel.SegmentTarget>(from.getIncludedContexts());
            this.excludedContexts = new ArrayList<DataModel.SegmentTarget>(from.getIncludedContexts());
            this.salt = from.getSalt();
            this.rules = new ArrayList<DataModel.SegmentRule>(from.getRules());
            this.version = from.getVersion();
            this.deleted = from.isDeleted();
        }

        public DataModel.Segment build() {
            DataModel.Segment s = new DataModel.Segment(this.key, this.included, this.excluded, this.includedContexts, this.excludedContexts, this.salt, this.rules, this.version, this.deleted, this.unbounded, this.unboundedContextKind, this.generation);
            if (!this.disablePreprocessing) {
                s.afterDeserialized();
            }
            return s;
        }

        public SegmentBuilder disablePreprocessing(boolean disable) {
            this.disablePreprocessing = disable;
            return this;
        }

        public SegmentBuilder included(String ... included) {
            this.included.addAll(Arrays.asList(included));
            return this;
        }

        public SegmentBuilder excluded(String ... excluded) {
            this.excluded.addAll(Arrays.asList(excluded));
            return this;
        }

        public SegmentBuilder includedContexts(ContextKind contextKind, String ... keys) {
            this.includedContexts.add(new DataModel.SegmentTarget(contextKind, (Set)ImmutableSet.copyOf((Object[])keys)));
            return this;
        }

        public SegmentBuilder excludedContexts(ContextKind contextKind, String ... keys) {
            this.excludedContexts.add(new DataModel.SegmentTarget(contextKind, (Set)ImmutableSet.copyOf((Object[])keys)));
            return this;
        }

        public SegmentBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public SegmentBuilder rules(DataModel.SegmentRule ... rules) {
            this.rules = Arrays.asList(rules);
            return this;
        }

        public SegmentBuilder version(int version) {
            this.version = version;
            return this;
        }

        public SegmentBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public SegmentBuilder unbounded(boolean unbounded) {
            this.unbounded = unbounded;
            return this;
        }

        public SegmentBuilder unboundedContextKind(ContextKind unboundedContextKind) {
            this.unboundedContextKind = unboundedContextKind;
            return this;
        }

        public SegmentBuilder generation(Integer generation) {
            this.generation = generation;
            return this;
        }
    }

    public static class RuleBuilder {
        private String id;
        private List<DataModel.Clause> clauses = new ArrayList<DataModel.Clause>();
        private Integer variation;
        private DataModel.Rollout rollout;
        private boolean trackEvents;

        private RuleBuilder() {
        }

        public DataModel.Rule build() {
            return new DataModel.Rule(this.id, this.clauses, this.variation, this.rollout, this.trackEvents);
        }

        public RuleBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RuleBuilder clauses(DataModel.Clause ... clauses) {
            this.clauses = ImmutableList.copyOf((Object[])clauses);
            return this;
        }

        public RuleBuilder variation(Integer variation) {
            this.variation = variation;
            return this;
        }

        public RuleBuilder rollout(DataModel.Rollout rollout) {
            this.rollout = rollout;
            return this;
        }

        public RuleBuilder trackEvents(boolean trackEvents) {
            this.trackEvents = trackEvents;
            return this;
        }
    }

    public static class FlagBuilder {
        private String key;
        private int version;
        private boolean on;
        private List<DataModel.Prerequisite> prerequisites = new ArrayList<DataModel.Prerequisite>();
        private String salt;
        private List<DataModel.Target> targets = new ArrayList<DataModel.Target>();
        private List<DataModel.Target> contextTargets = new ArrayList<DataModel.Target>();
        private List<DataModel.Rule> rules = new ArrayList<DataModel.Rule>();
        private DataModel.VariationOrRollout fallthrough;
        private Integer offVariation;
        private List<LDValue> variations = new ArrayList<LDValue>();
        private boolean clientSide;
        private boolean trackEvents;
        private boolean trackEventsFallthrough;
        private Long debugEventsUntilDate;
        private boolean deleted;
        private boolean disablePreprocessing = false;

        private FlagBuilder(String key) {
            this.key = key;
        }

        private FlagBuilder(DataModel.FeatureFlag f) {
            if (f != null) {
                this.key = f.getKey();
                this.version = f.getVersion();
                this.on = f.isOn();
                this.prerequisites = f.getPrerequisites();
                this.salt = f.getSalt();
                this.targets = f.getTargets();
                this.contextTargets = f.getContextTargets();
                this.rules = f.getRules();
                this.fallthrough = f.getFallthrough();
                this.offVariation = f.getOffVariation();
                this.variations = f.getVariations();
                this.clientSide = f.isClientSide();
                this.trackEvents = f.isTrackEvents();
                this.trackEventsFallthrough = f.isTrackEventsFallthrough();
                this.debugEventsUntilDate = f.getDebugEventsUntilDate();
                this.deleted = f.isDeleted();
            }
        }

        public FlagBuilder version(int version) {
            this.version = version;
            return this;
        }

        public FlagBuilder on(boolean on) {
            this.on = on;
            return this;
        }

        public FlagBuilder prerequisites(DataModel.Prerequisite ... prerequisites) {
            this.prerequisites = Arrays.asList(prerequisites);
            return this;
        }

        public FlagBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public FlagBuilder targets(DataModel.Target ... targets) {
            this.targets = Arrays.asList(targets);
            return this;
        }

        public FlagBuilder addTarget(int variation, String ... values) {
            this.targets.add(ModelBuilders.target(variation, values));
            return this;
        }

        public FlagBuilder contextTargets(DataModel.Target ... contextTargets) {
            this.contextTargets = Arrays.asList(contextTargets);
            return this;
        }

        public FlagBuilder addContextTarget(ContextKind contextKind, int variation, String ... values) {
            this.contextTargets.add(ModelBuilders.target(contextKind, variation, values));
            return this;
        }

        public FlagBuilder rules(DataModel.Rule ... rules) {
            this.rules = Arrays.asList(rules);
            return this;
        }

        public FlagBuilder addRule(DataModel.Rule rule) {
            this.rules.add(rule);
            return this;
        }

        public FlagBuilder addRule(String id, int variation, String ... clausesAsJson) {
            DataModel.Clause[] clauses = new DataModel.Clause[clausesAsJson.length];
            for (int i = 0; i < clausesAsJson.length; ++i) {
                clauses[i] = (DataModel.Clause)JsonHelpers.deserialize((String)clausesAsJson[i], DataModel.Clause.class);
            }
            return this.addRule(ModelBuilders.ruleBuilder().id(id).variation(variation).clauses(clauses).build());
        }

        public FlagBuilder fallthroughVariation(int fallthroughVariation) {
            this.fallthrough = new DataModel.VariationOrRollout(Integer.valueOf(fallthroughVariation), null);
            return this;
        }

        public FlagBuilder fallthrough(DataModel.Rollout rollout) {
            this.fallthrough = new DataModel.VariationOrRollout(null, rollout);
            return this;
        }

        public FlagBuilder fallthrough(DataModel.VariationOrRollout fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public FlagBuilder offVariation(Integer offVariation) {
            this.offVariation = offVariation;
            return this;
        }

        public FlagBuilder variations(LDValue ... variations) {
            this.variations = Arrays.asList(variations);
            return this;
        }

        public FlagBuilder variations(boolean ... variations) {
            ArrayList<LDValue> values = new ArrayList<LDValue>();
            for (boolean v : variations) {
                values.add(LDValue.of((boolean)v));
            }
            this.variations = values;
            return this;
        }

        public FlagBuilder variations(String ... variations) {
            ArrayList<LDValue> values = new ArrayList<LDValue>();
            for (String v : variations) {
                values.add(LDValue.of((String)v));
            }
            this.variations = values;
            return this;
        }

        public FlagBuilder generatedVariations(int numVariations) {
            this.variations.clear();
            for (int i = 0; i < numVariations; ++i) {
                this.variations.add(LDValue.of((int)i));
            }
            return this;
        }

        public FlagBuilder clientSide(boolean clientSide) {
            this.clientSide = clientSide;
            return this;
        }

        public FlagBuilder trackEvents(boolean trackEvents) {
            this.trackEvents = trackEvents;
            return this;
        }

        public FlagBuilder trackEventsFallthrough(boolean trackEventsFallthrough) {
            this.trackEventsFallthrough = trackEventsFallthrough;
            return this;
        }

        public FlagBuilder debugEventsUntilDate(Long debugEventsUntilDate) {
            this.debugEventsUntilDate = debugEventsUntilDate;
            return this;
        }

        public FlagBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public FlagBuilder disablePreprocessing(boolean disable) {
            this.disablePreprocessing = disable;
            return this;
        }

        public DataModel.FeatureFlag build() {
            DataModel.FeatureFlag flag = new DataModel.FeatureFlag(this.key, this.version, this.on, this.prerequisites, this.salt, this.targets, this.contextTargets, this.rules, this.fallthrough, this.offVariation, this.variations, this.clientSide, this.trackEvents, this.trackEventsFallthrough, this.debugEventsUntilDate, this.deleted);
            if (!this.disablePreprocessing) {
                flag.afterDeserialized();
            }
            return flag;
        }
    }
}

