/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.MockPersistentDataStore;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PersistentDataStoreWrapperTest
extends BaseTest {
    private static final RuntimeException FAKE_ERROR = new RuntimeException("fake error");
    private final TestMode testMode;
    private final MockPersistentDataStore core;
    private final PersistentDataStoreWrapper wrapper;
    private final EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> statusBroadcaster;
    private final DataStoreUpdatesImpl dataStoreUpdates;
    private final DataStoreStatusProvider dataStoreStatusProvider;

    @Parameterized.Parameters(name="cached={0}")
    public static Iterable<TestMode> data() {
        return ImmutableList.of((Object)new TestMode(true, false, false), (Object)new TestMode(true, false, true), (Object)new TestMode(true, true, false), (Object)new TestMode(true, true, true), (Object)new TestMode(false, false, false), (Object)new TestMode(false, false, true));
    }

    public PersistentDataStoreWrapperTest(TestMode testMode) {
        this.testMode = testMode;
        this.core = new MockPersistentDataStore();
        this.core.persistOnlyAsString = testMode.persistOnlyAsString;
        this.wrapper = new PersistentDataStoreWrapper((PersistentDataStore)this.core, testMode.getCacheTtl(), PersistentDataStoreBuilder.StaleValuesPolicy.EVICT, false, this::updateStatus, TestComponents.sharedExecutor, this.testLogger);
        this.statusBroadcaster = EventBroadcasterImpl.forDataStoreStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)this.testLogger);
        this.dataStoreUpdates = new DataStoreUpdatesImpl(this.statusBroadcaster);
        this.dataStoreStatusProvider = new DataStoreStatusProviderImpl((DataStore)this.wrapper, this.dataStoreUpdates);
    }

    private void updateStatus(DataStoreStatusProvider.Status status) {
        this.dataStoreUpdates.updateStatus(status);
    }

    @After
    public void tearDown() throws IOException {
        this.wrapper.close();
    }

    @Test
    public void get() {
        DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
        DataStoreTestTypes.TestItem itemv2 = itemv1.withVersion(2);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv1);
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key), (Matcher)Matchers.equalTo((Object)itemv1.toItemDescriptor()));
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv2);
        DataStoreTypes.ItemDescriptor result = this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key);
        DataStoreTypes.ItemDescriptor expected = (this.testMode.isCached() ? itemv1 : itemv2).toItemDescriptor();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void getDeletedItem() {
        String key = "key";
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, key, DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)1)));
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, key), (Matcher)Matchers.equalTo((Object)DataStoreTypes.ItemDescriptor.deletedItem((int)1)));
        DataStoreTestTypes.TestItem itemv2 = new DataStoreTestTypes.TestItem(key, 2);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv2);
        DataStoreTypes.ItemDescriptor result = this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, key);
        DataStoreTypes.ItemDescriptor expected = this.testMode.isCached() ? DataStoreTypes.ItemDescriptor.deletedItem((int)1) : itemv2.toItemDescriptor();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void getMissingItem() {
        String key = "key";
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, key), (Matcher)Matchers.nullValue());
        DataStoreTestTypes.TestItem item = new DataStoreTestTypes.TestItem(key, 1);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item);
        DataStoreTypes.ItemDescriptor result = this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, item.key);
        MatcherAssert.assertThat((Object)result, (Matcher)(this.testMode.isCached() ? Matchers.nullValue(DataStoreTypes.ItemDescriptor.class) : Matchers.equalTo((Object)item.toItemDescriptor())));
    }

    @Test
    public void cachedGetUsesValuesFromInit() {
        Assume.assumeThat((Object)this.testMode.isCached(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem item1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", 1);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1, item2).build());
        this.core.forceRemove(DataStoreTestTypes.TEST_ITEMS, item1.key);
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, item1.key), (Matcher)Matchers.equalTo((Object)item1.toItemDescriptor()));
    }

    @Test
    public void getAll() {
        DataStoreTestTypes.TestItem item1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", 1);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item1);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item2);
        Map items = DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS));
        ImmutableMap expected = ImmutableMap.of((Object)item1.key, (Object)item1.toItemDescriptor(), (Object)item2.key, (Object)item2.toItemDescriptor());
        MatcherAssert.assertThat(items, (Matcher)Matchers.equalTo((Object)expected));
        this.core.forceRemove(DataStoreTestTypes.TEST_ITEMS, item2.key);
        items = DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS));
        if (this.testMode.isCached()) {
            MatcherAssert.assertThat(items, (Matcher)Matchers.equalTo((Object)expected));
        } else {
            ImmutableMap expected1 = ImmutableMap.of((Object)item1.key, (Object)item1.toItemDescriptor());
            MatcherAssert.assertThat(items, (Matcher)Matchers.equalTo((Object)expected1));
        }
    }

    @Test
    public void getAllDoesNotRemoveDeletedItems() {
        String key1 = "key1";
        String key2 = "key2";
        DataStoreTestTypes.TestItem item1 = new DataStoreTestTypes.TestItem(key1, 1);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item1);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, key2, DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)1)));
        Map items = DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS));
        ImmutableMap expected = ImmutableMap.of((Object)key1, (Object)item1.toItemDescriptor(), (Object)key2, (Object)DataStoreTypes.ItemDescriptor.deletedItem((int)1));
        MatcherAssert.assertThat(items, (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void cachedAllUsesValuesFromInit() {
        Assume.assumeThat((Object)this.testMode.isCached(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem item1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", 1);
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData = new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1, item2).build();
        this.wrapper.init(allData);
        this.core.forceRemove(DataStoreTestTypes.TEST_ITEMS, item2.key);
        Map items = DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS));
        Map<String, DataStoreTypes.ItemDescriptor> expected = DataStoreTestTypes.toDataMap(allData).get(DataStoreTestTypes.TEST_ITEMS);
        MatcherAssert.assertThat(items, (Matcher)Matchers.equalTo(expected));
    }

    @Test
    public void cachedStoreWithFiniteTtlDoesNotUpdateCacheIfCoreInitFails() {
        Assume.assumeThat((Object)this.testMode.isCachedWithFiniteTtl(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem item = new DataStoreTestTypes.TestItem("key", 1);
        this.core.fakeError = FAKE_ERROR;
        try {
            this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item).build());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Object)FAKE_ERROR));
        }
        this.core.fakeError = null;
        MatcherAssert.assertThat((Object)DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS)).size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void cachedStoreWithInfiniteTtlUpdatesCacheEvenIfCoreInitFails() {
        Assume.assumeThat((Object)this.testMode.isCachedIndefinitely(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem item = new DataStoreTestTypes.TestItem("key", 1);
        this.core.fakeError = FAKE_ERROR;
        try {
            this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item).build());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Object)FAKE_ERROR));
        }
        this.core.fakeError = null;
        ImmutableMap expected = ImmutableMap.of((Object)item.key, (Object)item.toItemDescriptor());
        MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS)), (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void upsertSuccessful() {
        DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
        DataStoreTestTypes.TestItem itemv2 = itemv1.withVersion(2);
        this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, itemv1.toItemDescriptor());
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(itemv1.key), (Matcher)Matchers.equalTo((Object)itemv1.toSerializedItemDescriptor()));
        this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, itemv2.toItemDescriptor());
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(itemv1.key), (Matcher)Matchers.equalTo((Object)itemv2.toSerializedItemDescriptor()));
        if (this.testMode.isCached()) {
            DataStoreTestTypes.TestItem itemv3 = itemv1.withVersion(3);
            this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv3);
        }
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key), (Matcher)Matchers.equalTo((Object)itemv2.toItemDescriptor()));
    }

    @Test
    public void cachedUpsertUnsuccessful() {
        Assume.assumeThat((Object)this.testMode.isCached(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
        DataStoreTestTypes.TestItem itemv2 = itemv1.withVersion(2);
        this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, itemv2.toItemDescriptor());
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(itemv2.key), (Matcher)Matchers.equalTo((Object)itemv2.toSerializedItemDescriptor()));
        boolean success = this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, itemv1.toItemDescriptor());
        MatcherAssert.assertThat((Object)success, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(itemv1.key), (Matcher)Matchers.equalTo((Object)itemv2.toSerializedItemDescriptor()));
        DataStoreTestTypes.TestItem itemv3 = itemv1.withVersion(3);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv3);
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key), (Matcher)Matchers.equalTo((Object)itemv2.toItemDescriptor()));
    }

    @Test
    public void cachedStoreWithFiniteTtlDoesNotUpdateCacheIfCoreUpdateFails() {
        Assume.assumeThat((Object)this.testMode.isCachedWithFiniteTtl(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
        DataStoreTestTypes.TestItem itemv2 = itemv1.withVersion(2);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, itemv1).build());
        this.core.fakeError = FAKE_ERROR;
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, itemv2.toItemDescriptor());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Object)FAKE_ERROR));
        }
        this.core.fakeError = null;
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key), (Matcher)Matchers.equalTo((Object)itemv1.toItemDescriptor()));
    }

    @Test
    public void cachedStoreWithInfiniteTtlUpdatesCacheEvenIfCoreUpdateFails() {
        Assume.assumeThat((Object)this.testMode.isCachedIndefinitely(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
        DataStoreTestTypes.TestItem itemv2 = itemv1.withVersion(2);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, itemv1).build());
        this.core.fakeError = FAKE_ERROR;
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, itemv2.toItemDescriptor());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Object)FAKE_ERROR));
        }
        this.core.fakeError = null;
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key), (Matcher)Matchers.equalTo((Object)itemv2.toItemDescriptor()));
    }

    @Test
    public void cachedStoreWithFiniteTtlRemovesCachedAllDataIfOneItemIsUpdated() {
        Assume.assumeThat((Object)this.testMode.isCachedWithFiniteTtl(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem item1v1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item1v2 = item1v1.withVersion(2);
        DataStoreTestTypes.TestItem item2v1 = new DataStoreTestTypes.TestItem("key2", 1);
        DataStoreTestTypes.TestItem item2v2 = item2v1.withVersion(2);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1v1, item2v1).build());
        this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS);
        this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, item1v1.key, item1v2.toItemDescriptor());
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item2v2);
        ImmutableMap expected = ImmutableMap.of((Object)item1v1.key, (Object)item1v2.toItemDescriptor(), (Object)item2v1.key, (Object)item2v2.toItemDescriptor());
        MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS)), (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void cachedStoreWithInfiniteTtlUpdatesCachedAllDataIfOneItemIsUpdated() {
        Assume.assumeThat((Object)this.testMode.isCachedIndefinitely(), (Matcher)Matchers.is((Object)true));
        DataStoreTestTypes.TestItem item1v1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item1v2 = item1v1.withVersion(2);
        DataStoreTestTypes.TestItem item2v1 = new DataStoreTestTypes.TestItem("key2", 1);
        DataStoreTestTypes.TestItem item2v2 = item2v1.withVersion(2);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1v1, item2v1).build());
        this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS);
        this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, item1v1.key, item1v2.toItemDescriptor());
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item2v2);
        ImmutableMap expected = ImmutableMap.of((Object)item1v1.key, (Object)item1v2.toItemDescriptor(), (Object)item2v1.key, (Object)item2v1.toItemDescriptor());
        MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.wrapper.getAll(DataStoreTestTypes.TEST_ITEMS)), (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void delete() {
        DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv1);
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key), (Matcher)Matchers.equalTo((Object)itemv1.toItemDescriptor()));
        DataStoreTypes.ItemDescriptor deletedItem = DataStoreTypes.ItemDescriptor.deletedItem((int)2);
        this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, itemv1.key, deletedItem);
        DataStoreTypes.SerializedItemDescriptor serializedDeletedItem = this.testMode.persistOnlyAsString ? DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)deletedItem.getVersion())) : new DataStoreTypes.SerializedItemDescriptor(deletedItem.getVersion(), true, null);
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(itemv1.key), (Matcher)Matchers.equalTo((Object)serializedDeletedItem));
        DataStoreTestTypes.TestItem itemv3 = itemv1.withVersion(3);
        this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv3);
        DataStoreTypes.ItemDescriptor result = this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)(this.testMode.isCached() ? deletedItem : itemv3.toItemDescriptor())));
    }

    @Test
    public void initializedCallsInternalMethodOnlyIfNotAlreadyInited() {
        Assume.assumeThat((Object)this.testMode.isCached(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.wrapper.isInitialized(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)1));
        this.core.inited.set(true);
        MatcherAssert.assertThat((Object)this.wrapper.isInitialized(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)2));
        this.core.inited.set(false);
        MatcherAssert.assertThat((Object)this.wrapper.isInitialized(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void initializedDoesNotCallInternalMethodAfterInitHasBeenCalled() {
        Assume.assumeThat((Object)this.testMode.isCached(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.wrapper.isInitialized(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)1));
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().build());
        MatcherAssert.assertThat((Object)this.wrapper.isInitialized(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void initializedCanCacheFalseResult() throws Exception {
        Assume.assumeThat((Object)this.testMode.isCached(), (Matcher)Matchers.is((Object)true));
        try (PersistentDataStoreWrapper wrapper1 = new PersistentDataStoreWrapper((PersistentDataStore)this.core, Duration.ofMillis(500L), PersistentDataStoreBuilder.StaleValuesPolicy.EVICT, false, this::updateStatus, TestComponents.sharedExecutor, this.testLogger);){
            MatcherAssert.assertThat((Object)wrapper1.isInitialized(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)1));
            this.core.inited.set(true);
            MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)1));
            Thread.sleep(600L);
            MatcherAssert.assertThat((Object)wrapper1.isInitialized(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)2));
            MatcherAssert.assertThat((Object)wrapper1.isInitialized(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.core.initedQueryCount, (Matcher)Matchers.equalTo((Object)2));
        }
    }

    @Test
    public void isInitializedCatchesException() throws Exception {
        this.core.fakeError = FAKE_ERROR;
        MatcherAssert.assertThat((Object)this.wrapper.isInitialized(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void canGetCacheStats() throws Exception {
        try (PersistentDataStoreWrapper w = new PersistentDataStoreWrapper((PersistentDataStore)this.core, this.testMode.getCacheTtl(), PersistentDataStoreBuilder.StaleValuesPolicy.EVICT, true, this::updateStatus, TestComponents.sharedExecutor, this.testLogger);){
            DataStoreStatusProvider.CacheStats stats = w.getCacheStats();
            if (!this.testMode.isCached()) {
                Assert.assertNull((Object)stats);
                return;
            }
            MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.equalTo((Object)new DataStoreStatusProvider.CacheStats(0L, 0L, 0L, 0L, 0L, 0L)));
            w.get(DataStoreTestTypes.TEST_ITEMS, "key1");
            stats = w.getCacheStats();
            MatcherAssert.assertThat((Object)stats.getHitCount(), (Matcher)Matchers.equalTo((Object)0L));
            MatcherAssert.assertThat((Object)stats.getMissCount(), (Matcher)Matchers.equalTo((Object)1L));
            MatcherAssert.assertThat((Object)stats.getLoadSuccessCount(), (Matcher)Matchers.equalTo((Object)1L));
            MatcherAssert.assertThat((Object)stats.getLoadExceptionCount(), (Matcher)Matchers.equalTo((Object)0L));
            this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, new DataStoreTestTypes.TestItem("key2", 1));
            w.get(DataStoreTestTypes.TEST_ITEMS, "key2");
            w.get(DataStoreTestTypes.TEST_ITEMS, "key2");
            stats = w.getCacheStats();
            MatcherAssert.assertThat((Object)stats.getHitCount(), (Matcher)Matchers.equalTo((Object)1L));
            MatcherAssert.assertThat((Object)stats.getMissCount(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)stats.getLoadSuccessCount(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)stats.getLoadExceptionCount(), (Matcher)Matchers.equalTo((Object)0L));
            this.core.fakeError = new RuntimeException("sorry");
            try {
                w.get(DataStoreTestTypes.TEST_ITEMS, "key3");
                Assert.fail((String)"expected exception");
            }
            catch (RuntimeException e) {
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Object)this.core.fakeError));
            }
            stats = w.getCacheStats();
            MatcherAssert.assertThat((Object)stats.getHitCount(), (Matcher)Matchers.equalTo((Object)1L));
            MatcherAssert.assertThat((Object)stats.getMissCount(), (Matcher)Matchers.equalTo((Object)3L));
            MatcherAssert.assertThat((Object)stats.getLoadSuccessCount(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)stats.getLoadExceptionCount(), (Matcher)Matchers.equalTo((Object)1L));
        }
    }

    @Test
    public void statusIsOkInitially() throws Exception {
        DataStoreStatusProvider.Status status = this.dataStoreStatusProvider.getStatus();
        MatcherAssert.assertThat((Object)status.isAvailable(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)status.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void statusIsUnavailableAfterError() throws Exception {
        this.causeStoreError(this.core, this.wrapper);
        DataStoreStatusProvider.Status status = this.dataStoreStatusProvider.getStatus();
        MatcherAssert.assertThat((Object)status.isAvailable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)status.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void statusListenerIsNotifiedOnFailureAndRecovery() throws Exception {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.dataStoreStatusProvider.addStatusListener(statuses::add);
        this.causeStoreError(this.core, this.wrapper);
        DataStoreStatusProvider.Status status1 = (DataStoreStatusProvider.Status)statuses.take();
        MatcherAssert.assertThat((Object)status1.isAvailable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)status1.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
        this.causeStoreError(this.core, this.wrapper);
        this.makeStoreAvailable(this.core);
        DataStoreStatusProvider.Status status2 = (DataStoreStatusProvider.Status)statuses.take();
        MatcherAssert.assertThat((Object)status2.isAvailable(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)status2.isRefreshNeeded(), (Matcher)Matchers.is((Object)(!this.testMode.isCachedIndefinitely() ? 1 : 0)));
    }

    @Test
    public void cacheIsWrittenToStoreAfterRecoveryIfTtlIsInfinite() throws Exception {
        Assume.assumeThat((Object)this.testMode.isCachedIndefinitely(), (Matcher)Matchers.is((Object)true));
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.dataStoreStatusProvider.addStatusListener(statuses::add);
        DataStoreTestTypes.TestItem item1v1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item1v2 = item1v1.withVersion(2);
        DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", 1);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1v1).build());
        this.causeStoreError(this.core, this.wrapper);
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, item1v1.key, item1v2.toItemDescriptor());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)FAKE_ERROR.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, item1v1.key), (Matcher)Matchers.equalTo((Object)item1v2.toItemDescriptor()));
        DataStoreStatusProvider.Status status1 = (DataStoreStatusProvider.Status)statuses.take();
        MatcherAssert.assertThat((Object)status1.isAvailable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)status1.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, item2.key, item2.toItemDescriptor());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)FAKE_ERROR.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, item2.key), (Matcher)Matchers.equalTo((Object)item2.toItemDescriptor()));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(item2.key), (Matcher)Matchers.nullValue());
        this.makeStoreAvailable(this.core);
        DataStoreStatusProvider.Status status2 = (DataStoreStatusProvider.Status)statuses.take();
        MatcherAssert.assertThat((Object)status2.isAvailable(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)status2.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(item1v1.key), (Matcher)Matchers.equalTo((Object)item1v2.toSerializedItemDescriptor()));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(item2.key), (Matcher)Matchers.equalTo((Object)item2.toSerializedItemDescriptor()));
    }

    @Test
    public void statusRemainsUnavailableIfStoreSaysItIsAvailableButInitFails() throws Exception {
        Assume.assumeThat((Object)this.testMode.isCachedIndefinitely(), (Matcher)Matchers.is((Object)true));
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.dataStoreStatusProvider.addStatusListener(statuses::add);
        DataStoreTestTypes.TestItem item1v1 = new DataStoreTestTypes.TestItem("key1", 1);
        DataStoreTestTypes.TestItem item1v2 = item1v1.withVersion(2);
        DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", 1);
        this.wrapper.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1v1).build());
        this.causeStoreError(this.core, this.wrapper);
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, item1v1.key, item1v2.toItemDescriptor());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)FAKE_ERROR.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, item1v1.key), (Matcher)Matchers.equalTo((Object)item1v2.toItemDescriptor()));
        DataStoreStatusProvider.Status status1 = (DataStoreStatusProvider.Status)statuses.take();
        MatcherAssert.assertThat((Object)status1.isAvailable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)status1.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, item2.key, item2.toItemDescriptor());
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)FAKE_ERROR.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.wrapper.get(DataStoreTestTypes.TEST_ITEMS, item2.key), (Matcher)Matchers.equalTo((Object)item2.toItemDescriptor()));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(item2.key), (Matcher)Matchers.nullValue());
        this.core.unavailable = false;
        Thread.sleep(1000L);
        MatcherAssert.assertThat((Object)statuses.isEmpty(), (Matcher)Matchers.is((Object)true));
        int initedCount = this.core.initedCount.get();
        MatcherAssert.assertThat((Object)initedCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
        this.core.fakeError = null;
        DataStoreStatusProvider.Status status2 = (DataStoreStatusProvider.Status)statuses.take();
        MatcherAssert.assertThat((Object)status2.isAvailable(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)status2.isRefreshNeeded(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(item1v1.key), (Matcher)Matchers.equalTo((Object)item1v2.toSerializedItemDescriptor()));
        MatcherAssert.assertThat((Object)this.core.data.get(DataStoreTestTypes.TEST_ITEMS).get(item2.key), (Matcher)Matchers.equalTo((Object)item2.toSerializedItemDescriptor()));
        MatcherAssert.assertThat((Object)this.core.initedCount.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(initedCount)));
    }

    private void causeStoreError(MockPersistentDataStore core, PersistentDataStoreWrapper w) {
        core.unavailable = true;
        core.fakeError = new RuntimeException(FAKE_ERROR.getMessage());
        try {
            this.wrapper.upsert(DataStoreTestTypes.TEST_ITEMS, "irrelevant-key", DataStoreTypes.ItemDescriptor.deletedItem((int)1));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)FAKE_ERROR.getMessage()));
        }
    }

    private void makeStoreAvailable(MockPersistentDataStore core) {
        core.fakeError = null;
        core.unavailable = false;
    }

    static class TestMode {
        final boolean cached;
        final boolean cachedIndefinitely;
        final boolean persistOnlyAsString;

        TestMode(boolean cached, boolean cachedIndefinitely, boolean persistOnlyAsString) {
            this.cached = cached;
            this.cachedIndefinitely = cachedIndefinitely;
            this.persistOnlyAsString = persistOnlyAsString;
        }

        boolean isCached() {
            return this.cached;
        }

        boolean isCachedWithFiniteTtl() {
            return this.cached && !this.cachedIndefinitely;
        }

        boolean isCachedIndefinitely() {
            return this.cached && this.cachedIndefinitely;
        }

        Duration getCacheTtl() {
            return this.cached ? (this.cachedIndefinitely ? Duration.ofMillis(-1L) : Duration.ofSeconds(30L)) : Duration.ZERO;
        }

        public String toString() {
            return "TestMode(" + (this.cached ? (this.cachedIndefinitely ? "CachedIndefinitely" : "Cached") : "Uncached") + (this.persistOnlyAsString ? ",persistOnlyAsString" : "") + ")";
        }
    }
}

