/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.DefaultFeatureRequestor;
import com.launchdarkly.sdk.server.FeatureRequestor;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.PollingProcessor;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import com.launchdarkly.testhelpers.httptest.Handler;
import com.launchdarkly.testhelpers.httptest.Handlers;
import com.launchdarkly.testhelpers.httptest.HttpServer;
import com.launchdarkly.testhelpers.httptest.RequestContext;
import com.launchdarkly.testhelpers.tcptest.TcpHandler;
import com.launchdarkly.testhelpers.tcptest.TcpHandlers;
import com.launchdarkly.testhelpers.tcptest.TcpServer;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PollingProcessorTest
extends BaseTest {
    private static final String SDK_KEY = "sdk-key";
    private static final Duration LENGTHY_INTERVAL = Duration.ofSeconds(60L);
    private static final Duration BRIEF_INTERVAL = Duration.ofMillis(20L);
    private TestComponents.MockDataSourceUpdates dataSourceUpdates;

    @Before
    public void setup() {
        InMemoryDataStore store = new InMemoryDataStore();
        this.dataSourceUpdates = TestComponents.dataSourceUpdates((DataStore)store, new TestComponents.MockDataStoreStatusProvider());
    }

    private PollingProcessor makeProcessor(URI baseUri, Duration pollInterval) {
        DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(TestComponents.defaultHttpProperties(), baseUri, this.testLogger);
        return new PollingProcessor((FeatureRequestor)requestor, (DataSourceUpdateSink)this.dataSourceUpdates, TestComponents.sharedExecutor, pollInterval, this.testLogger);
    }

    @Test
    public void builderHasDefaultConfiguration() throws Exception {
        PollingDataSourceBuilder f = Components.pollingDataSource();
        try (PollingProcessor pp = (PollingProcessor)f.build((ClientContext)TestComponents.clientContext(SDK_KEY, this.baseConfig().build()));){
            MatcherAssert.assertThat((Object)((DefaultFeatureRequestor)pp.requestor).baseUri, (Matcher)Matchers.equalTo((Object)StandardEndpoints.DEFAULT_POLLING_BASE_URI));
            MatcherAssert.assertThat((Object)pp.pollInterval, (Matcher)Matchers.equalTo((Object)PollingDataSourceBuilder.DEFAULT_POLL_INTERVAL));
        }
    }

    @Test
    public void builderCanSpecifyConfiguration() throws Exception {
        PollingDataSourceBuilder f = Components.pollingDataSource().pollInterval(LENGTHY_INTERVAL);
        try (PollingProcessor pp = (PollingProcessor)f.build((ClientContext)TestComponents.clientContext(SDK_KEY, this.baseConfig().build()));){
            MatcherAssert.assertThat((Object)pp.pollInterval, (Matcher)Matchers.equalTo((Object)LENGTHY_INTERVAL));
        }
    }

    @Test
    public void successfulPolls() throws Exception {
        DataModel.FeatureFlag flagv1 = ModelBuilders.flagBuilder("flag").version(1).build();
        DataModel.FeatureFlag flagv2 = ModelBuilders.flagBuilder(flagv1.getKey()).version(2).build();
        DataStoreTestTypes.DataBuilder datav1 = DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flagv1});
        DataStoreTestTypes.DataBuilder datav2 = DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flagv2});
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.dataSourceUpdates.statusBroadcaster.register(statuses::add);
        Semaphore allowSecondPollToProceed = new Semaphore(0);
        Handler pollingHandler = Handlers.sequential((Handler[])new Handler[]{new TestPollHandler(datav1), Handlers.all((Handler[])new Handler[]{Handlers.waitFor((Semaphore)allowSecondPollToProceed), new TestPollHandler(datav2)}), Handlers.hang()});
        try (HttpServer server = HttpServer.start((Handler)pollingHandler);
             PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), Duration.ofMillis(100L));){
            Future initFuture = pollingProcessor.start();
            ConcurrentHelpers.assertFutureIsCompleted((Future)initFuture, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            Assert.assertTrue((boolean)pollingProcessor.isInitialized());
            TestUtil.assertDataSetEquals(datav1.build(), this.dataSourceUpdates.awaitInit());
            allowSecondPollToProceed.release();
            TestUtil.assertDataSetEquals(datav2.build(), this.dataSourceUpdates.awaitInit());
        }
    }

    @Test
    public void testTimeoutFromConnectionProblem() throws Exception {
        LinkedBlockingQueue<DataSourceStatusProvider.Status> statuses = new LinkedBlockingQueue<DataSourceStatusProvider.Status>();
        this.dataSourceUpdates.statusBroadcaster.register(statuses::add);
        TestPollHandler successHandler = new TestPollHandler();
        try (HttpServer server = HttpServer.start((Handler)successHandler);){
            TcpHandler errorThenSuccess = TcpHandlers.sequential((TcpHandler[])new TcpHandler[]{TcpHandlers.noResponse(), TcpHandlers.forwardToPort((int)server.getPort())});
            try (TcpServer forwardingServer = TcpServer.start((TcpHandler)errorThenSuccess);
                 PollingProcessor pollingProcessor = this.makeProcessor(forwardingServer.getHttpUri(), LENGTHY_INTERVAL);){
                Future initFuture = pollingProcessor.start();
                ConcurrentHelpers.assertFutureIsNotCompleted((Future)initFuture, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                Assert.assertFalse((boolean)initFuture.isDone());
                Assert.assertFalse((boolean)pollingProcessor.isInitialized());
                Assert.assertEquals((long)0L, (long)this.dataSourceUpdates.receivedInits.size());
                DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatus(statuses, DataSourceStatusProvider.State.INITIALIZING);
                Assert.assertNotNull((Object)status.getLastError());
                Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.NETWORK_ERROR, (Object)status.getLastError().getKind());
            }
        }
    }

    @Test
    public void testDataStoreFailure() throws Exception {
        DataStore badStore = TestComponents.dataStoreThatThrowsException(new RuntimeException("sorry"));
        TestComponents.MockDataStoreStatusProvider badStoreStatusProvider = new TestComponents.MockDataStoreStatusProvider(false);
        this.dataSourceUpdates = TestComponents.dataSourceUpdates(badStore, badStoreStatusProvider);
        LinkedBlockingQueue<DataSourceStatusProvider.Status> statuses = new LinkedBlockingQueue<DataSourceStatusProvider.Status>();
        this.dataSourceUpdates.statusBroadcaster.register(statuses::add);
        try (HttpServer server = HttpServer.start((Handler)new TestPollHandler());
             PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), LENGTHY_INTERVAL);){
            pollingProcessor.start();
            TestUtil.assertDataSetEquals(DataStoreTestTypes.DataBuilder.forStandardTypes().build(), this.dataSourceUpdates.awaitInit());
            Assert.assertFalse((boolean)pollingProcessor.isInitialized());
            DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatus(statuses, DataSourceStatusProvider.State.INITIALIZING);
            Assert.assertNotNull((Object)status.getLastError());
            Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.STORE_ERROR, (Object)status.getLastError().getKind());
        }
    }

    @Test
    public void testMalformedData() throws Exception {
        Handler badDataHandler = Handlers.bodyJson((String)"{bad");
        LinkedBlockingQueue<DataSourceStatusProvider.Status> statuses = new LinkedBlockingQueue<DataSourceStatusProvider.Status>();
        this.dataSourceUpdates.statusBroadcaster.register(statuses::add);
        try (HttpServer server = HttpServer.start((Handler)badDataHandler);
             PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), LENGTHY_INTERVAL);){
            pollingProcessor.start();
            DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatus(statuses, DataSourceStatusProvider.State.INITIALIZING);
            Assert.assertNotNull((Object)status.getLastError());
            Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.INVALID_DATA, (Object)status.getLastError().getKind());
            Assert.assertFalse((boolean)pollingProcessor.isInitialized());
        }
    }

    @Test
    public void startingWhenAlreadyStartedDoesNothing() throws Exception {
        try (HttpServer server = HttpServer.start((Handler)new TestPollHandler());
             PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), LENGTHY_INTERVAL);){
            Future initFuture1 = pollingProcessor.start();
            ConcurrentHelpers.assertFutureIsCompleted((Future)initFuture1, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            server.getRecorder().requireRequest();
            Future initFuture2 = pollingProcessor.start();
            Assert.assertSame((Object)initFuture1, (Object)initFuture2);
            server.getRecorder().requireNoRequests(Duration.ofMillis(100L));
        }
    }

    @Test
    public void http400ErrorIsRecoverable() throws Exception {
        this.testRecoverableHttpError(400);
    }

    @Test
    public void http401ErrorIsUnrecoverable() throws Exception {
        this.testUnrecoverableHttpError(401);
    }

    @Test
    public void http403ErrorIsUnrecoverable() throws Exception {
        this.testUnrecoverableHttpError(403);
    }

    @Test
    public void http408ErrorIsRecoverable() throws Exception {
        this.testRecoverableHttpError(408);
    }

    @Test
    public void http429ErrorIsRecoverable() throws Exception {
        this.testRecoverableHttpError(429);
    }

    @Test
    public void http500ErrorIsRecoverable() throws Exception {
        this.testRecoverableHttpError(500);
    }

    private void testUnrecoverableHttpError(int statusCode) throws Exception {
        TestPollHandler handler = new TestPollHandler();
        handler.setError(statusCode);
        this.withStatusQueue(statuses -> {
            try (HttpServer server = HttpServer.start((Handler)handler);
                 PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), BRIEF_INTERVAL);){
                long startTime = System.currentTimeMillis();
                Future initFuture = pollingProcessor.start();
                ConcurrentHelpers.assertFutureIsCompleted((Future)initFuture, (long)2L, (TimeUnit)TimeUnit.SECONDS);
                Assert.assertTrue((System.currentTimeMillis() - startTime < 9000L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)initFuture.isDone());
                Assert.assertFalse((boolean)pollingProcessor.isInitialized());
                this.verifyHttpErrorCausedShutdown((BlockingQueue<DataSourceStatusProvider.Status>)statuses, statusCode);
                server.getRecorder().requireRequest();
                server.getRecorder().requireNoRequests(Duration.ofMillis(100L));
            }
        });
        handler.setError(0);
        this.dataSourceUpdates = TestComponents.dataSourceUpdates((DataStore)new InMemoryDataStore(), new TestComponents.MockDataStoreStatusProvider());
        this.withStatusQueue(statuses -> {
            try (HttpServer server = HttpServer.start((Handler)handler);
                 PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), BRIEF_INTERVAL);){
                Future initFuture = pollingProcessor.start();
                ConcurrentHelpers.assertFutureIsCompleted((Future)initFuture, (long)2L, (TimeUnit)TimeUnit.SECONDS);
                Assert.assertTrue((boolean)initFuture.isDone());
                Assert.assertTrue((boolean)pollingProcessor.isInitialized());
                TestUtil.requireDataSourceStatus((BlockingQueue<DataSourceStatusProvider.Status>)statuses, DataSourceStatusProvider.State.VALID);
                handler.setError(statusCode);
                this.verifyHttpErrorCausedShutdown((BlockingQueue<DataSourceStatusProvider.Status>)statuses, statusCode);
                while (server.getRecorder().count() > 0) {
                    server.getRecorder().requireRequest();
                }
                server.getRecorder().requireNoRequests(Duration.ofMillis(100L));
            }
        });
    }

    private void verifyHttpErrorCausedShutdown(BlockingQueue<DataSourceStatusProvider.Status> statuses, int statusCode) {
        DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatusEventually(statuses, DataSourceStatusProvider.State.OFF, DataSourceStatusProvider.State.VALID);
        Assert.assertNotNull((Object)status.getLastError());
        Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, (Object)status.getLastError().getKind());
        Assert.assertEquals((long)statusCode, (long)status.getLastError().getStatusCode());
    }

    private void testRecoverableHttpError(int statusCode) throws Exception {
        TestPollHandler handler = new TestPollHandler();
        handler.setError(statusCode);
        this.withStatusQueue(statuses -> {
            try (HttpServer server = HttpServer.start((Handler)handler);
                 PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), BRIEF_INTERVAL);){
                Future initFuture = pollingProcessor.start();
                server.getRecorder().requireRequest();
                server.getRecorder().requireRequest();
                handler.setError(0);
                ConcurrentHelpers.assertFutureIsCompleted((Future)initFuture, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                DataSourceStatusProvider.Status status0 = TestUtil.requireDataSourceStatus((BlockingQueue<DataSourceStatusProvider.Status>)statuses, DataSourceStatusProvider.State.INITIALIZING);
                Assert.assertNotNull((Object)status0.getLastError());
                Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, (Object)status0.getLastError().getKind());
                Assert.assertEquals((long)statusCode, (long)status0.getLastError().getStatusCode());
                TestUtil.requireDataSourceStatusEventually(statuses, DataSourceStatusProvider.State.VALID, DataSourceStatusProvider.State.INITIALIZING);
            }
        });
        handler.setError(0);
        this.dataSourceUpdates = TestComponents.dataSourceUpdates((DataStore)new InMemoryDataStore(), new TestComponents.MockDataStoreStatusProvider());
        this.withStatusQueue(statuses -> {
            try (HttpServer server = HttpServer.start((Handler)handler);
                 PollingProcessor pollingProcessor = this.makeProcessor(server.getUri(), BRIEF_INTERVAL);){
                Future initFuture = pollingProcessor.start();
                ConcurrentHelpers.assertFutureIsCompleted((Future)initFuture, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                Assert.assertTrue((boolean)pollingProcessor.isInitialized());
                TestUtil.requireDataSourceStatus((BlockingQueue<DataSourceStatusProvider.Status>)statuses, DataSourceStatusProvider.State.VALID);
                handler.setError(statusCode);
                DataSourceStatusProvider.Status status1 = TestUtil.requireDataSourceStatus((BlockingQueue<DataSourceStatusProvider.Status>)statuses, DataSourceStatusProvider.State.INTERRUPTED);
                Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, (Object)status1.getLastError().getKind());
                Assert.assertEquals((long)statusCode, (long)status1.getLastError().getStatusCode());
                handler.setError(0);
                TestUtil.requireDataSourceStatusEventually(statuses, DataSourceStatusProvider.State.VALID, DataSourceStatusProvider.State.INTERRUPTED);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withStatusQueue(TestUtil.ActionCanThrowAnyException<BlockingQueue<DataSourceStatusProvider.Status>> action) throws Exception {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        DataSourceStatusProvider.StatusListener addStatus = statuses::add;
        this.dataSourceUpdates.statusBroadcaster.register((Object)addStatus);
        try {
            action.apply(statuses);
        }
        finally {
            this.dataSourceUpdates.statusBroadcaster.unregister((Object)addStatus);
        }
    }

    private static class TestPollHandler
    implements Handler {
        private final String data;
        private volatile int errorStatus;

        public TestPollHandler() {
            this(DataStoreTestTypes.DataBuilder.forStandardTypes());
        }

        public TestPollHandler(DataStoreTestTypes.DataBuilder data) {
            this.data = data.buildJson().toJsonString();
        }

        public void apply(RequestContext context) {
            int err = this.errorStatus;
            if (err == 0) {
                Handlers.bodyJson((String)this.data).apply(context);
            } else {
                context.setStatus(err);
            }
        }

        public void setError(int status) {
            this.errorStatus = status;
        }
    }
}

