/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.stream.JsonReader;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.StreamProcessorEvents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class StreamProcessorEventsTest {
    @Test
    public void parsingPutData() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag1").version(1000).build();
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segment1").version(1000).build();
        String allDataJson = "{\"flags\": {\"flag1\":" + JsonHelpers.serialize((Object)flag) + "},\"segments\": {\"segment1\":" + JsonHelpers.serialize((Object)segment) + "}}";
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> expectedAllData = DataStoreTestTypes.DataBuilder.forStandardTypes().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flag}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{segment}).build();
        String validInput = "{\"path\": \"/\", \"data\":" + allDataJson + "}";
        StreamProcessorEvents.PutData validResult = StreamProcessorEvents.parsePutData((JsonReader)TestUtil.jsonReaderFrom(validInput));
        MatcherAssert.assertThat((Object)validResult.path, (Matcher)Matchers.equalTo((Object)"/"));
        TestUtil.assertDataSetEquals(expectedAllData, (DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)validResult.data);
        String inputWithoutPath = "{\"data\":" + allDataJson + "}";
        StreamProcessorEvents.PutData resultWithoutPath = StreamProcessorEvents.parsePutData((JsonReader)TestUtil.jsonReaderFrom(inputWithoutPath));
        MatcherAssert.assertThat((Object)resultWithoutPath.path, (Matcher)Matchers.nullValue());
        TestUtil.assertDataSetEquals(expectedAllData, (DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)validResult.data);
        String inputWithoutData = "{\"path\":\"/\"}";
        TestUtil.assertThrows(SerializationException.class, () -> StreamProcessorEvents.parsePutData((JsonReader)TestUtil.jsonReaderFrom(inputWithoutData)));
    }

    @Test
    public void parsingPatchData() throws Exception {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("flag1").version(1000).build();
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segment1").version(1000).build();
        String flagJson = JsonHelpers.serialize((Object)flag);
        String segmentJson = JsonHelpers.serialize((Object)segment);
        String validFlagInput = "{\"path\":\"/flags/flag1\", \"data\":" + flagJson + "}";
        StreamProcessorEvents.PatchData validFlagResult = StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(validFlagInput));
        MatcherAssert.assertThat((Object)validFlagResult.kind, (Matcher)Matchers.equalTo((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)validFlagResult.key, (Matcher)Matchers.equalTo((Object)flag.getKey()));
        TestUtil.assertItemEquals((DataModel.VersionedData)flag, validFlagResult.item);
        String validSegmentInput = "{\"path\":\"/segments/segment1\", \"data\":" + segmentJson + "}";
        StreamProcessorEvents.PatchData validSegmentResult = StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(validSegmentInput));
        MatcherAssert.assertThat((Object)validSegmentResult.kind, (Matcher)Matchers.equalTo((Object)DataModel.SEGMENTS));
        MatcherAssert.assertThat((Object)validSegmentResult.key, (Matcher)Matchers.equalTo((Object)segment.getKey()));
        TestUtil.assertItemEquals((DataModel.VersionedData)segment, validSegmentResult.item);
        String validFlagInputWithDataBeforePath = "{\"data\":" + flagJson + ",\"path\":\"/flags/flag1\"}";
        StreamProcessorEvents.PatchData validFlagResultWithDataBeforePath = StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(validFlagInputWithDataBeforePath));
        MatcherAssert.assertThat((Object)validFlagResultWithDataBeforePath.kind, (Matcher)Matchers.equalTo((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)validFlagResultWithDataBeforePath.key, (Matcher)Matchers.equalTo((Object)flag.getKey()));
        TestUtil.assertItemEquals((DataModel.VersionedData)flag, validFlagResultWithDataBeforePath.item);
        String validSegmentInputWithDataBeforePath = "{\"data\":" + segmentJson + ",\"path\":\"/segments/segment1\"}";
        StreamProcessorEvents.PatchData validSegmentResultWithDataBeforePath = StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(validSegmentInputWithDataBeforePath));
        MatcherAssert.assertThat((Object)validSegmentResultWithDataBeforePath.kind, (Matcher)Matchers.equalTo((Object)DataModel.SEGMENTS));
        MatcherAssert.assertThat((Object)validSegmentResultWithDataBeforePath.key, (Matcher)Matchers.equalTo((Object)segment.getKey()));
        TestUtil.assertItemEquals((DataModel.VersionedData)segment, validSegmentResultWithDataBeforePath.item);
        String inputWithUnrecognizedPath = "{\"path\":\"/cats/lucy\", \"data\":" + flagJson + "}";
        StreamProcessorEvents.PatchData resultWithUnrecognizedPath = StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(inputWithUnrecognizedPath));
        MatcherAssert.assertThat((Object)resultWithUnrecognizedPath.kind, (Matcher)Matchers.nullValue());
        String inputWithMissingPath = "{\"data\":" + flagJson + "}";
        TestUtil.assertThrows(SerializationException.class, () -> StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(inputWithMissingPath)));
        String inputWithMissingData = "{\"path\":\"/flags/flag1\"}";
        TestUtil.assertThrows(SerializationException.class, () -> StreamProcessorEvents.parsePatchData((JsonReader)TestUtil.jsonReaderFrom(inputWithMissingData)));
    }

    @Test
    public void parsingDeleteData() {
        String validFlagInput = "{\"path\":\"/flags/flag1\", \"version\": 3}";
        StreamProcessorEvents.DeleteData validFlagResult = StreamProcessorEvents.parseDeleteData((JsonReader)TestUtil.jsonReaderFrom(validFlagInput));
        MatcherAssert.assertThat((Object)validFlagResult.kind, (Matcher)Matchers.equalTo((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)validFlagResult.key, (Matcher)Matchers.equalTo((Object)"flag1"));
        MatcherAssert.assertThat((Object)validFlagResult.version, (Matcher)Matchers.equalTo((Object)3));
        String validSegmentInput = "{\"path\":\"/segments/segment1\", \"version\": 4}";
        StreamProcessorEvents.DeleteData validSegmentResult = StreamProcessorEvents.parseDeleteData((JsonReader)TestUtil.jsonReaderFrom(validSegmentInput));
        MatcherAssert.assertThat((Object)validSegmentResult.kind, (Matcher)Matchers.equalTo((Object)DataModel.SEGMENTS));
        MatcherAssert.assertThat((Object)validSegmentResult.key, (Matcher)Matchers.equalTo((Object)"segment1"));
        MatcherAssert.assertThat((Object)validSegmentResult.version, (Matcher)Matchers.equalTo((Object)4));
        String inputWithUnrecognizedPath = "{\"path\":\"/cats/macavity\", \"version\": 9}";
        StreamProcessorEvents.DeleteData resultWithUnrecognizedPath = StreamProcessorEvents.parseDeleteData((JsonReader)TestUtil.jsonReaderFrom(inputWithUnrecognizedPath));
        MatcherAssert.assertThat((Object)resultWithUnrecognizedPath.kind, (Matcher)Matchers.nullValue());
        String inputWithMissingPath = "{\"version\": 1}";
        TestUtil.assertThrows(SerializationException.class, () -> StreamProcessorEvents.parseDeleteData((JsonReader)TestUtil.jsonReaderFrom(inputWithMissingPath)));
        String inputWithMissingVersion = "{\"path\": \"/flags/flag1\"}";
        TestUtil.assertThrows(SerializationException.class, () -> StreamProcessorEvents.parseDeleteData((JsonReader)TestUtil.jsonReaderFrom(inputWithMissingVersion)));
    }
}

