/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.internal.events.DiagnosticStore;
import com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.sdk.internal.events.EventsConfiguration;
import com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class TestComponents {
    public static ScheduledExecutorService sharedExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TestComponents-sharedExecutor-%d").build());
    public static LDLogger nullLogger = LDLogger.withAdapter((LDLogAdapter)Logs.none(), (String)"");

    public static DiagnosticStore basicDiagnosticStore() {
        return new DiagnosticStore(new DiagnosticStore.SdkDiagnosticParams("sdk_key", "sdk", "1.0.0", "Java", null, null, null));
    }

    public static ClientContextImpl clientContext(String sdkKey, LDConfig config) {
        return ClientContextImpl.fromConfig((String)sdkKey, (LDConfig)config, (ScheduledExecutorService)sharedExecutor);
    }

    public static ClientContextImpl clientContext(String sdkKey, LDConfig config, DataSourceUpdateSink dataSourceUpdateSink) {
        return ClientContextImpl.fromConfig((String)sdkKey, (LDConfig)config, (ScheduledExecutorService)sharedExecutor).withDataSourceUpdateSink(dataSourceUpdateSink);
    }

    public static HttpConfiguration defaultHttpConfiguration() {
        return TestComponents.clientContext("", LDConfig.DEFAULT).getHttp();
    }

    public static HttpProperties defaultHttpProperties() {
        return ComponentsImpl.toHttpProperties((HttpConfiguration)TestComponents.defaultHttpConfiguration());
    }

    public static DataStore dataStoreThatThrowsException(RuntimeException e) {
        return new DataStoreThatThrowsException(e);
    }

    public static MockDataSourceUpdates dataSourceUpdates(DataStore store) {
        return TestComponents.dataSourceUpdates(store, null);
    }

    public static MockDataSourceUpdates dataSourceUpdates(DataStore store, DataStoreStatusProvider dataStoreStatusProvider) {
        return new MockDataSourceUpdates(store, dataStoreStatusProvider);
    }

    static EventsConfiguration defaultEventsConfig() {
        return TestComponents.makeEventsConfig(false, null);
    }

    public static DataSource failedDataSource() {
        return new DataSourceThatNeverInitializes();
    }

    public static DataStore inMemoryDataStore() {
        return new InMemoryDataStore();
    }

    public static DataStore initedDataStore() {
        InMemoryDataStore store = new InMemoryDataStore();
        store.init(new DataStoreTypes.FullDataSet(null));
        return store;
    }

    static EventsConfiguration makeEventsConfig(boolean allAttributesPrivate, Collection<AttributeRef> privateAttributes) {
        return new EventsConfiguration(allAttributesPrivate, 0, null, EventProcessorBuilder.DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL.toMillis(), null, null, 0, null, EventProcessorBuilder.DEFAULT_FLUSH_INTERVAL.toMillis(), false, false, privateAttributes);
    }

    public static <T> ComponentConfigurer<T> specificComponent(T instance) {
        return context -> instance;
    }

    public static class MockDataStoreStatusProvider
    implements DataStoreStatusProvider {
        public final EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> statusBroadcaster = EventBroadcasterImpl.forDataStoreStatus((ExecutorService)sharedExecutor, (LDLogger)nullLogger);
        private final AtomicReference<DataStoreStatusProvider.Status> lastStatus = new AtomicReference<DataStoreStatusProvider.Status>(new DataStoreStatusProvider.Status(true, false));
        private final boolean statusMonitoringEnabled;

        public MockDataStoreStatusProvider() {
            this(true);
        }

        public MockDataStoreStatusProvider(boolean statusMonitoringEnabled) {
            this.statusMonitoringEnabled = statusMonitoringEnabled;
        }

        public void updateStatus(DataStoreStatusProvider.Status newStatus) {
            DataStoreStatusProvider.Status oldStatus;
            if (newStatus != null && !newStatus.equals((Object)(oldStatus = this.lastStatus.getAndSet(newStatus)))) {
                this.statusBroadcaster.broadcast((Object)newStatus);
            }
        }

        public DataStoreStatusProvider.Status getStatus() {
            return this.lastStatus.get();
        }

        public void addStatusListener(DataStoreStatusProvider.StatusListener listener) {
            this.statusBroadcaster.register((Object)listener);
        }

        public void removeStatusListener(DataStoreStatusProvider.StatusListener listener) {
            this.statusBroadcaster.unregister((Object)listener);
        }

        public boolean isStatusMonitoringEnabled() {
            return this.statusMonitoringEnabled;
        }

        public DataStoreStatusProvider.CacheStats getCacheStats() {
            return null;
        }
    }

    public static class DelegatingDataStore
    implements DataStore {
        private final DataStore store;
        private final Runnable preUpdateHook;

        public DelegatingDataStore(DataStore store, Runnable preUpdateHook) {
            this.store = store;
            this.preUpdateHook = preUpdateHook;
        }

        public void close() throws IOException {
            this.store.close();
        }

        public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
            if (this.preUpdateHook != null) {
                this.preUpdateHook.run();
            }
            this.store.init(allData);
        }

        public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
            return this.store.get(kind, key);
        }

        public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
            return this.store.getAll(kind);
        }

        public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            if (this.preUpdateHook != null) {
                this.preUpdateHook.run();
            }
            return this.store.upsert(kind, key, item);
        }

        public boolean isInitialized() {
            return this.store.isInitialized();
        }

        public boolean isStatusMonitoringEnabled() {
            return this.store.isStatusMonitoringEnabled();
        }

        public DataStoreStatusProvider.CacheStats getCacheStats() {
            return this.store.getCacheStats();
        }
    }

    private static class DataStoreThatThrowsException
    implements DataStore {
        private final RuntimeException e;

        DataStoreThatThrowsException(RuntimeException e) {
            this.e = e;
        }

        public void close() throws IOException {
        }

        public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
            throw this.e;
        }

        public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
            throw this.e;
        }

        public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
            throw this.e;
        }

        public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            throw this.e;
        }

        public boolean isInitialized() {
            return true;
        }

        public boolean isStatusMonitoringEnabled() {
            return false;
        }

        public DataStoreStatusProvider.CacheStats getCacheStats() {
            return null;
        }
    }

    public static class ContextCapturingFactory<T>
    implements ComponentConfigurer<T> {
        public volatile ClientContext clientContext;
        private final ComponentConfigurer<T> wrappedFactory;

        public ContextCapturingFactory(ComponentConfigurer<T> wrappedFactory) {
            this.wrappedFactory = wrappedFactory;
        }

        public T build(ClientContext context) {
            this.clientContext = context;
            return (T)this.wrappedFactory.build(context);
        }
    }

    public static class MockDataSourceUpdates
    implements DataSourceUpdateSink {
        private final DataSourceUpdatesImpl wrappedInstance;
        private final DataStoreStatusProvider dataStoreStatusProvider;
        public final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeEventBroadcaster;
        public final EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> statusBroadcaster;
        public final BlockingQueue<DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>> receivedInits = new LinkedBlockingQueue<DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>>();
        public final BlockingQueue<UpsertParams> receivedUpserts = new LinkedBlockingQueue<UpsertParams>();

        public MockDataSourceUpdates(DataStore store, DataStoreStatusProvider dataStoreStatusProvider) {
            this.dataStoreStatusProvider = dataStoreStatusProvider;
            this.flagChangeEventBroadcaster = EventBroadcasterImpl.forFlagChangeEvents((ExecutorService)sharedExecutor, (LDLogger)nullLogger);
            this.statusBroadcaster = EventBroadcasterImpl.forDataSourceStatus((ExecutorService)sharedExecutor, (LDLogger)nullLogger);
            this.wrappedInstance = new DataSourceUpdatesImpl(store, dataStoreStatusProvider, this.flagChangeEventBroadcaster, this.statusBroadcaster, sharedExecutor, null, nullLogger);
        }

        public boolean init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
            boolean result = this.wrappedInstance.init(allData);
            this.receivedInits.add(allData);
            return result;
        }

        public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            boolean result = this.wrappedInstance.upsert(kind, key, item);
            this.receivedUpserts.add(new UpsertParams(kind, key, item));
            return result;
        }

        public DataStoreStatusProvider getDataStoreStatusProvider() {
            return this.dataStoreStatusProvider;
        }

        public void updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
            this.wrappedInstance.updateStatus(newState, newError);
        }

        public DataSourceStatusProvider.Status getLastStatus() {
            return this.wrappedInstance.getLastStatus();
        }

        public void register(DataSourceStatusProvider.StatusListener listener) {
            this.statusBroadcaster.register((Object)listener);
        }

        public DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> awaitInit() {
            return (DataStoreTypes.FullDataSet)ConcurrentHelpers.awaitValue(this.receivedInits, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }

        public UpsertParams awaitUpsert() {
            return (UpsertParams)ConcurrentHelpers.awaitValue(this.receivedUpserts, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }

        public static class UpsertParams {
            public final DataStoreTypes.DataKind kind;
            public final String key;
            public final DataStoreTypes.ItemDescriptor item;

            UpsertParams(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
                this.kind = kind;
                this.key = key;
                this.item = item;
            }
        }
    }

    private static class DataSourceThatNeverInitializes
    implements DataSource {
        private DataSourceThatNeverInitializes() {
        }

        public Future<Void> start() {
            return new CompletableFuture<Void>();
        }

        public boolean isInitialized() {
            return false;
        }

        public void close() throws IOException {
        }
    }

    public static class TestEventProcessor
    implements EventProcessor {
        volatile List<Event> events = new ArrayList<Event>();
        volatile int flushCount;

        public void flush() {
            ++this.flushCount;
        }

        public void close() throws IOException {
        }

        public void recordEvaluationEvent(LDContext context, String flagKey, int flagVersion, int variation, LDValue value, EvaluationReason reason, LDValue defaultValue, String prerequisiteOfFlagKey, boolean requireFullEvent, Long debugEventsUntilDate) {
            this.events.add((Event)new Event.FeatureRequest(System.currentTimeMillis(), flagKey, context, flagVersion, variation, value, defaultValue, reason, prerequisiteOfFlagKey, requireFullEvent, debugEventsUntilDate, false));
        }

        public void recordIdentifyEvent(LDContext context) {
            this.events.add((Event)new Event.Identify(System.currentTimeMillis(), context));
        }

        public void recordCustomEvent(LDContext context, String eventKey, LDValue data, Double metricValue) {
            this.events.add((Event)new Event.Custom(System.currentTimeMillis(), eventKey, context, data, metricValue));
        }
    }
}

