/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.Assertions;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import com.launchdarkly.testhelpers.JsonAssertions;
import com.launchdarkly.testhelpers.httptest.SpecialHttpConfigurations;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class TestUtil {
    public static final Gson TEST_GSON_INSTANCE = new Gson();

    public static String getSdkVersion() {
        return "6.0.0";
    }

    public static void assertJsonEquals(LDValue expected, LDValue actual) {
        JsonAssertions.assertJsonEquals((String)expected.toJsonString(), (String)actual.toJsonString());
    }

    public static void upsertFlag(DataStore store, DataModel.FeatureFlag flag) {
        store.upsert(DataModel.FEATURES, flag.getKey(), new DataStoreTypes.ItemDescriptor(flag.getVersion(), (Object)flag));
    }

    public static void upsertSegment(DataStore store, DataModel.Segment segment) {
        store.upsert(DataModel.SEGMENTS, segment.getKey(), new DataStoreTypes.ItemDescriptor(segment.getVersion(), (Object)segment));
    }

    public static DataSourceStatusProvider.Status requireDataSourceStatus(BlockingQueue<DataSourceStatusProvider.Status> statuses, Duration timeout) {
        return (DataSourceStatusProvider.Status)ConcurrentHelpers.awaitValue(statuses, (long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static DataSourceStatusProvider.Status requireDataSourceStatus(BlockingQueue<DataSourceStatusProvider.Status> statuses) {
        return TestUtil.requireDataSourceStatus(statuses, Duration.ofSeconds(5L));
    }

    public static DataSourceStatusProvider.Status requireDataSourceStatus(BlockingQueue<DataSourceStatusProvider.Status> statuses, DataSourceStatusProvider.State expectedState, Duration timeout) {
        DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatus(statuses, timeout);
        Assert.assertEquals((Object)expectedState, (Object)status.getState());
        return status;
    }

    public static DataSourceStatusProvider.Status requireDataSourceStatus(BlockingQueue<DataSourceStatusProvider.Status> statuses, DataSourceStatusProvider.State expectedState) {
        return TestUtil.requireDataSourceStatus(statuses, expectedState, Duration.ofSeconds(5L));
    }

    public static DataSourceStatusProvider.Status requireDataSourceStatusEventually(BlockingQueue<DataSourceStatusProvider.Status> statuses, DataSourceStatusProvider.State expectedState, DataSourceStatusProvider.State possibleStateBeforeThat) {
        return (DataSourceStatusProvider.Status)Assertions.assertPolledFunctionReturnsValue((long)2L, (TimeUnit)TimeUnit.SECONDS, (long)0L, null, () -> {
            DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatus(statuses);
            if (status.getState() == expectedState) {
                return status;
            }
            Assert.assertEquals((Object)possibleStateBeforeThat, (Object)status.getState());
            return null;
        });
    }

    public static void assertDataSetEquals(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> expected, DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> actual) {
        String expectedJson = TEST_GSON_INSTANCE.toJson(DataStoreTestTypes.toDataMap(expected));
        String actualJson = TEST_GSON_INSTANCE.toJson(DataStoreTestTypes.toDataMap(actual));
        JsonAssertions.assertJsonEquals((String)expectedJson, (String)actualJson);
    }

    public static void assertItemEquals(DataModel.VersionedData expected, DataStoreTypes.ItemDescriptor item) {
        Assert.assertEquals((long)expected.getVersion(), (long)item.getVersion());
        Assert.assertEquals(expected.getClass(), item.getItem().getClass());
        JsonAssertions.assertJsonEquals((String)JsonHelpers.serialize((Object)expected), (String)JsonHelpers.serialize((Object)item.getItem()));
    }

    public static String describeDataSet(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data) {
        return Joiner.on((String)", ").join(Iterables.transform((Iterable)data.getData(), entry -> {
            DataStoreTypes.DataKind kind = (DataStoreTypes.DataKind)entry.getKey();
            return "{" + kind + ": [" + Joiner.on((String)", ").join(Iterables.transform((Iterable)((DataStoreTypes.KeyedItems)entry.getValue()).getItems(), item -> kind.serialize((DataStoreTypes.ItemDescriptor)item.getValue()))) + "]}";
        }));
    }

    public static JsonReader jsonReaderFrom(String data) {
        return new JsonReader((Reader)new StringReader(data));
    }

    public static <T extends FlagChangeEvent> void expectEvents(BlockingQueue<T> events, String ... flagKeys) {
        ImmutableSet expectedChangedFlagKeys = ImmutableSet.copyOf((Object[])flagKeys);
        HashSet<String> actualChangedFlagKeys = new HashSet<String>();
        for (int i = 0; i < expectedChangedFlagKeys.size(); ++i) {
            FlagChangeEvent e = (FlagChangeEvent)ConcurrentHelpers.awaitValue(events, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            actualChangedFlagKeys.add(e.getKey());
        }
        MatcherAssert.assertThat(actualChangedFlagKeys, (Matcher)Matchers.equalTo((Object)expectedChangedFlagKeys));
        ConcurrentHelpers.assertNoMoreValues(events, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static EvalResult simpleEvaluation(int variation, LDValue value) {
        return EvalResult.of((LDValue)value, (int)variation, (EvaluationReason)EvaluationReason.fallthrough());
    }

    public static <T> void assertFullyEqual(T a, T b) {
        Assert.assertEquals(a, b);
        Assert.assertEquals(b, a);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
    }

    public static <T> void assertFullyUnequal(T a, T b) {
        Assert.assertNotEquals(a, b);
        Assert.assertNotEquals(b, a);
    }

    public static void assertThrows(Class<?> exceptionClass, Runnable r) {
        try {
            r.run();
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)Matchers.equalTo(exceptionClass));
        }
    }

    public static HttpConfigurationBuilder makeHttpConfigurationFromTestParams(SpecialHttpConfigurations.Params params) {
        HttpConfigurationBuilder b = Components.httpConfiguration();
        if (params.getTlsConfig() != null) {
            b.sslSocketFactory(params.getTlsConfig().getSocketFactory(), params.getTlsConfig().getTrustManager());
        }
        if (params.getProxyHost() != null) {
            b.proxyHostAndPort(params.getProxyHost(), params.getProxyPort());
            if (params.getProxyBasicAuthUser() != null) {
                b.proxyAuth(Components.httpBasicAuthentication((String)params.getProxyBasicAuthUser(), (String)params.getProxyBasicAuthPassword()));
            }
        }
        if (params.getSocketFactory() != null) {
            b.socketFactory(params.getSocketFactory());
        }
        return b;
    }

    static class BuilderPropertyTestImpl<TBuilder, TBuilt, TValue>
    implements BuilderPropertyTester<TValue> {
        private final BuilderTestUtil<TBuilder, TBuilt> owner;
        private final Function<TBuilt, TValue> getter;
        private final BiConsumer<TBuilder, TValue> setter;

        public BuilderPropertyTestImpl(BuilderTestUtil<TBuilder, TBuilt> owner, Function<TBuilt, TValue> getter, BiConsumer<TBuilder, TValue> setter) {
            this.owner = owner;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void assertDefault(TValue defaultValue) {
            this.assertValue(this.owner.createBuilder(), defaultValue);
        }

        @Override
        public void assertCanSet(TValue newValue) {
            this.assertSetIsChangedTo(newValue, newValue);
        }

        @Override
        public void assertSetIsChangedTo(TValue attempted, TValue resulting) {
            TBuilder builder = this.owner.createBuilder();
            this.setter.accept(builder, attempted);
            this.assertValue(builder, resulting);
        }

        private void assertValue(TBuilder b, TValue expected) {
            Object built = this.owner.buildMethod.apply(b);
            Assert.assertEquals(expected, this.getter.apply(built));
        }
    }

    public static class BuilderTestUtil<TBuilder, TBuilt> {
        private final Supplier<TBuilder> constructor;
        final Function<TBuilder, TBuilt> buildMethod;

        public BuilderTestUtil(Supplier<TBuilder> constructor, Function<TBuilder, TBuilt> buildMethod) {
            this.constructor = constructor;
            this.buildMethod = buildMethod;
        }

        public <TValue> BuilderPropertyTester<TValue> property(Function<TBuilt, TValue> getter, BiConsumer<TBuilder, TValue> setter) {
            return new BuilderPropertyTestImpl<TBuilder, TBuilt, TValue>(this, getter, setter);
        }

        public TBuilder createBuilder() {
            return this.constructor.get();
        }
    }

    public static interface BuilderPropertyTester<TValue> {
        public void assertDefault(TValue var1);

        public void assertCanSet(TValue var1);

        public void assertSetIsChangedTo(TValue var1, TValue var2);
    }

    public static interface ActionCanThrowAnyException<T> {
        public void apply(T var1) throws Exception;
    }
}

